/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multimap;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.BatchlogManager;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.RangeSliceReply;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.ReadVerbHandler;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.Truncation;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.IsBootstrappingException;
import org.apache.cassandra.exceptions.OverloadedException;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.util.FastByteArrayOutputStream;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.metrics.ClientRequestMetrics;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.DatacenterReadCallback;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.IReadCommand;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.service.IWriteResponseHandler;
import org.apache.cassandra.service.RangeSliceResponseResolver;
import org.apache.cassandra.service.RangeSliceVerbHandler;
import org.apache.cassandra.service.ReadCallback;
import org.apache.cassandra.service.RepairCallback;
import org.apache.cassandra.service.RowDigestResolver;
import org.apache.cassandra.service.RowRepairResolver;
import org.apache.cassandra.service.StorageProxyMBean;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.TruncateResponseHandler;
import org.apache.cassandra.service.WriteResponseHandler;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageProxy
implements StorageProxyMBean {
    public static final String MBEAN_NAME = "org.apache.cassandra.db:type=StorageProxy";
    private static final Logger logger = LoggerFactory.getLogger(StorageProxy.class);
    private static final boolean OPTIMIZE_LOCAL_REQUESTS = true;
    public static final String UNREACHABLE = "UNREACHABLE";
    private static final WritePerformer standardWritePerformer;
    private static final WritePerformer counterWritePerformer;
    private static final WritePerformer counterWriteOnCoordinatorPerformer;
    public static final StorageProxy instance;
    private static volatile int maxHintsInProgress;
    private static final AtomicInteger totalHintsInProgress;
    private static final Map<InetAddress, AtomicInteger> hintsInProgress;
    private static final AtomicLong totalHints;
    private static final ClientRequestMetrics readMetrics;
    private static final ClientRequestMetrics rangeMetrics;
    private static final ClientRequestMetrics writeMetrics;

    private StorageProxy() {
    }

    public static void mutate(List<? extends IMutation> mutations, ConsistencyLevel consistency_level) throws UnavailableException, OverloadedException, WriteTimeoutException {
        logger.debug("Mutations/ConsistencyLevel are {}/{}", mutations, (Object)consistency_level);
        String localDataCenter = DatabaseDescriptor.getEndpointSnitch().getDatacenter(FBUtilities.getBroadcastAddress());
        long startTime = System.nanoTime();
        ArrayList<IWriteResponseHandler> responseHandlers = new ArrayList<IWriteResponseHandler>(mutations.size());
        IMutation mostRecentMutation = null;
        try {
            Iterator<IMutation> i$ = mutations.iterator();
            while (i$.hasNext()) {
                IMutation mutation;
                mostRecentMutation = mutation = i$.next();
                if (mutation instanceof CounterMutation) {
                    responseHandlers.add(StorageProxy.mutateCounter((CounterMutation)mutation, localDataCenter));
                    continue;
                }
                responseHandlers.add(StorageProxy.performWrite(mutation, consistency_level, localDataCenter, standardWritePerformer, null));
            }
            for (IWriteResponseHandler responseHandler : responseHandlers) {
                responseHandler.get();
            }
        }
        catch (WriteTimeoutException ex) {
            StorageProxy.writeMetrics.timeouts.mark();
            ClientRequestMetrics.writeTimeouts.inc();
            if (logger.isDebugEnabled()) {
                ArrayList<String> mstrings = new ArrayList<String>(mutations.size());
                for (IMutation iMutation : mutations) {
                    mstrings.add(iMutation.toString(true));
                }
                logger.debug("Write timeout {} for one (or more) of: {}", (Object)ex.toString(), mstrings);
            }
            throw ex;
        }
        catch (UnavailableException e) {
            StorageProxy.writeMetrics.unavailables.mark();
            ClientRequestMetrics.writeUnavailables.inc();
            throw e;
        }
        catch (OverloadedException e) {
            ClientRequestMetrics.writeUnavailables.inc();
            throw e;
        }
        catch (IOException e) {
            assert (mostRecentMutation != null);
            throw new RuntimeException("error writing key " + ByteBufferUtil.bytesToHex(mostRecentMutation.key()), e);
        }
        finally {
            writeMetrics.addNano(System.nanoTime() - startTime);
        }
    }

    public static void mutateAtomically(List<RowMutation> mutations, ConsistencyLevel consistency_level) throws UnavailableException, WriteTimeoutException {
        long startTime = System.nanoTime();
        if (logger.isDebugEnabled()) {
            logger.debug("Mutations/ConsistencyLevel are {}/{}", mutations, (Object)consistency_level);
        }
        ArrayList<WriteResponseHandlerWrapper> wrappers = new ArrayList<WriteResponseHandlerWrapper>(mutations.size());
        String localDataCenter = DatabaseDescriptor.getEndpointSnitch().getDatacenter(FBUtilities.getBroadcastAddress());
        try {
            for (RowMutation mutation : mutations) {
                WriteResponseHandlerWrapper wrapper = StorageProxy.wrapResponseHandler(mutation, consistency_level);
                wrapper.handler.assureSufficientLiveNodes();
                wrappers.add(wrapper);
            }
            Collection<InetAddress> batchlogEndpoints = StorageProxy.getBatchlogEndpoints(localDataCenter);
            UUID batchUUID = UUID.randomUUID();
            StorageProxy.syncWriteToBatchlog(mutations, localDataCenter, batchlogEndpoints, batchUUID);
            StorageProxy.syncWriteBatchedMutations(wrappers, localDataCenter, consistency_level);
            StorageProxy.asyncRemoveFromBatchlog(batchlogEndpoints, batchUUID);
        }
        catch (UnavailableException e) {
            StorageProxy.writeMetrics.unavailables.mark();
            ClientRequestMetrics.writeUnavailables.inc();
            throw e;
        }
        catch (WriteTimeoutException e) {
            StorageProxy.writeMetrics.timeouts.mark();
            ClientRequestMetrics.writeTimeouts.inc();
            throw e;
        }
        finally {
            writeMetrics.addNano(System.nanoTime() - startTime);
        }
    }

    private static void syncWriteToBatchlog(List<RowMutation> mutations, String localDataCenter, Collection<InetAddress> endpoints, UUID uuid) throws WriteTimeoutException {
        RowMutation rm = BatchlogManager.getBatchlogMutationFor(mutations, uuid);
        IWriteResponseHandler handler = WriteResponseHandler.create(endpoints, ConsistencyLevel.ONE, "system", null);
        try {
            StorageProxy.sendMessagesToOneDC(rm.createMessage(), endpoints, true, handler);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing to batchlog", e);
        }
        try {
            handler.get();
        }
        catch (WriteTimeoutException e) {
            throw new WriteTimeoutException(e.consistency, 0, e.blockFor, false);
        }
    }

    private static void asyncRemoveFromBatchlog(Collection<InetAddress> endpoints, UUID uuid) {
        RowMutation rm = new RowMutation("system", UUIDType.instance.decompose(uuid));
        rm.delete(new QueryPath("batchlog"), FBUtilities.timestampMicros());
        IWriteResponseHandler handler = WriteResponseHandler.create(endpoints, ConsistencyLevel.ANY, "system", null);
        try {
            StorageProxy.sendMessagesToOneDC(rm.createMessage(), endpoints, true, handler);
        }
        catch (IOException e) {
            throw new RuntimeException("Error deleting batch " + uuid, e);
        }
    }

    private static void syncWriteBatchedMutations(List<WriteResponseHandlerWrapper> wrappers, String localDataCenter, ConsistencyLevel consistencyLevel) throws WriteTimeoutException {
        for (WriteResponseHandlerWrapper wrapper : wrappers) {
            try {
                StorageProxy.sendToHintedEndpoints(wrapper.mutation, wrapper.endpoints, wrapper.handler, localDataCenter, consistencyLevel);
            }
            catch (IOException e) {
                throw new RuntimeException("Error writing key " + ByteBufferUtil.bytesToHex(wrapper.mutation.key()), e);
            }
            catch (OverloadedException e) {
                throw new WriteTimeoutException(consistencyLevel, -1, 0, true);
            }
        }
        for (WriteResponseHandlerWrapper wrapper : wrappers) {
            try {
                wrapper.handler.get();
            }
            catch (WriteTimeoutException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Write timeout {} for {}", (Object)e, (Object)wrapper.mutation.toString(true));
                }
                throw new WriteTimeoutException(e.consistency, -1, e.blockFor, true);
            }
        }
    }

    public static IWriteResponseHandler performWrite(IMutation mutation, ConsistencyLevel consistency_level, String localDataCenter, WritePerformer performer, Runnable callback) throws UnavailableException, OverloadedException, IOException {
        String table = mutation.getTable();
        AbstractReplicationStrategy rs = Table.open(table).getReplicationStrategy();
        Collection<InetAddress> writeEndpoints = StorageProxy.getWriteEndpoints(table, mutation.key());
        IWriteResponseHandler responseHandler = rs.getWriteResponseHandler(writeEndpoints, consistency_level, callback);
        responseHandler.assureSufficientLiveNodes();
        performer.apply(mutation, writeEndpoints, responseHandler, localDataCenter, consistency_level);
        return responseHandler;
    }

    private static WriteResponseHandlerWrapper wrapResponseHandler(RowMutation mutation, ConsistencyLevel consistency_level) {
        AbstractReplicationStrategy rs = Table.open(mutation.getTable()).getReplicationStrategy();
        Collection<InetAddress> writeEndpoints = StorageProxy.getWriteEndpoints(mutation.getTable(), mutation.key());
        IWriteResponseHandler responseHandler = rs.getWriteResponseHandler(writeEndpoints, consistency_level, null);
        return new WriteResponseHandlerWrapper(responseHandler, mutation, writeEndpoints);
    }

    public static Collection<InetAddress> getWriteEndpoints(String table, ByteBuffer key) {
        StorageService ss = StorageService.instance;
        Object tk = StorageService.getPartitioner().getToken(key);
        List<InetAddress> naturalEndpoints = ss.getNaturalEndpoints(table, (RingPosition)tk);
        return ss.getTokenMetadata().getWriteEndpoints((Token)tk, table, (Collection<InetAddress>)naturalEndpoints);
    }

    private static Collection<InetAddress> getBatchlogEndpoints(String localDataCenter) throws UnavailableException {
        TokenMetadata.Topology topology = StorageService.instance.getTokenMetadata().cloneOnlyTokenMap().getTopology();
        Collection localMembers = topology.getDatacenterEndpoints().get((Object)localDataCenter);
        if (localMembers.size() == 1) {
            return localMembers;
        }
        localMembers.remove(FBUtilities.getBroadcastAddress());
        List<InetAddress> candidates = new ArrayList<InetAddress>(localMembers.size());
        for (InetAddress member : localMembers) {
            if (!FailureDetector.instance.isAlive(member)) continue;
            candidates.add(member);
        }
        if (candidates.isEmpty()) {
            throw new UnavailableException(ConsistencyLevel.ONE, 1, 0);
        }
        if (candidates.size() > 2) {
            IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
            snitch.sortByProximity(FBUtilities.getBroadcastAddress(), candidates);
            candidates = candidates.subList(0, 2);
        }
        return candidates;
    }

    public static void sendToHintedEndpoints(RowMutation rm, Collection<InetAddress> targets, IWriteResponseHandler responseHandler, String localDataCenter, ConsistencyLevel consistency_level) throws IOException, OverloadedException {
        HashMap<String, Multimap<MessageOut, InetAddress>> dcMessages = new HashMap<String, Multimap<MessageOut, InetAddress>>(targets.size());
        for (InetAddress destination : targets) {
            if (totalHintsInProgress.get() > maxHintsInProgress && hintsInProgress.get(destination).get() > 0 && StorageProxy.shouldHint(destination)) {
                throw new OverloadedException("Too many in flight hints: " + totalHintsInProgress.get());
            }
            if (FailureDetector.instance.isAlive(destination)) {
                String dc;
                Multimap messages;
                if (destination.equals(FBUtilities.getBroadcastAddress())) {
                    StorageProxy.insertLocal(rm, responseHandler);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("insert writing key " + ByteBufferUtil.bytesToHex(rm.key()) + " to " + destination);
                }
                if ((messages = (Multimap)dcMessages.get(dc = DatabaseDescriptor.getEndpointSnitch().getDatacenter(destination))) == null) {
                    messages = HashMultimap.create();
                    dcMessages.put(dc, (Multimap<MessageOut, InetAddress>)messages);
                }
                messages.put(rm.createMessage(), (Object)destination);
                continue;
            }
            if (!StorageProxy.shouldHint(destination)) continue;
            StorageProxy.scheduleLocalHint(rm, destination, responseHandler, consistency_level);
        }
        StorageProxy.sendMessages(localDataCenter, dcMessages, responseHandler);
    }

    public static Future<Void> scheduleLocalHint(final RowMutation mutation, final InetAddress target, final IWriteResponseHandler responseHandler, final ConsistencyLevel consistencyLevel) {
        assert (!target.equals(FBUtilities.getBroadcastAddress())) : target;
        totalHintsInProgress.incrementAndGet();
        final AtomicInteger targetHints = hintsInProgress.get(target);
        targetHints.incrementAndGet();
        WrappedRunnable runnable = new WrappedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runMayThrow() throws IOException {
                if (logger.isDebugEnabled()) {
                    logger.debug("Adding hint for " + target);
                }
                try {
                    StorageProxy.writeHintForMutation(mutation, target);
                    if (responseHandler != null && consistencyLevel == ConsistencyLevel.ANY) {
                        responseHandler.response(null);
                    }
                }
                finally {
                    totalHintsInProgress.decrementAndGet();
                    targetHints.decrementAndGet();
                }
            }
        };
        return StageManager.getStage(Stage.MUTATION).submit(runnable);
    }

    public static void writeHintForMutation(RowMutation mutation, InetAddress target) throws IOException {
        UUID hostId = StorageService.instance.getTokenMetadata().getHostId(target);
        if (hostId == null && MessagingService.instance().getVersion(target) < 5) {
            logger.warn("Unable to store hint for host with missing ID, {} (old node?)", (Object)target.toString());
            return;
        }
        assert (hostId != null) : "Missing host ID for " + target.getHostAddress();
        RowMutation hintedMutation = RowMutation.hintFor(mutation, hostId);
        hintedMutation.apply();
        totalHints.incrementAndGet();
    }

    private static void sendMessages(String localDataCenter, Map<String, Multimap<MessageOut, InetAddress>> dcMessages, IWriteResponseHandler handler) throws IOException {
        for (Map.Entry<String, Multimap<MessageOut, InetAddress>> entry : dcMessages.entrySet()) {
            boolean isLocalDC = entry.getKey().equals(localDataCenter);
            for (Map.Entry messages : entry.getValue().asMap().entrySet()) {
                MessageOut message = (MessageOut)messages.getKey();
                Collection targets = (Collection)messages.getValue();
                message = message.withHeaderRemoved("FWD_TO");
                StorageProxy.sendMessagesToOneDC(message, targets, isLocalDC, handler);
            }
        }
    }

    private static void sendMessagesToOneDC(MessageOut message, Collection<InetAddress> targets, boolean localDC, IWriteResponseHandler handler) throws IOException {
        Iterator<InetAddress> iter = targets.iterator();
        InetAddress target = iter.next();
        if (localDC || MessagingService.instance().getVersion(target) < 4) {
            MessagingService.instance().sendRR(message, target, handler);
            while (iter.hasNext()) {
                target = iter.next();
                MessagingService.instance().sendRR(message, target, handler);
            }
            return;
        }
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt(targets.size() - 1);
        while (iter.hasNext()) {
            InetAddress destination = iter.next();
            CompactEndpointSerializationHelper.serialize(destination, dos);
            String id = MessagingService.instance().addCallback(handler, message, destination, message.getTimeout());
            dos.writeUTF(id);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Adding FWD message to: " + destination + " with ID " + id);
        }
        message = message.withParameter("FWD_TO", bos.toByteArray());
        String id = MessagingService.instance().sendRR(message, target, handler);
        if (logger.isDebugEnabled()) {
            logger.debug("Sending message to: " + target + " with ID " + id);
        }
    }

    private static void insertLocal(final RowMutation rm, final IWriteResponseHandler responseHandler) {
        if (logger.isDebugEnabled()) {
            logger.debug("insert writing local " + rm.toString(true));
        }
        DroppableRunnable runnable = new DroppableRunnable(MessagingService.Verb.MUTATION){

            @Override
            public void runMayThrow() throws IOException {
                rm.apply();
                responseHandler.response(null);
            }
        };
        StageManager.getStage(Stage.MUTATION).execute(runnable);
    }

    public static IWriteResponseHandler mutateCounter(CounterMutation cm, String localDataCenter) throws UnavailableException, OverloadedException, IOException {
        InetAddress endpoint = StorageProxy.findSuitableEndpoint(cm.getTable(), cm.key(), localDataCenter, cm.consistency());
        if (endpoint.equals(FBUtilities.getBroadcastAddress())) {
            return StorageProxy.applyCounterMutationOnCoordinator(cm, localDataCenter);
        }
        String table = cm.getTable();
        AbstractReplicationStrategy rs = Table.open(table).getReplicationStrategy();
        Collection<InetAddress> writeEndpoints = StorageProxy.getWriteEndpoints(table, cm.key());
        rs.getWriteResponseHandler(writeEndpoints, cm.consistency(), null).assureSufficientLiveNodes();
        IWriteResponseHandler responseHandler = WriteResponseHandler.create(endpoint);
        if (logger.isDebugEnabled()) {
            logger.debug("forwarding counter update of key " + ByteBufferUtil.bytesToHex(cm.key()) + " to " + endpoint);
        }
        MessagingService.instance().sendRR(cm.makeMutationMessage(), endpoint, responseHandler);
        return responseHandler;
    }

    private static InetAddress findSuitableEndpoint(String table, ByteBuffer key, String localDataCenter, ConsistencyLevel cl) throws UnavailableException {
        IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        List<InetAddress> endpoints = StorageService.instance.getLiveNaturalEndpoints(table, key);
        if (endpoints.isEmpty()) {
            throw new UnavailableException(cl, cl.blockFor(table), 0);
        }
        ArrayList<InetAddress> localEndpoints = new ArrayList<InetAddress>();
        for (InetAddress endpoint : endpoints) {
            if (!snitch.getDatacenter(endpoint).equals(localDataCenter)) continue;
            localEndpoints.add(endpoint);
        }
        if (localEndpoints.isEmpty()) {
            snitch.sortByProximity(FBUtilities.getBroadcastAddress(), endpoints);
            return endpoints.get(0);
        }
        return (InetAddress)localEndpoints.get(FBUtilities.threadLocalRandom().nextInt(localEndpoints.size()));
    }

    public static IWriteResponseHandler applyCounterMutationOnLeader(CounterMutation cm, String localDataCenter, Runnable callback) throws UnavailableException, IOException, OverloadedException {
        return StorageProxy.performWrite(cm, cm.consistency(), localDataCenter, counterWritePerformer, callback);
    }

    public static IWriteResponseHandler applyCounterMutationOnCoordinator(CounterMutation cm, String localDataCenter) throws UnavailableException, IOException, OverloadedException {
        return StorageProxy.performWrite(cm, cm.consistency(), localDataCenter, counterWriteOnCoordinatorPerformer, null);
    }

    private static Runnable counterWriteTask(final IMutation mutation, final Collection<InetAddress> targets, final IWriteResponseHandler responseHandler, final String localDataCenter, final ConsistencyLevel consistency_level) {
        return new DroppableRunnable(MessagingService.Verb.MUTATION){

            @Override
            public void runMayThrow() throws IOException {
                assert (mutation instanceof CounterMutation);
                final CounterMutation cm = (CounterMutation)mutation;
                cm.apply();
                responseHandler.response(null);
                targets.remove(FBUtilities.getBroadcastAddress());
                if (cm.shouldReplicateOnWrite() && !targets.isEmpty()) {
                    StageManager.getStage(Stage.REPLICATE_ON_WRITE).execute(new DroppableRunnable(MessagingService.Verb.READ){

                        @Override
                        public void runMayThrow() throws IOException, OverloadedException {
                            StorageProxy.sendToHintedEndpoints(cm.makeReplicationMutation(), targets, responseHandler, localDataCenter, consistency_level);
                        }
                    });
                }
            }
        };
    }

    private static boolean systemTableQuery(List<ReadCommand> cmds) {
        for (ReadCommand cmd : cmds) {
            if (cmd.table.equals("system")) continue;
            return false;
        }
        return true;
    }

    public static List<Row> read(List<ReadCommand> commands, ConsistencyLevel consistency_level) throws IOException, UnavailableException, IsBootstrappingException, ReadTimeoutException {
        if (StorageService.instance.isBootstrapMode() && !StorageProxy.systemTableQuery(commands)) {
            StorageProxy.readMetrics.unavailables.mark();
            ClientRequestMetrics.readUnavailables.inc();
            throw new IsBootstrappingException();
        }
        long startTime = System.nanoTime();
        List<Row> rows = null;
        try {
            rows = StorageProxy.fetchRows(commands, consistency_level);
        }
        catch (UnavailableException e) {
            StorageProxy.readMetrics.unavailables.mark();
            ClientRequestMetrics.readUnavailables.inc();
            throw e;
        }
        catch (ReadTimeoutException e) {
            StorageProxy.readMetrics.timeouts.mark();
            ClientRequestMetrics.readTimeouts.inc();
            throw e;
        }
        finally {
            readMetrics.addNano(System.nanoTime() - startTime);
        }
        return rows;
    }

    private static List<Row> fetchRows(List<ReadCommand> initialCommands, ConsistencyLevel consistency_level) throws IOException, UnavailableException, ReadTimeoutException {
        ArrayList<Row> rows = new ArrayList<Row>(initialCommands.size());
        List commandsToRetry = Collections.emptyList();
        do {
            int i;
            IAsyncCallback handler;
            List<ReadCommand> commands = commandsToRetry.isEmpty() ? initialCommands : commandsToRetry;
            ReadCallback[] readCallbacks = new ReadCallback[commands.size()];
            if (!commandsToRetry.isEmpty()) {
                logger.debug("Retrying {} commands", (Object)commandsToRetry.size());
            }
            for (int i2 = 0; i2 < commands.size(); ++i2) {
                ReadCommand command = commands.get(i2);
                assert (!command.isDigestQuery());
                logger.debug("Command/ConsistencyLevel is {}/{}", (Object)command, (Object)consistency_level);
                List<InetAddress> endpoints = StorageService.instance.getLiveNaturalEndpoints(command.table, command.key);
                DatabaseDescriptor.getEndpointSnitch().sortByProximity(FBUtilities.getBroadcastAddress(), endpoints);
                RowDigestResolver resolver = new RowDigestResolver(command.table, command.key);
                handler = StorageProxy.getReadCallback(resolver, command, consistency_level, endpoints);
                ((ReadCallback)handler).assureSufficientLiveNodes();
                assert (!((ReadCallback)handler).endpoints.isEmpty());
                readCallbacks[i2] = handler;
                InetAddress dataPoint = ((ReadCallback)handler).endpoints.get(0);
                if (dataPoint.equals(FBUtilities.getBroadcastAddress())) {
                    logger.debug("reading data locally");
                    StageManager.getStage(Stage.READ).execute(new LocalReadRunnable(command, (ReadCallback<ReadResponse, Row>)handler));
                } else {
                    logger.debug("reading data from {}", (Object)dataPoint);
                    MessagingService.instance().sendRR(command.createMessage(), dataPoint, handler);
                }
                if (((ReadCallback)handler).endpoints.size() == 1) continue;
                ReadCommand digestCommand = command.copy();
                digestCommand.setDigestQuery(true);
                MessageOut<ReadCommand> message = null;
                for (InetAddress digestPoint : ((ReadCallback)handler).endpoints.subList(1, ((ReadCallback)handler).endpoints.size())) {
                    if (digestPoint.equals(FBUtilities.getBroadcastAddress())) {
                        logger.debug("reading digest locally");
                        StageManager.getStage(Stage.READ).execute(new LocalReadRunnable(digestCommand, (ReadCallback<ReadResponse, Row>)handler));
                        continue;
                    }
                    logger.debug("reading digest from {}", (Object)digestPoint);
                    if (message == null) {
                        message = digestCommand.createMessage();
                    }
                    MessagingService.instance().sendRR(message, digestPoint, handler);
                }
            }
            ArrayList<ReadCommand> repairCommands = null;
            ArrayList<RepairCallback> repairResponseHandlers = null;
            for (i = 0; i < commands.size(); ++i) {
                ReadCallback handler2 = readCallbacks[i];
                ReadCommand command = commands.get(i);
                try {
                    long startTime2 = System.currentTimeMillis();
                    Row row = (Row)handler2.get();
                    if (row != null) {
                        command.maybeTrim(row);
                        rows.add(row);
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Read: " + (System.currentTimeMillis() - startTime2) + " ms.");
                    continue;
                }
                catch (ReadTimeoutException ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Read timeout: {}", (Object)ex.toString());
                    }
                    throw ex;
                }
                catch (DigestMismatchException ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Digest mismatch: {}", (Object)ex.toString());
                    }
                    RowRepairResolver resolver = new RowRepairResolver(command.table, command.key);
                    RepairCallback repairHandler = new RepairCallback(resolver, handler2.endpoints);
                    if (repairCommands == null) {
                        repairCommands = new ArrayList<ReadCommand>();
                        repairResponseHandlers = new ArrayList<RepairCallback>();
                    }
                    repairCommands.add(command);
                    repairResponseHandlers.add(repairHandler);
                    for (InetAddress endpoint : handler2.endpoints) {
                        MessageOut<ReadCommand> message = command.createMessage();
                        MessagingService.instance().sendRR(message, endpoint, repairHandler);
                    }
                }
            }
            if (commandsToRetry != Collections.EMPTY_LIST) {
                commandsToRetry.clear();
            }
            if (repairResponseHandlers == null) continue;
            for (i = 0; i < repairCommands.size(); ++i) {
                Row row;
                ReadCommand command = (ReadCommand)repairCommands.get(i);
                handler = (RepairCallback)repairResponseHandlers.get(i);
                try {
                    FBUtilities.waitOnFutures(((RepairCallback)handler).resolver.repairResults, DatabaseDescriptor.getWriteRpcTimeout());
                }
                catch (TimeoutException e) {
                    int blockFor = consistency_level.blockFor(command.getKeyspace());
                    throw new ReadTimeoutException(consistency_level, blockFor, blockFor, true);
                }
                try {
                    row = ((RepairCallback)handler).get();
                }
                catch (DigestMismatchException e) {
                    throw new AssertionError((Object)e);
                }
                ReadCommand retryCommand = command.maybeGenerateRetryCommand((RepairCallback)handler, row);
                if (retryCommand != null) {
                    logger.debug("issuing retry for read command");
                    if (commandsToRetry == Collections.EMPTY_LIST) {
                        commandsToRetry = new ArrayList();
                    }
                    commandsToRetry.add(retryCommand);
                    continue;
                }
                if (row == null) continue;
                command.maybeTrim(row);
                rows.add(row);
            }
        } while (!commandsToRetry.isEmpty());
        return rows;
    }

    static <TMessage, TResolved> ReadCallback<TMessage, TResolved> getReadCallback(IResponseResolver<TMessage, TResolved> resolver, IReadCommand command, ConsistencyLevel consistencyLevel, List<InetAddress> endpoints) {
        if (consistencyLevel == ConsistencyLevel.LOCAL_QUORUM || consistencyLevel == ConsistencyLevel.EACH_QUORUM) {
            return new DatacenterReadCallback((IResponseResolver)resolver, consistencyLevel, command, endpoints);
        }
        return new ReadCallback<TMessage, TResolved>(resolver, consistencyLevel, command, endpoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Row> getRangeSlice(RangeSliceCommand command, ConsistencyLevel consistency_level) throws IOException, UnavailableException, ReadTimeoutException {
        ArrayList<Row> rows;
        if (logger.isDebugEnabled()) {
            logger.debug("Command/ConsistencyLevel is {}/{}", (Object)command.toString(), (Object)consistency_level);
        }
        long startTime = System.nanoTime();
        try {
            int columnsCount = 0;
            rows = new ArrayList<Row>();
            List<AbstractBounds<RowPosition>> ranges = StorageProxy.getRestrictedRanges(command.range);
            for (AbstractBounds<RowPosition> range : ranges) {
                RangeSliceCommand nodeCmd = new RangeSliceCommand(command.keyspace, command.column_family, command.super_column, command.predicate, range, command.row_filter, command.maxResults, command.maxIsColumns, command.isPaging);
                List<InetAddress> liveEndpoints = StorageService.instance.getLiveNaturalEndpoints(nodeCmd.keyspace, (RingPosition)range.right);
                DatabaseDescriptor.getEndpointSnitch().sortByProximity(FBUtilities.getBroadcastAddress(), liveEndpoints);
                RangeSliceResponseResolver resolver = new RangeSliceResponseResolver(nodeCmd.keyspace);
                ReadCallback<RangeSliceReply, Iterable<Row>> handler = StorageProxy.getReadCallback(resolver, nodeCmd, consistency_level, liveEndpoints);
                handler.assureSufficientLiveNodes();
                resolver.setSources(handler.endpoints);
                if (handler.endpoints.size() == 1 && handler.endpoints.get(0).equals(FBUtilities.getBroadcastAddress())) {
                    logger.debug("reading data locally");
                    StageManager.getStage(Stage.READ).execute(new LocalRangeSliceRunnable(nodeCmd, handler));
                } else {
                    MessageOut<RangeSliceCommand> message = nodeCmd.createMessage();
                    for (InetAddress endpoint : handler.endpoints) {
                        MessagingService.instance().sendRR(message, endpoint, handler);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("reading " + nodeCmd + " from " + endpoint);
                    }
                }
                try {
                    for (Row row : handler.get()) {
                        rows.add(row);
                        columnsCount += row.getLiveColumnCount();
                        logger.debug("range slices read {}", (Object)row.key);
                    }
                    FBUtilities.waitOnFutures(resolver.repairResults, DatabaseDescriptor.getWriteRpcTimeout());
                }
                catch (TimeoutException ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Range slice timeout: {}", (Object)ex.toString());
                    }
                    int blockFor = consistency_level.blockFor(command.keyspace);
                    throw new ReadTimeoutException(consistency_level, blockFor, blockFor, true);
                }
                catch (DigestMismatchException e) {
                    throw new AssertionError((Object)e);
                }
                int count = nodeCmd.maxIsColumns ? columnsCount : rows.size();
                if (count < nodeCmd.maxResults) continue;
                break;
            }
        }
        finally {
            rangeMetrics.addNano(System.nanoTime() - startTime);
        }
        return StorageProxy.trim(command, rows);
    }

    private static List<Row> trim(RangeSliceCommand command, List<Row> rows) {
        if (command.maxIsColumns) {
            return rows;
        }
        return rows.size() > command.maxResults ? rows.subList(0, command.maxResults) : rows;
    }

    public static Map<String, List<String>> describeSchemaVersions() {
        String myVersion = Schema.instance.getVersion().toString();
        final ConcurrentHashMap versions = new ConcurrentHashMap();
        Set<InetAddress> liveHosts = Gossiper.instance.getLiveMembers();
        final CountDownLatch latch = new CountDownLatch(liveHosts.size());
        IAsyncCallback<UUID> cb = new IAsyncCallback<UUID>(){

            @Override
            public void response(MessageIn<UUID> message) {
                logger.debug("Received schema check response from {}", (Object)message.from.getHostAddress());
                versions.put(message.from, message.payload);
                latch.countDown();
            }

            @Override
            public boolean isLatencyForSnitch() {
                return false;
            }
        };
        MessageOut message = new MessageOut(MessagingService.Verb.SCHEMA_CHECK);
        for (InetAddress endpoint : liveHosts) {
            MessagingService.instance().sendRR(message, endpoint, cb);
        }
        try {
            latch.await(DatabaseDescriptor.getRpcTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)"This latch shouldn't have been interrupted.");
        }
        logger.debug("My version is {}", (Object)myVersion);
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        Iterable allHosts = Iterables.concat(Gossiper.instance.getLiveMembers(), Gossiper.instance.getUnreachableMembers());
        for (InetAddress inetAddress : allHosts) {
            UUID version = (UUID)versions.get(inetAddress);
            String stringVersion = version == null ? UNREACHABLE : version.toString();
            ArrayList<String> hosts = (ArrayList<String>)results.get(stringVersion);
            if (hosts == null) {
                hosts = new ArrayList<String>();
                results.put(stringVersion, hosts);
            }
            hosts.add(inetAddress.getHostAddress());
        }
        if (results.get(UNREACHABLE) != null) {
            logger.debug("Hosts not in agreement. Didn't get a response from everybody: {}", (Object)StringUtils.join((Collection)((Collection)results.get(UNREACHABLE)), (String)","));
        }
        for (Map.Entry entry : results.entrySet()) {
            if (((String)entry.getKey()).equals(UNREACHABLE) || ((String)entry.getKey()).equals(myVersion)) continue;
            for (String host : (List)entry.getValue()) {
                logger.debug("{} disagrees ({})", (Object)host, entry.getKey());
            }
        }
        if (results.size() == 1) {
            logger.debug("Schemas are in agreement.");
        }
        return results;
    }

    static <T extends RingPosition> List<AbstractBounds<T>> getRestrictedRanges(AbstractBounds<T> queryRange) {
        Token upperBoundToken;
        Object upperBound;
        if (queryRange instanceof Bounds && queryRange.left.equals(queryRange.right) && !queryRange.left.isMinimum(StorageService.getPartitioner())) {
            if (logger.isDebugEnabled()) {
                logger.debug("restricted single token match for query {}", queryRange);
            }
            return Collections.singletonList(queryRange);
        }
        TokenMetadata tokenMetadata = StorageService.instance.getTokenMetadata();
        ArrayList<AbstractBounds<T>> ranges = new ArrayList<AbstractBounds<T>>();
        Iterator<Token> ringIter = TokenMetadata.ringIterator(tokenMetadata.sortedTokens(), queryRange.left.getToken(), true);
        AbstractBounds remainder = queryRange;
        while (ringIter.hasNext() && (remainder.left.equals(upperBound = (upperBoundToken = ringIter.next()).upperBound(queryRange.left.getClass())) || remainder.contains(upperBound))) {
            Pair<AbstractBounds<T>, AbstractBounds<T>> splits = remainder.split(upperBound);
            if (splits == null) continue;
            ranges.add((AbstractBounds<T>)splits.left);
            remainder = (AbstractBounds)splits.right;
        }
        ranges.add(remainder);
        if (logger.isDebugEnabled()) {
            logger.debug("restricted ranges for query {} are {}", queryRange, ranges);
        }
        return ranges;
    }

    @Override
    public long getReadOperations() {
        return StorageProxy.readMetrics.latency.count();
    }

    @Override
    public long getTotalReadLatencyMicros() {
        return StorageProxy.readMetrics.totalLatency.count();
    }

    @Override
    public double getRecentReadLatencyMicros() {
        return readMetrics.getRecentLatency();
    }

    @Override
    public long[] getTotalReadLatencyHistogramMicros() {
        return StorageProxy.readMetrics.totalLatencyHistogram.getBuckets(false);
    }

    @Override
    public long[] getRecentReadLatencyHistogramMicros() {
        return StorageProxy.readMetrics.recentLatencyHistogram.getBuckets(true);
    }

    @Override
    public long getRangeOperations() {
        return StorageProxy.rangeMetrics.latency.count();
    }

    @Override
    public long getTotalRangeLatencyMicros() {
        return StorageProxy.rangeMetrics.totalLatency.count();
    }

    @Override
    public double getRecentRangeLatencyMicros() {
        return rangeMetrics.getRecentLatency();
    }

    @Override
    public long[] getTotalRangeLatencyHistogramMicros() {
        return StorageProxy.rangeMetrics.totalLatencyHistogram.getBuckets(false);
    }

    @Override
    public long[] getRecentRangeLatencyHistogramMicros() {
        return StorageProxy.rangeMetrics.recentLatencyHistogram.getBuckets(true);
    }

    @Override
    public long getWriteOperations() {
        return StorageProxy.writeMetrics.latency.count();
    }

    @Override
    public long getTotalWriteLatencyMicros() {
        return StorageProxy.writeMetrics.totalLatency.count();
    }

    @Override
    public double getRecentWriteLatencyMicros() {
        return writeMetrics.getRecentLatency();
    }

    @Override
    public long[] getTotalWriteLatencyHistogramMicros() {
        return StorageProxy.writeMetrics.totalLatencyHistogram.getBuckets(false);
    }

    @Override
    public long[] getRecentWriteLatencyHistogramMicros() {
        return StorageProxy.writeMetrics.recentLatencyHistogram.getBuckets(true);
    }

    @Override
    public boolean getHintedHandoffEnabled() {
        return DatabaseDescriptor.hintedHandoffEnabled();
    }

    @Override
    public void setHintedHandoffEnabled(boolean b) {
        DatabaseDescriptor.setHintedHandoffEnabled(b);
    }

    @Override
    public int getMaxHintWindow() {
        return DatabaseDescriptor.getMaxHintWindow();
    }

    @Override
    public void setMaxHintWindow(int ms) {
        DatabaseDescriptor.setMaxHintWindow(ms);
    }

    public static boolean shouldHint(InetAddress ep) {
        boolean hintWindowExpired;
        if (!DatabaseDescriptor.hintedHandoffEnabled()) {
            return false;
        }
        boolean bl = hintWindowExpired = Gossiper.instance.getEndpointDowntime(ep) > (long)DatabaseDescriptor.getMaxHintWindow();
        if (hintWindowExpired) {
            logger.debug("not hinting {} which has been down {}ms", (Object)ep, (Object)Gossiper.instance.getEndpointDowntime(ep));
        }
        return !hintWindowExpired;
    }

    public static void truncateBlocking(String keyspace, String cfname) throws UnavailableException, TimeoutException, IOException {
        logger.debug("Starting a blocking truncate operation on keyspace {}, CF ", (Object)keyspace, (Object)cfname);
        if (StorageProxy.isAnyHostDown()) {
            logger.info("Cannot perform truncate, some hosts are down");
            int liveMembers = Gossiper.instance.getLiveMembers().size();
            throw new UnavailableException(ConsistencyLevel.ALL, liveMembers + Gossiper.instance.getUnreachableMembers().size(), liveMembers);
        }
        Set<InetAddress> allEndpoints = Gossiper.instance.getLiveMembers();
        int blockFor = allEndpoints.size();
        TruncateResponseHandler responseHandler = new TruncateResponseHandler(blockFor);
        logger.debug("Starting to send truncate messages to hosts {}", allEndpoints);
        Truncation truncation = new Truncation(keyspace, cfname);
        MessageOut<Truncation> message = truncation.createMessage();
        for (InetAddress endpoint : allEndpoints) {
            MessagingService.instance().sendRR(message, endpoint, responseHandler);
        }
        logger.debug("Sent all truncate messages, now waiting for {} responses", (Object)blockFor);
        responseHandler.get();
        logger.debug("truncate done");
    }

    private static boolean isAnyHostDown() {
        return !Gossiper.instance.getUnreachableMembers().isEmpty();
    }

    @Override
    public long getTotalHints() {
        return totalHints.get();
    }

    @Override
    public int getMaxHintsInProgress() {
        return maxHintsInProgress;
    }

    @Override
    public void setMaxHintsInProgress(int qs) {
        maxHintsInProgress = qs;
    }

    @Override
    public int getHintsInProgress() {
        return totalHintsInProgress.get();
    }

    public void verifyNoHintsInProgress() {
        if (this.getHintsInProgress() > 0) {
            logger.warn("Some hints were not written before shutdown.  This is not supposed to happen.  You should (a) run repair, and (b) file a bug report");
        }
    }

    @Override
    public Long getRpcTimeout() {
        return DatabaseDescriptor.getRpcTimeout();
    }

    @Override
    public void setRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getReadRpcTimeout() {
        return DatabaseDescriptor.getReadRpcTimeout();
    }

    @Override
    public void setReadRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setReadRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getWriteRpcTimeout() {
        return DatabaseDescriptor.getWriteRpcTimeout();
    }

    @Override
    public void setWriteRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setWriteRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getRangeRpcTimeout() {
        return DatabaseDescriptor.getRangeRpcTimeout();
    }

    @Override
    public void setRangeRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setRangeRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getTruncateRpcTimeout() {
        return DatabaseDescriptor.getTruncateRpcTimeout();
    }

    @Override
    public void setTruncateRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setTruncateRpcTimeout(timeoutInMillis);
    }

    static {
        instance = new StorageProxy();
        maxHintsInProgress = 1024 * Runtime.getRuntime().availableProcessors();
        totalHintsInProgress = new AtomicInteger();
        hintsInProgress = new MapMaker().concurrencyLevel(1).makeComputingMap((Function)new Function<InetAddress, AtomicInteger>(){

            public AtomicInteger apply(InetAddress inetAddress) {
                return new AtomicInteger(0);
            }
        });
        totalHints = new AtomicLong();
        readMetrics = new ClientRequestMetrics("Read");
        rangeMetrics = new ClientRequestMetrics("RangeSlice");
        writeMetrics = new ClientRequestMetrics("Write");
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(new StorageProxy(), new ObjectName(MBEAN_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        standardWritePerformer = new WritePerformer(){

            @Override
            public void apply(IMutation mutation, Collection<InetAddress> targets, IWriteResponseHandler responseHandler, String localDataCenter, ConsistencyLevel consistency_level) throws IOException, OverloadedException {
                assert (mutation instanceof RowMutation);
                StorageProxy.sendToHintedEndpoints((RowMutation)mutation, targets, responseHandler, localDataCenter, consistency_level);
            }
        };
        counterWritePerformer = new WritePerformer(){

            @Override
            public void apply(IMutation mutation, Collection<InetAddress> targets, IWriteResponseHandler responseHandler, String localDataCenter, ConsistencyLevel consistency_level) throws IOException {
                if (logger.isDebugEnabled()) {
                    logger.debug("insert writing local & replicate " + mutation.toString(true));
                }
                Runnable runnable = StorageProxy.counterWriteTask(mutation, targets, responseHandler, localDataCenter, consistency_level);
                runnable.run();
            }
        };
        counterWriteOnCoordinatorPerformer = new WritePerformer(){

            @Override
            public void apply(IMutation mutation, Collection<InetAddress> targets, IWriteResponseHandler responseHandler, String localDataCenter, ConsistencyLevel consistency_level) throws IOException {
                if (logger.isDebugEnabled()) {
                    logger.debug("insert writing local & replicate " + mutation.toString(true));
                }
                Runnable runnable = StorageProxy.counterWriteTask(mutation, targets, responseHandler, localDataCenter, consistency_level);
                StageManager.getStage(Stage.MUTATION).execute(runnable);
            }
        };
    }

    private static abstract class DroppableRunnable
    implements Runnable {
        private final long constructionTime = System.currentTimeMillis();
        private final MessagingService.Verb verb;

        public DroppableRunnable(MessagingService.Verb verb) {
            this.verb = verb;
        }

        @Override
        public final void run() {
            if (System.currentTimeMillis() > this.constructionTime + DatabaseDescriptor.getTimeout(this.verb)) {
                MessagingService.instance().incrementDroppedMessages(this.verb);
                return;
            }
            try {
                this.runMayThrow();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract void runMayThrow() throws Exception;
    }

    public static interface WritePerformer {
        public void apply(IMutation var1, Collection<InetAddress> var2, IWriteResponseHandler var3, String var4, ConsistencyLevel var5) throws IOException, OverloadedException;
    }

    static class LocalRangeSliceRunnable
    extends DroppableRunnable {
        private final RangeSliceCommand command;
        private final ReadCallback<RangeSliceReply, Iterable<Row>> handler;
        private final long start = System.currentTimeMillis();

        LocalRangeSliceRunnable(RangeSliceCommand command, ReadCallback<RangeSliceReply, Iterable<Row>> handler) {
            super(MessagingService.Verb.READ);
            this.command = command;
            this.handler = handler;
        }

        @Override
        protected void runMayThrow() throws ExecutionException, InterruptedException {
            if (logger.isDebugEnabled()) {
                logger.debug("LocalReadRunnable reading " + this.command);
            }
            RangeSliceReply result = new RangeSliceReply(RangeSliceVerbHandler.executeLocally(this.command));
            MessagingService.instance().addLatency(FBUtilities.getBroadcastAddress(), System.currentTimeMillis() - this.start);
            this.handler.response(result);
        }
    }

    static class LocalReadRunnable
    extends DroppableRunnable {
        private final ReadCommand command;
        private final ReadCallback<ReadResponse, Row> handler;
        private final long start = System.currentTimeMillis();

        LocalReadRunnable(ReadCommand command, ReadCallback<ReadResponse, Row> handler) {
            super(MessagingService.Verb.READ);
            this.command = command;
            this.handler = handler;
        }

        @Override
        protected void runMayThrow() throws IOException {
            if (logger.isDebugEnabled()) {
                logger.debug("LocalReadRunnable reading " + this.command);
            }
            Table table = Table.open(this.command.table);
            Row r = this.command.getRow(table);
            ReadResponse result = ReadVerbHandler.getResponse(this.command, r);
            MessagingService.instance().addLatency(FBUtilities.getBroadcastAddress(), System.currentTimeMillis() - this.start);
            this.handler.response(result);
        }
    }

    private static class WriteResponseHandlerWrapper {
        final IWriteResponseHandler handler;
        final RowMutation mutation;
        final Collection<InetAddress> endpoints;

        WriteResponseHandlerWrapper(IWriteResponseHandler handler, RowMutation mutation, Collection<InetAddress> endpoints) {
            this.handler = handler;
            this.mutation = mutation;
            this.endpoints = endpoints;
        }
    }
}

