/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.service.ClientState;

public class SocketSessionManagementService {
    public static final SocketSessionManagementService instance = new SocketSessionManagementService();
    public static final ThreadLocal<SocketAddress> remoteSocket = new ThreadLocal();
    private final Map<SocketAddress, ClientState> activeSocketSessions = new ConcurrentHashMap<SocketAddress, ClientState>();

    public ClientState get(SocketAddress key) {
        ClientState retval = null;
        if (key != null) {
            retval = this.activeSocketSessions.get(key);
        }
        return retval;
    }

    public void put(SocketAddress key, ClientState value) {
        if (key != null && value != null) {
            this.activeSocketSessions.put(key, value);
        }
    }

    public boolean remove(SocketAddress key) {
        assert (key != null);
        return this.activeSocketSessions.remove(key) != null;
    }

    public void clear() {
        this.activeSocketSessions.clear();
    }
}

