/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.Collection;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.IWriteResponseHandler;
import org.apache.cassandra.service.WriteResponseHandler;
import org.apache.cassandra.utils.FBUtilities;

public class DatacenterWriteResponseHandler
extends WriteResponseHandler {
    private static final IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
    private static final String localdc = snitch.getDatacenter(FBUtilities.getBroadcastAddress());

    protected DatacenterWriteResponseHandler(Collection<InetAddress> writeEndpoints, ConsistencyLevel consistencyLevel, String table, Runnable callback) {
        super(writeEndpoints, consistencyLevel, table, callback);
        assert (consistencyLevel == ConsistencyLevel.LOCAL_QUORUM);
    }

    public static IWriteResponseHandler create(Collection<InetAddress> writeEndpoints, ConsistencyLevel consistencyLevel, String table, Runnable callback) {
        return new DatacenterWriteResponseHandler(writeEndpoints, consistencyLevel, table, callback);
    }

    @Override
    public void response(MessageIn message) {
        if ((message == null || localdc.equals(snitch.getDatacenter(message.from))) && this.responses.decrementAndGet() == 0) {
            this.signal();
        }
    }

    @Override
    public void assureSufficientLiveNodes() throws UnavailableException {
        int liveNodes = 0;
        for (InetAddress destination : this.writeEndpoints) {
            if (!localdc.equals(snitch.getDatacenter(destination)) || !FailureDetector.instance.isAlive(destination)) continue;
            ++liveNodes;
        }
        if (liveNodes < this.responses.get()) {
            throw new UnavailableException(this.consistencyLevel, this.responses.get(), liveNodes);
        }
    }
}

