/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.IWriteResponseHandler;
import org.apache.cassandra.utils.SimpleCondition;

public abstract class AbstractWriteResponseHandler
implements IWriteResponseHandler {
    private final SimpleCondition condition = new SimpleCondition();
    protected final long startTime = System.currentTimeMillis();
    protected final Collection<InetAddress> writeEndpoints;
    protected final ConsistencyLevel consistencyLevel;
    protected final Runnable callback;

    protected AbstractWriteResponseHandler(Collection<InetAddress> writeEndpoints, ConsistencyLevel consistencyLevel, Runnable callback) {
        this.consistencyLevel = consistencyLevel;
        this.writeEndpoints = writeEndpoints;
        this.callback = callback;
    }

    @Override
    public void get() throws WriteTimeoutException {
        boolean success;
        long timeout = DatabaseDescriptor.getWriteRpcTimeout() - (System.currentTimeMillis() - this.startTime);
        try {
            success = this.condition.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)ex);
        }
        if (!success) {
            throw new WriteTimeoutException(this.consistencyLevel, this.ackCount(), this.blockFor(), false);
        }
    }

    protected abstract int ackCount();

    protected abstract int blockFor();

    public abstract void response(MessageIn var1);

    @Override
    public abstract void assureSufficientLiveNodes() throws UnavailableException;

    protected void signal() {
        this.condition.signal();
        if (this.callback != null) {
            this.callback.run();
        }
    }
}

