/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import org.apache.cassandra.io.compress.CompressedRandomAccessReader;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SegmentedFile;

public class CompressedSegmentedFile
extends SegmentedFile {
    public final CompressionMetadata metadata;

    public CompressedSegmentedFile(String path, CompressionMetadata metadata) {
        super(path, metadata.dataLength, metadata.compressedFileLength);
        this.metadata = metadata;
    }

    @Override
    public FileDataInput getSegment(long position) {
        RandomAccessReader file = CompressedRandomAccessReader.open(this.path, this.metadata);
        file.seek(position);
        return file;
    }

    @Override
    public void cleanup() {
    }

    public static class Builder
    extends SegmentedFile.Builder {
        @Override
        public void addPotentialBoundary(long boundary) {
        }

        @Override
        public SegmentedFile complete(String path) {
            return new CompressedSegmentedFile(path, CompressionMetadata.create(path));
        }
    }
}

