/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.compaction.ICompactionScanner;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.ByteBufferUtil;

public class SSTableScanner
implements ICompactionScanner {
    protected final RandomAccessReader dfile;
    protected final RandomAccessReader ifile;
    public final SSTableReader sstable;
    private OnDiskAtomIterator row;
    protected boolean exhausted = false;
    protected Iterator<OnDiskAtomIterator> iterator;
    private final QueryFilter filter;

    SSTableScanner(SSTableReader sstable, boolean skipCache) {
        this.dfile = sstable.openDataReader(skipCache);
        this.ifile = sstable.openIndexReader(skipCache);
        this.sstable = sstable;
        this.filter = null;
    }

    SSTableScanner(SSTableReader sstable, QueryFilter filter) {
        this.dfile = sstable.openDataReader(false);
        this.ifile = sstable.openIndexReader(false);
        this.sstable = sstable;
        this.filter = filter;
    }

    @Override
    public void close() throws IOException {
        FileUtils.close(this.dfile, this.ifile);
    }

    public void seekTo(RowPosition seekKey) {
        try {
            long indexPosition = this.sstable.getIndexScanPosition(seekKey);
            if (indexPosition == -1L) {
                indexPosition = 0L;
            }
            this.ifile.seek(indexPosition);
            while (!this.ifile.isEOF()) {
                long startPosition = this.ifile.getFilePointer();
                DecoratedKey indexDecoratedKey = this.sstable.decodeKey(ByteBufferUtil.readWithShortLength(this.ifile));
                int comparison = indexDecoratedKey.compareTo(seekKey);
                if (comparison >= 0) {
                    long dataPosition = this.ifile.readLong();
                    this.ifile.seek(startPosition);
                    this.dfile.seek(dataPosition);
                    this.row = null;
                    return;
                }
                RowIndexEntry.serializer.skip(this.ifile, this.sstable.descriptor.version);
            }
            this.exhausted = true;
        }
        catch (IOException e) {
            this.sstable.markSuspect();
            throw new CorruptSSTableException((Exception)e, this.ifile.getPath());
        }
    }

    @Override
    public long getLengthInBytes() {
        return this.dfile.length();
    }

    @Override
    public long getCurrentPosition() {
        return this.dfile.getFilePointer();
    }

    @Override
    public String getBackingFiles() {
        return this.sstable.toString();
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.exhausted ? Arrays.asList(new OnDiskAtomIterator[0]).iterator() : this.createIterator();
        }
        return this.iterator.hasNext();
    }

    @Override
    public OnDiskAtomIterator next() {
        if (this.iterator == null) {
            this.iterator = this.exhausted ? Arrays.asList(new OnDiskAtomIterator[0]).iterator() : this.createIterator();
        }
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Iterator<OnDiskAtomIterator> createIterator() {
        return this.filter == null ? new KeyScanningIterator() : new FilteredKeyScanningIterator();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + "dfile=" + this.dfile + " ifile=" + this.ifile + " sstable=" + this.sstable + " exhausted=" + this.exhausted + ")";
    }

    protected class FilteredKeyScanningIterator
    implements Iterator<OnDiskAtomIterator> {
        protected DecoratedKey nextKey;
        protected RowIndexEntry nextEntry;

        protected FilteredKeyScanningIterator() {
        }

        @Override
        public boolean hasNext() {
            if (SSTableScanner.this.row == null) {
                return !SSTableScanner.this.ifile.isEOF();
            }
            return this.nextKey != null;
        }

        @Override
        public OnDiskAtomIterator next() {
            try {
                RowIndexEntry currentEntry;
                DecoratedKey currentKey;
                if (SSTableScanner.this.row == null) {
                    currentKey = SSTableScanner.this.sstable.decodeKey(ByteBufferUtil.readWithShortLength(SSTableScanner.this.ifile));
                    currentEntry = RowIndexEntry.serializer.deserialize(SSTableScanner.this.ifile, SSTableScanner.this.sstable.descriptor.version);
                } else {
                    currentKey = this.nextKey;
                    currentEntry = this.nextEntry;
                }
                if (SSTableScanner.this.ifile.isEOF()) {
                    this.nextKey = null;
                    this.nextEntry = null;
                } else {
                    this.nextKey = SSTableScanner.this.sstable.decodeKey(ByteBufferUtil.readWithShortLength(SSTableScanner.this.ifile));
                    this.nextEntry = RowIndexEntry.serializer.deserialize(SSTableScanner.this.ifile, SSTableScanner.this.sstable.descriptor.version);
                }
                assert (!SSTableScanner.this.dfile.isEOF());
                return SSTableScanner.this.row = SSTableScanner.this.filter.getSSTableColumnIterator(SSTableScanner.this.sstable, SSTableScanner.this.dfile, currentKey, currentEntry);
            }
            catch (IOException e) {
                SSTableScanner.this.sstable.markSuspect();
                throw new CorruptSSTableException((Exception)e, SSTableScanner.this.ifile.getPath());
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class KeyScanningIterator
    implements Iterator<OnDiskAtomIterator> {
        protected long finishedAt;

        protected KeyScanningIterator() {
        }

        @Override
        public boolean hasNext() {
            if (SSTableScanner.this.row == null) {
                return !SSTableScanner.this.dfile.isEOF();
            }
            return this.finishedAt < SSTableScanner.this.dfile.length();
        }

        @Override
        public OnDiskAtomIterator next() {
            try {
                if (SSTableScanner.this.row != null) {
                    SSTableScanner.this.dfile.seek(this.finishedAt);
                }
                assert (!SSTableScanner.this.dfile.isEOF());
                DecoratedKey key = SSTableScanner.this.sstable.decodeKey(ByteBufferUtil.readWithShortLength(SSTableScanner.this.dfile));
                long dataSize = SSTableReader.readRowSize(SSTableScanner.this.dfile, SSTableScanner.this.sstable.descriptor);
                long dataStart = SSTableScanner.this.dfile.getFilePointer();
                this.finishedAt = dataStart + dataSize;
                SSTableScanner.this.row = new SSTableIdentityIterator(SSTableScanner.this.sstable, SSTableScanner.this.dfile, key, dataStart, dataSize);
                return SSTableScanner.this.row;
            }
            catch (IOException e) {
                SSTableScanner.this.sstable.markSuspect();
                throw new CorruptSSTableException((Exception)e, SSTableScanner.this.dfile.getPath());
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + "finishedAt:" + this.finishedAt + ")";
        }
    }
}

