/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.RangeStreamer;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.streaming.OperationType;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.SimpleCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootStrapper {
    private static final Logger logger = LoggerFactory.getLogger(BootStrapper.class);
    protected final InetAddress address;
    protected final Collection<Token> tokens;
    protected final TokenMetadata tokenMetadata;
    private static final long BOOTSTRAP_TIMEOUT = 30000L;

    public BootStrapper(InetAddress address, Collection<Token> tokens, TokenMetadata tmd) {
        assert (address != null);
        assert (tokens != null && !tokens.isEmpty());
        this.address = address;
        this.tokens = tokens;
        this.tokenMetadata = tmd;
    }

    public void bootstrap() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Beginning bootstrap process");
        }
        RangeStreamer streamer = new RangeStreamer(this.tokenMetadata, this.address, OperationType.BOOTSTRAP);
        streamer.addSourceFilter(new RangeStreamer.FailureDetectorSourceFilter(FailureDetector.instance));
        for (String table : Schema.instance.getNonSystemTables()) {
            AbstractReplicationStrategy strategy = Table.open(table).getReplicationStrategy();
            streamer.addRanges(table, strategy.getPendingAddressRanges(this.tokenMetadata, this.tokens, this.address));
        }
        streamer.fetch();
        StorageService.instance.finishBootstrapping();
    }

    public static Collection<Token> getBootstrapTokens(TokenMetadata metadata, Map<InetAddress, Double> load) throws IOException, ConfigurationException {
        Collection<String> initialTokens = DatabaseDescriptor.getInitialTokens();
        if (initialTokens.size() > 0) {
            logger.debug("tokens manually specified as {}", initialTokens);
            ArrayList<Token> tokens = new ArrayList<Token>();
            for (String tokenString : initialTokens) {
                Token token = StorageService.getPartitioner().getTokenFactory().fromString(tokenString);
                if (metadata.getEndpoint(token) != null) {
                    throw new ConfigurationException("Bootstraping to existing token " + tokenString + " is not allowed (decommission/removetoken the old node first).");
                }
                tokens.add(token);
            }
            return tokens;
        }
        int numTokens = DatabaseDescriptor.getNumTokens();
        if (numTokens < 1) {
            throw new ConfigurationException("num_tokens must be >= 1");
        }
        if (numTokens == 1) {
            return Collections.singleton(BootStrapper.getBalancedToken(metadata, load));
        }
        return BootStrapper.getRandomTokens(metadata, numTokens);
    }

    public static Collection<Token> getRandomTokens(TokenMetadata metadata, int numTokens) {
        HashSet<Token> tokens = new HashSet<Token>(numTokens);
        while (tokens.size() < numTokens) {
            Object token = StorageService.getPartitioner().getRandomToken();
            if (metadata.getEndpoint((Token)token) != null) continue;
            tokens.add((Token)token);
        }
        return tokens;
    }

    @Deprecated
    public static Token getBalancedToken(TokenMetadata metadata, Map<InetAddress, Double> load) {
        InetAddress maxEndpoint = BootStrapper.getBootstrapSource(metadata, load);
        Token<?> t = BootStrapper.getBootstrapTokenFrom(maxEndpoint);
        logger.info("New token will be " + t + " to assume load from " + maxEndpoint);
        return t;
    }

    @Deprecated
    static InetAddress getBootstrapSource(final TokenMetadata metadata, final Map<InetAddress, Double> load) {
        ArrayList<InetAddress> endpoints = new ArrayList<InetAddress>(load.size());
        for (InetAddress endpoint : load.keySet()) {
            if (!metadata.isMember(endpoint) || !FailureDetector.instance.isAlive(endpoint)) continue;
            endpoints.add(endpoint);
        }
        if (endpoints.isEmpty()) {
            throw new RuntimeException("No other nodes seen!  Unable to bootstrap.If you intended to start a single-node cluster, you should make sure your broadcast_address (or listen_address) is listed as a seed.  Otherwise, you need to determine why the seed being contacted has no knowledge of the rest of the cluster.  Usually, this can be solved by giving all nodes the same seed list.");
        }
        Collections.sort(endpoints, new Comparator<InetAddress>(){

            @Override
            public int compare(InetAddress ia1, InetAddress ia2) {
                double load2;
                int n2;
                int n1 = metadata.pendingRangeChanges(ia1);
                if (n1 != (n2 = metadata.pendingRangeChanges(ia2))) {
                    return -(n1 - n2);
                }
                double load1 = (Double)load.get(ia1);
                if (load1 == (load2 = ((Double)load.get(ia2)).doubleValue())) {
                    return 0;
                }
                return load1 < load2 ? -1 : 1;
            }
        });
        InetAddress maxEndpoint = (InetAddress)endpoints.get(endpoints.size() - 1);
        assert (!maxEndpoint.equals(FBUtilities.getBroadcastAddress()));
        if (metadata.pendingRangeChanges(maxEndpoint) > 0) {
            throw new RuntimeException("Every node is a bootstrap source! Please specify an initial token manually or wait for an existing bootstrap operation to finish.");
        }
        return maxEndpoint;
    }

    @Deprecated
    static Token<?> getBootstrapTokenFrom(InetAddress maxEndpoint) {
        MessageOut message = new MessageOut(MessagingService.Verb.BOOTSTRAP_TOKEN);
        long timeout = Math.max(DatabaseDescriptor.getRpcTimeout(), 30000L);
        for (int retries = 5; retries > 0; --retries) {
            BootstrapTokenCallback btc = new BootstrapTokenCallback();
            MessagingService.instance().sendRR(message, maxEndpoint, btc, timeout);
            Token<?> token = btc.getToken(timeout);
            if (token == null) continue;
            return token;
        }
        throw new RuntimeException("Bootstrap failed, could not obtain token from: " + maxEndpoint);
    }

    public static class StringSerializer
    implements IVersionedSerializer<String> {
        public static final StringSerializer instance = new StringSerializer();

        @Override
        public void serialize(String s, DataOutput out, int version) throws IOException {
            out.writeUTF(s);
        }

        @Override
        public String deserialize(DataInput in, int version) throws IOException {
            return in.readUTF();
        }

        @Override
        public long serializedSize(String s, int version) {
            return TypeSizes.NATIVE.sizeof(s);
        }
    }

    @Deprecated
    private static class BootstrapTokenCallback
    implements IAsyncCallback<String> {
        private volatile Token<?> token;
        private final Condition condition = new SimpleCondition();

        private BootstrapTokenCallback() {
        }

        public Token<?> getToken(long timeout) {
            boolean success;
            try {
                success = this.condition.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return success ? this.token : null;
        }

        @Override
        public void response(MessageIn<String> msg) {
            this.token = StorageService.getPartitioner().getTokenFactory().fromString((String)msg.payload);
            this.condition.signalAll();
        }

        @Override
        public boolean isLatencyForSnitch() {
            return false;
        }
    }

    @Deprecated
    public static class BootstrapTokenVerbHandler
    implements IVerbHandler {
        public void doVerb(MessageIn message, String id) {
            StorageService ss = StorageService.instance;
            String tokenString = StorageService.getPartitioner().getTokenFactory().toString(ss.getBootstrapToken());
            MessageOut<String> response = new MessageOut<String>(MessagingService.Verb.INTERNAL_RESPONSE, tokenString, StringSerializer.instance);
            MessagingService.instance().sendReply(response, id, message.from);
        }
    }
}

