/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.composites;

import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.index.AbstractSimplePerColumnSecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.db.index.composites.CompositesSearcher;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.exceptions.ConfigurationException;

public class CompositesIndex
extends AbstractSimplePerColumnSecondaryIndex {
    public static final String PREFIX_SIZE_OPTION = "prefix_size";
    private CompositeType indexComparator;
    private int prefixSize;

    @Override
    public void init(ColumnDefinition columnDef) {
        assert (this.baseCfs.getComparator() instanceof CompositeType);
        try {
            this.prefixSize = Integer.parseInt(columnDef.getIndexOptions().get(PREFIX_SIZE_OPTION));
        }
        catch (NumberFormatException e) {
            throw new AssertionError((Object)e);
        }
        this.indexComparator = (CompositeType)SecondaryIndex.getIndexComparator(this.baseCfs.metadata, columnDef);
    }

    @Override
    protected ByteBuffer makeIndexColumnName(ByteBuffer rowKey, IColumn column) {
        CompositeType baseComparator = (CompositeType)this.baseCfs.getComparator();
        ByteBuffer[] components = baseComparator.split(column.name());
        CompositeType.Builder builder = new CompositeType.Builder(this.indexComparator);
        builder.add(rowKey);
        for (int i = 0; i < Math.min(this.prefixSize, components.length); ++i) {
            builder.add(components[i]);
        }
        return builder.build();
    }

    @Override
    public boolean indexes(ByteBuffer name) {
        ColumnDefinition columnDef = (ColumnDefinition)this.columnDefs.iterator().next();
        CompositeType baseComparator = (CompositeType)this.baseCfs.getComparator();
        ByteBuffer[] components = baseComparator.split(name);
        AbstractType<?> comp = this.baseCfs.metadata.getColumnDefinitionComparator(columnDef);
        return components.length > columnDef.componentIndex && comp.compare(components[columnDef.componentIndex], columnDef.name) == 0;
    }

    @Override
    public SecondaryIndexSearcher createSecondaryIndexSearcher(Set<ByteBuffer> columns) {
        return new CompositesSearcher(this.baseCfs.indexManager, columns, this.prefixSize);
    }

    @Override
    public void validateOptions() throws ConfigurationException {
        ColumnDefinition columnDef = (ColumnDefinition)this.columnDefs.iterator().next();
        String option = columnDef.getIndexOptions().get(PREFIX_SIZE_OPTION);
        if (option == null) {
            throw new ConfigurationException("Missing option prefix_size");
        }
        try {
            Integer.parseInt(option);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(String.format("Invalid non integer value for option %s (got '%s')", PREFIX_SIZE_OPTION, option));
        }
    }
}

