/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.Collection;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.DiskAwareRunnable;

public abstract class AbstractCompactionTask
extends DiskAwareRunnable {
    protected final ColumnFamilyStore cfs;
    protected Collection<SSTableReader> sstables;
    protected boolean isUserDefined;
    protected OperationType compactionType;

    public AbstractCompactionTask(ColumnFamilyStore cfs, Collection<SSTableReader> sstables) {
        this.cfs = cfs;
        this.sstables = sstables;
        this.isUserDefined = false;
        this.compactionType = OperationType.COMPACTION;
    }

    public abstract int execute(CompactionManager.CompactionExecutorStatsCollector var1);

    public ColumnFamilyStore getColumnFamilyStore() {
        return this.cfs;
    }

    public Collection<SSTableReader> getSSTables() {
        return this.sstables;
    }

    public boolean markSSTablesForCompaction() {
        int min = this.isUserDefined ? 1 : this.cfs.getMinimumCompactionThreshold();
        int max = this.isUserDefined ? Integer.MAX_VALUE : this.cfs.getMaximumCompactionThreshold();
        return this.markSSTablesForCompaction(min, max);
    }

    public boolean markSSTablesForCompaction(int min, int max) {
        Set<SSTableReader> marked = this.cfs.getDataTracker().markCompacting(this.sstables, min, max);
        if (marked == null || marked.isEmpty()) {
            this.cancel();
            return false;
        }
        this.sstables = marked;
        return true;
    }

    public void unmarkSSTables() {
        this.cfs.getDataTracker().unmarkCompacting(this.sstables);
    }

    protected void cancel() {
    }

    public AbstractCompactionTask isUserDefined(boolean isUserDefined) {
        this.isUserDefined = isUserDefined;
        return this;
    }

    public AbstractCompactionTask setCompactionType(OperationType compactionType) {
        this.compactionType = compactionType;
        return this;
    }

    public String toString() {
        return "CompactionTask(" + this.sstables + ")";
    }
}

