/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.List;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.ICompactionScanner;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.utils.CloseableIterator;

public abstract class AbstractCompactionIterable
extends CompactionInfo.Holder
implements Iterable<AbstractCompactedRow> {
    protected final OperationType type;
    protected final CompactionController controller;
    protected final long totalBytes;
    protected volatile long bytesRead;
    protected final List<ICompactionScanner> scanners;

    public AbstractCompactionIterable(CompactionController controller, OperationType type, List<ICompactionScanner> scanners) {
        this.controller = controller;
        this.type = type;
        this.scanners = scanners;
        this.bytesRead = 0L;
        long bytes = 0L;
        for (ICompactionScanner scanner : scanners) {
            bytes += scanner.getLengthInBytes();
        }
        this.totalBytes = bytes;
    }

    @Override
    public CompactionInfo getCompactionInfo() {
        return new CompactionInfo(this.controller.cfs.metadata, this.type, this.bytesRead, this.totalBytes);
    }

    @Override
    public abstract CloseableIterator<AbstractCompactedRow> iterator();
}

