/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DefsTable;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.columniterator.IdentityQueryFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.CounterId;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTable {
    private static final Logger logger = LoggerFactory.getLogger(SystemTable.class);
    public static final String PEERS_CF = "peers";
    public static final String LOCAL_CF = "local";
    public static final String INDEX_CF = "IndexInfo";
    public static final String COUNTER_ID_CF = "NodeIdInfo";
    public static final String HINTS_CF = "hints";
    public static final String RANGE_XFERS_CF = "range_xfers";
    public static final String BATCHLOG_CF = "batchlog";
    public static final String SCHEMA_KEYSPACES_CF = "schema_keyspaces";
    public static final String SCHEMA_COLUMNFAMILIES_CF = "schema_columnfamilies";
    public static final String SCHEMA_COLUMNS_CF = "schema_columns";
    @Deprecated
    public static final String OLD_STATUS_CF = "LocationInfo";
    @Deprecated
    public static final String OLD_HINTS_CF = "HintsColumnFamily";
    private static final String LOCAL_KEY = "local";
    private static final ByteBuffer CURRENT_LOCAL_NODE_ID_KEY = ByteBufferUtil.bytes("CurrentLocal");
    private static final ByteBuffer ALL_LOCAL_NODE_ID_KEY = ByteBufferUtil.bytes("Local");

    private static DecoratedKey decorate(ByteBuffer key) {
        return StorageService.getPartitioner().decorateKey(key);
    }

    public static void finishStartup() throws IOException {
        DefsTable.fixSchemaNanoTimestamps();
        SystemTable.setupVersion();
        try {
            SystemTable.upgradeSystemData();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setupVersion() {
        String req = "INSERT INTO system.%s (key, release_version, cql_version, thrift_version) VALUES ('%s', '%s', '%s', '%s')";
        QueryProcessor.processInternal(String.format(req, "local", "local", FBUtilities.getReleaseVersionString(), QueryProcessor.CQL_VERSION.toString(), "19.34.0"));
    }

    private static void upgradeSystemData() throws IOException, ExecutionException, InterruptedException {
        ColumnFamilyStore oldHintsCfs;
        Table table = Table.open("system");
        ColumnFamilyStore oldStatusCfs = table.getColumnFamilyStore(OLD_STATUS_CF);
        if (oldStatusCfs.getSSTables().size() > 0) {
            TreeSet<ByteBuffer> cols = new TreeSet<ByteBuffer>(BytesType.instance);
            cols.add(ByteBufferUtil.bytes("ClusterName"));
            cols.add(ByteBufferUtil.bytes("Token"));
            QueryFilter filter = QueryFilter.getNamesFilter(SystemTable.decorate(ByteBufferUtil.bytes("L")), new QueryPath(OLD_STATUS_CF), cols);
            ColumnFamily oldCf = oldStatusCfs.getColumnFamily(filter);
            Iterator oldColumns = oldCf.columns.iterator();
            String clusterName = ByteBufferUtil.string(((IColumn)oldColumns.next()).value());
            Token token = StorageService.getPartitioner().getTokenFactory().fromByteArray(((IColumn)oldColumns.next()).value());
            String tokenBytes = ByteBufferUtil.bytesToHex(SystemTable.serializeTokens(Collections.singleton(token)));
            String req = "INSERT INTO system.%s (key, cluster_name, token_bytes, bootstrapped) VALUES ('%s', '%s', '%s', '%s')";
            QueryProcessor.processInternal(String.format(req, "local", "local", clusterName, tokenBytes, BootstrapState.COMPLETED.name()));
            oldStatusCfs.truncate();
        }
        if ((oldHintsCfs = table.getColumnFamilyStore(OLD_HINTS_CF)).getSSTables().size() > 0) {
            logger.info("Possible old-format hints found. Truncating");
            oldHintsCfs.truncate();
        }
    }

    public static synchronized void updateTokens(InetAddress ep, Collection<Token> tokens) {
        if (ep.equals(FBUtilities.getBroadcastAddress())) {
            SystemTable.removeTokens(tokens);
            return;
        }
        IPartitioner p = StorageService.getPartitioner();
        for (Token token : tokens) {
            String req = "INSERT INTO system.%s (token_bytes, peer) VALUES ('%s', '%s')";
            String tokenBytes = ByteBufferUtil.bytesToHex(p.getTokenFactory().toByteArray(token));
            QueryProcessor.processInternal(String.format(req, PEERS_CF, tokenBytes, ep.getHostAddress()));
        }
        SystemTable.forceBlockingFlush(PEERS_CF);
    }

    public static synchronized void removeTokens(Collection<Token> tokens) {
        IPartitioner p = StorageService.getPartitioner();
        for (Token token : tokens) {
            String req = "DELETE FROM system.%s WHERE token_bytes = '%s'";
            String tokenBytes = ByteBufferUtil.bytesToHex(p.getTokenFactory().toByteArray(token));
            QueryProcessor.processInternal(String.format(req, PEERS_CF, tokenBytes));
        }
        SystemTable.forceBlockingFlush(PEERS_CF);
    }

    public static synchronized void updateTokens(Collection<Token> tokens) {
        String req = "INSERT INTO system.%s (key, token_bytes) VALUES ('%s', '%s')";
        String tokenBytes = ByteBufferUtil.bytesToHex(SystemTable.serializeTokens(tokens));
        QueryProcessor.processInternal(String.format(req, "local", "local", tokenBytes));
        SystemTable.forceBlockingFlush("local");
    }

    public static synchronized Collection<Token> updateLocalTokens(Collection<Token> addTokens, Collection<Token> rmTokens) {
        Collection<Token> tokens = SystemTable.getSavedTokens();
        tokens.removeAll(rmTokens);
        tokens.addAll(addTokens);
        SystemTable.updateTokens(tokens);
        return tokens;
    }

    private static ByteBuffer serializeTokens(Collection<Token> tokens) {
        int estCapacity = tokens.size() * 16 + tokens.size() * 2;
        ByteBuffer toks = ByteBuffer.allocate(estCapacity);
        IPartitioner p = StorageService.getPartitioner();
        for (Token token : tokens) {
            ByteBuffer tokenBytes = p.getTokenFactory().toByteArray(token);
            if (toks.remaining() < 2 + tokenBytes.remaining()) {
                ByteBuffer newToks = ByteBuffer.allocate(estCapacity *= 2);
                toks.flip();
                newToks.put(toks);
                toks = newToks;
            }
            toks.putShort((short)tokenBytes.remaining());
            toks.put(tokenBytes);
        }
        toks.flip();
        return toks;
    }

    private static Collection<Token> deserializeTokens(ByteBuffer tokenBytes) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        IPartitioner p = StorageService.getPartitioner();
        while (tokenBytes.hasRemaining()) {
            short len = tokenBytes.getShort();
            ByteBuffer dup = tokenBytes.slice();
            dup.limit(len);
            tokenBytes.position(tokenBytes.position() + len);
            tokens.add(p.getTokenFactory().fromByteArray(dup));
        }
        return tokens;
    }

    private static void forceBlockingFlush(String cfname) {
        try {
            Table.open("system").getColumnFamilyStore(cfname).forceBlockingFlush();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Multimap<InetAddress, Token> loadTokens() {
        IPartitioner p = StorageService.getPartitioner();
        HashMultimap tokenMap = HashMultimap.create();
        for (UntypedResultSet.Row row : QueryProcessor.processInternal("SELECT * FROM system.peers")) {
            tokenMap.put((Object)row.getInetAddress("peer"), p.getTokenFactory().fromByteArray(row.getBytes("token_bytes")));
        }
        return tokenMap;
    }

    public static void checkHealth() throws ConfigurationException {
        Table table;
        try {
            table = Table.open("system");
        }
        catch (AssertionError err) {
            ConfigurationException ex = new ConfigurationException("Could not read system table!");
            ex.initCause((Throwable)((Object)err));
            throw ex;
        }
        ColumnFamilyStore cfs = table.getColumnFamilyStore("local");
        String req = "SELECT cluster_name FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.processInternal(String.format(req, "local", "local"));
        if (result.isEmpty() || !result.one().has("cluster_name")) {
            if (!cfs.getSSTables().isEmpty()) {
                throw new ConfigurationException("Found system table files, but they couldn't be loaded!");
            }
            req = "INSERT INTO system.%s (key, cluster_name) VALUES ('%s', '%s')";
            QueryProcessor.processInternal(String.format(req, "local", "local", DatabaseDescriptor.getClusterName()));
            return;
        }
        String savedClusterName = result.one().getString("cluster_name");
        if (!DatabaseDescriptor.getClusterName().equals(savedClusterName)) {
            throw new ConfigurationException("Saved cluster name " + savedClusterName + " != configured name " + DatabaseDescriptor.getClusterName());
        }
    }

    public static Collection<Token> getSavedTokens() {
        String req = "SELECT token_bytes FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.processInternal(String.format(req, "local", "local"));
        return result.isEmpty() || !result.one().has("token_bytes") ? Collections.emptyList() : SystemTable.deserializeTokens(result.one().getBytes("token_bytes"));
    }

    public static int incrementAndGetGeneration() {
        int generation;
        String req = "SELECT gossip_generation FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.processInternal(String.format(req, "local", "local"));
        if (result.isEmpty() || !result.one().has("gossip_generation")) {
            generation = (int)(System.currentTimeMillis() / 1000L);
        } else {
            int now;
            int storedGeneration = result.one().getInt("gossip_generation") + 1;
            if (storedGeneration >= (now = (int)(System.currentTimeMillis() / 1000L))) {
                logger.warn("Using stored Gossip Generation {} as it is greater than current system time {}.  See CASSANDRA-3654 if you experience problems", (Object)storedGeneration, (Object)now);
                generation = storedGeneration;
            } else {
                generation = now;
            }
        }
        req = "INSERT INTO system.%s (key, gossip_generation) VALUES ('%s', %d)";
        QueryProcessor.processInternal(String.format(req, "local", "local", generation));
        SystemTable.forceBlockingFlush("local");
        return generation;
    }

    public static BootstrapState getBootstrapState() {
        String req = "SELECT bootstrapped FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.processInternal(String.format(req, "local", "local"));
        if (result.isEmpty() || !result.one().has("bootstrapped")) {
            return BootstrapState.NEEDS_BOOTSTRAP;
        }
        return BootstrapState.valueOf(result.one().getString("bootstrapped"));
    }

    public static boolean bootstrapComplete() {
        return SystemTable.getBootstrapState() == BootstrapState.COMPLETED;
    }

    public static boolean bootstrapInProgress() {
        return SystemTable.getBootstrapState() == BootstrapState.IN_PROGRESS;
    }

    public static void setBootstrapState(BootstrapState state) {
        String req = "INSERT INTO system.%s (key, bootstrapped) VALUES ('%s', '%s')";
        QueryProcessor.processInternal(String.format(req, "local", "local", state.name()));
        SystemTable.forceBlockingFlush("local");
    }

    public static boolean isIndexBuilt(String table, String indexName) {
        QueryFilter filter;
        ColumnFamilyStore cfs = Table.open("system").getColumnFamilyStore(INDEX_CF);
        return ColumnFamilyStore.removeDeleted(cfs.getColumnFamily(filter = QueryFilter.getNamesFilter(SystemTable.decorate(ByteBufferUtil.bytes(table)), new QueryPath(INDEX_CF), ByteBufferUtil.bytes(indexName))), Integer.MAX_VALUE) != null;
    }

    public static void setIndexBuilt(String table, String indexName) {
        ColumnFamily cf = ColumnFamily.create("system", INDEX_CF);
        cf.addColumn(new Column(ByteBufferUtil.bytes(indexName), ByteBufferUtil.EMPTY_BYTE_BUFFER, FBUtilities.timestampMicros()));
        RowMutation rm = new RowMutation("system", ByteBufferUtil.bytes(table));
        rm.add(cf);
        rm.apply();
        SystemTable.forceBlockingFlush(INDEX_CF);
    }

    public static void setIndexRemoved(String table, String indexName) {
        RowMutation rm = new RowMutation("system", ByteBufferUtil.bytes(table));
        rm.delete(new QueryPath(INDEX_CF, null, ByteBufferUtil.bytes(indexName)), FBUtilities.timestampMicros());
        rm.apply();
        SystemTable.forceBlockingFlush(INDEX_CF);
    }

    public static UUID getLocalHostId() {
        UUID hostId = null;
        String req = "SELECT ring_id FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.processInternal(String.format(req, "local", "local"));
        if (!result.isEmpty() && result.one().has("ring_id")) {
            return result.one().getUUID("ring_id");
        }
        hostId = UUID.randomUUID();
        logger.warn("No host ID found, created {} (Note: This should happen exactly once per node).", (Object)hostId);
        req = "INSERT INTO system.%s (key, ring_id) VALUES ('%s', '%s')";
        QueryProcessor.processInternal(String.format(req, "local", "local", hostId));
        return hostId;
    }

    public static CounterId getCurrentLocalCounterId() {
        Object id = null;
        Table table = Table.open("system");
        QueryFilter filter = QueryFilter.getSliceFilter(SystemTable.decorate(ALL_LOCAL_NODE_ID_KEY), new QueryPath(COUNTER_ID_CF), ByteBufferUtil.EMPTY_BYTE_BUFFER, ByteBufferUtil.EMPTY_BYTE_BUFFER, true, 1);
        ColumnFamily cf = table.getColumnFamilyStore(COUNTER_ID_CF).getColumnFamily(filter);
        if (cf != null && cf.getColumnCount() != 0) {
            return CounterId.wrap(cf.iterator().next().name());
        }
        return null;
    }

    public static void writeCurrentLocalCounterId(CounterId oldCounterId, CounterId newCounterId, long now) {
        ByteBuffer ip = ByteBuffer.wrap(FBUtilities.getBroadcastAddress().getAddress());
        ColumnFamily cf = ColumnFamily.create("system", COUNTER_ID_CF);
        cf.addColumn(new Column(newCounterId.bytes(), ip, now));
        RowMutation rm = new RowMutation("system", ALL_LOCAL_NODE_ID_KEY);
        rm.add(cf);
        rm.apply();
        SystemTable.forceBlockingFlush(COUNTER_ID_CF);
    }

    public static List<CounterId.CounterIdRecord> getOldLocalCounterIds() {
        ArrayList<CounterId.CounterIdRecord> l = new ArrayList<CounterId.CounterIdRecord>();
        Table table = Table.open("system");
        QueryFilter filter = QueryFilter.getIdentityFilter(SystemTable.decorate(ALL_LOCAL_NODE_ID_KEY), new QueryPath(COUNTER_ID_CF));
        ColumnFamily cf = table.getColumnFamilyStore(COUNTER_ID_CF).getColumnFamily(filter);
        CounterId previous = null;
        for (IColumn c : cf) {
            if (previous != null) {
                l.add(new CounterId.CounterIdRecord(previous, c.timestamp()));
            }
            previous = CounterId.wrap(c.name());
        }
        return l;
    }

    public static ColumnFamilyStore schemaCFS(String cfName) {
        return Table.open("system").getColumnFamilyStore(cfName);
    }

    public static List<Row> serializedSchema() {
        ArrayList<Row> schema = new ArrayList<Row>(3);
        schema.addAll(SystemTable.serializedSchema(SCHEMA_KEYSPACES_CF));
        schema.addAll(SystemTable.serializedSchema(SCHEMA_COLUMNFAMILIES_CF));
        schema.addAll(SystemTable.serializedSchema(SCHEMA_COLUMNS_CF));
        return schema;
    }

    public static List<Row> serializedSchema(String schemaCfName) {
        Object minToken = StorageService.getPartitioner().getMinimumToken();
        return SystemTable.schemaCFS(schemaCfName).getRangeSlice(null, new Range<RowPosition>(((Token)minToken).minKeyBound(), ((Token)minToken).maxKeyBound()), Integer.MAX_VALUE, new IdentityQueryFilter(), null);
    }

    public static Collection<RowMutation> serializeSchema() {
        HashMap<DecoratedKey, RowMutation> mutationMap = new HashMap<DecoratedKey, RowMutation>();
        SystemTable.serializeSchema(mutationMap, SCHEMA_KEYSPACES_CF);
        SystemTable.serializeSchema(mutationMap, SCHEMA_COLUMNFAMILIES_CF);
        SystemTable.serializeSchema(mutationMap, SCHEMA_COLUMNS_CF);
        return mutationMap.values();
    }

    private static void serializeSchema(Map<DecoratedKey, RowMutation> mutationMap, String schemaCfName) {
        for (Row schemaRow : SystemTable.serializedSchema(schemaCfName)) {
            RowMutation mutation = mutationMap.get(schemaRow.key);
            if (mutation == null) {
                mutationMap.put(schemaRow.key, new RowMutation("system", schemaRow));
                continue;
            }
            mutation.add(schemaRow.cf);
        }
    }

    public static Map<DecoratedKey, ColumnFamily> getSchema(String cfName) {
        HashMap<DecoratedKey, ColumnFamily> schema = new HashMap<DecoratedKey, ColumnFamily>();
        for (Row schemaEntity : SystemTable.serializedSchema(cfName)) {
            schema.put(schemaEntity.key, schemaEntity.cf);
        }
        return schema;
    }

    public static ByteBuffer getSchemaKSKey(String ksName) {
        return AsciiType.instance.fromString(ksName);
    }

    public static Row readSchemaRow(String ksName) {
        DecoratedKey key = StorageService.getPartitioner().decorateKey(SystemTable.getSchemaKSKey(ksName));
        ColumnFamilyStore schemaCFS = SystemTable.schemaCFS(SCHEMA_KEYSPACES_CF);
        ColumnFamily result = schemaCFS.getColumnFamily(QueryFilter.getIdentityFilter(key, new QueryPath(SCHEMA_KEYSPACES_CF)));
        return new Row(key, result);
    }

    public static Row readSchemaRow(String ksName, String cfName) {
        DecoratedKey key = StorageService.getPartitioner().decorateKey(SystemTable.getSchemaKSKey(ksName));
        ColumnFamilyStore schemaCFS = SystemTable.schemaCFS(SCHEMA_COLUMNFAMILIES_CF);
        ColumnFamily result = schemaCFS.getColumnFamily(key, new QueryPath(SCHEMA_COLUMNFAMILIES_CF), DefsTable.searchComposite(cfName, true), DefsTable.searchComposite(cfName, false), false, Integer.MAX_VALUE);
        return new Row(key, result);
    }

    public static enum BootstrapState {
        NEEDS_BOOTSTRAP,
        COMPLETED,
        IN_PROGRESS;

    }
}

