/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ISortedColumns;
import org.apache.cassandra.db.TreeMapBackedSortedColumns;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IColumnSerializer;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;

public class Row {
    public static final RowSerializer serializer = new RowSerializer();
    public final DecoratedKey key;
    public final ColumnFamily cf;

    public Row(DecoratedKey key, ColumnFamily cf) {
        assert (key != null);
        this.key = key;
        this.cf = cf;
    }

    public int getLiveColumnCount() {
        return this.cf == null ? 0 : this.cf.getLiveColumnCount();
    }

    public String toString() {
        return "Row(key=" + this.key + ", cf=" + this.cf + ')';
    }

    public static class RowSerializer
    implements IVersionedSerializer<Row> {
        @Override
        public void serialize(Row row, DataOutput dos, int version) throws IOException {
            ByteBufferUtil.writeWithShortLength(row.key.key, dos);
            ColumnFamily.serializer.serialize(row.cf, dos, version);
        }

        public Row deserialize(DataInput dis, int version, IColumnSerializer.Flag flag, ISortedColumns.Factory factory) throws IOException {
            return new Row(StorageService.getPartitioner().decorateKey(ByteBufferUtil.readWithShortLength(dis)), ColumnFamily.serializer.deserialize(dis, flag, factory, version));
        }

        @Override
        public Row deserialize(DataInput dis, int version) throws IOException {
            return this.deserialize(dis, version, IColumnSerializer.Flag.LOCAL, TreeMapBackedSortedColumns.factory());
        }

        @Override
        public long serializedSize(Row row, int version) {
            int keySize = row.key.key.remaining();
            return (long)(TypeSizes.NATIVE.sizeof((short)keySize) + keySize) + ColumnFamily.serializer.serializedSize(row.cf, TypeSizes.NATIVE, version);
        }
    }
}

