/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.IFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.TBinaryProtocol;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TProtocolFactory;

class RangeSliceCommandSerializer
implements IVersionedSerializer<RangeSliceCommand> {
    RangeSliceCommandSerializer() {
    }

    public static SlicePredicate asSlicePredicate(IFilter predicate) {
        SlicePredicate sp = new SlicePredicate();
        if (predicate instanceof NamesQueryFilter) {
            sp.setColumn_names(new ArrayList<ByteBuffer>(((NamesQueryFilter)predicate).columns));
        } else {
            SliceQueryFilter sqf = (SliceQueryFilter)predicate;
            sp.setSlice_range(new SliceRange(sqf.start(), sqf.finish(), sqf.reversed, sqf.count));
        }
        return sp;
    }

    @Override
    public void serialize(RangeSliceCommand sliceCommand, DataOutput dos, int version) throws IOException {
        dos.writeUTF(sliceCommand.keyspace);
        dos.writeUTF(sliceCommand.column_family);
        ByteBuffer sc = sliceCommand.super_column;
        dos.writeInt(sc == null ? 0 : sc.remaining());
        if (sc != null) {
            ByteBufferUtil.write(sc, dos);
        }
        if (version < 5) {
            FBUtilities.serialize(new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory()), (TBase)RangeSliceCommandSerializer.asSlicePredicate(sliceCommand.predicate), dos);
        } else {
            IFilter.Serializer.instance.serialize(sliceCommand.predicate, dos, version);
        }
        if (version >= 4) {
            if (sliceCommand.row_filter == null) {
                dos.writeInt(0);
            } else {
                dos.writeInt(sliceCommand.row_filter.size());
                for (IndexExpression expr : sliceCommand.row_filter) {
                    if (version < 5) {
                        FBUtilities.serialize(new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory()), (TBase)expr, dos);
                        continue;
                    }
                    ByteBufferUtil.writeWithShortLength(expr.column_name, dos);
                    dos.writeInt(expr.op.getValue());
                    ByteBufferUtil.writeWithShortLength(expr.value, dos);
                }
            }
        }
        AbstractBounds.serializer.serialize(sliceCommand.range, dos, version);
        dos.writeInt(sliceCommand.maxResults);
        if (version >= 4) {
            dos.writeBoolean(sliceCommand.maxIsColumns);
            dos.writeBoolean(sliceCommand.isPaging);
        }
    }

    @Override
    public RangeSliceCommand deserialize(DataInput dis, int version) throws IOException {
        IFilter predicate;
        String keyspace = dis.readUTF();
        String columnFamily = dis.readUTF();
        int scLength = dis.readInt();
        ByteBuffer superColumn = null;
        if (scLength > 0) {
            byte[] buf = new byte[scLength];
            dis.readFully(buf);
            superColumn = ByteBuffer.wrap(buf);
        }
        AbstractType<?> comparator = ColumnFamily.getComparatorFor(keyspace, columnFamily, superColumn);
        if (version < 5) {
            SlicePredicate pred = new SlicePredicate();
            FBUtilities.deserialize(new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory()), (TBase)pred, dis);
            predicate = ThriftValidation.asIFilter(pred, comparator);
        } else {
            predicate = IFilter.Serializer.instance.deserialize(dis, version, comparator);
        }
        ArrayList<IndexExpression> rowFilter = null;
        if (version >= 4) {
            int filterCount = dis.readInt();
            rowFilter = new ArrayList<IndexExpression>(filterCount);
            for (int i = 0; i < filterCount; ++i) {
                IndexExpression expr;
                if (version < 5) {
                    expr = new IndexExpression();
                    FBUtilities.deserialize(new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory()), (TBase)expr, dis);
                } else {
                    expr = new IndexExpression(ByteBufferUtil.readWithShortLength(dis), IndexOperator.findByValue((int)dis.readInt()), ByteBufferUtil.readWithShortLength(dis));
                }
                rowFilter.add(expr);
            }
        }
        AbstractBounds<RowPosition> range = ((AbstractBounds)AbstractBounds.serializer.deserialize(dis, version)).toRowBounds();
        int maxResults = dis.readInt();
        boolean maxIsColumns = false;
        boolean isPaging = false;
        if (version >= 4) {
            maxIsColumns = dis.readBoolean();
            isPaging = dis.readBoolean();
        }
        return new RangeSliceCommand(keyspace, columnFamily, superColumn, predicate, range, rowFilter, maxResults, maxIsColumns, isPaging);
    }

    @Override
    public long serializedSize(RangeSliceCommand rsc, int version) {
        long size = TypeSizes.NATIVE.sizeof(rsc.keyspace);
        size += (long)TypeSizes.NATIVE.sizeof(rsc.column_family);
        ByteBuffer sc = rsc.super_column;
        if (sc != null) {
            size += (long)TypeSizes.NATIVE.sizeof(sc.remaining());
            size += (long)sc.remaining();
        } else {
            size += (long)TypeSizes.NATIVE.sizeof(0);
        }
        if (version < 5) {
            TSerializer ser = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
            try {
                int predicateLength = ser.serialize((TBase)RangeSliceCommandSerializer.asSlicePredicate(rsc.predicate)).length;
                if (version < 5) {
                    size += (long)TypeSizes.NATIVE.sizeof(predicateLength);
                }
                size += (long)predicateLength;
            }
            catch (TException e) {
                throw new RuntimeException(e);
            }
        } else {
            size += IFilter.Serializer.instance.serializedSize(rsc.predicate, version);
        }
        if (version >= 4) {
            if (rsc.row_filter == null) {
                size += (long)TypeSizes.NATIVE.sizeof(0);
            } else {
                size += (long)TypeSizes.NATIVE.sizeof(rsc.row_filter.size());
                for (IndexExpression expr : rsc.row_filter) {
                    if (version < 5) {
                        try {
                            int filterLength = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory()).serialize((TBase)expr).length;
                            size += (long)TypeSizes.NATIVE.sizeof(filterLength);
                            size += (long)filterLength;
                            continue;
                        }
                        catch (TException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    size += (long)TypeSizes.NATIVE.sizeofWithShortLength(expr.column_name);
                    size += (long)TypeSizes.NATIVE.sizeof(expr.op.getValue());
                    size += (long)TypeSizes.NATIVE.sizeofWithLength(expr.value);
                }
            }
        }
        size += AbstractBounds.serializer.serializedSize(rsc.range, version);
        size += (long)TypeSizes.NATIVE.sizeof(rsc.maxResults);
        if (version >= 4) {
            size += (long)TypeSizes.NATIVE.sizeof(rsc.maxIsColumns);
            size += (long)TypeSizes.NATIVE.sizeof(rsc.isPaging);
        }
        return size;
    }
}

