/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.CqlLexer;
import org.apache.cassandra.cql3.CqlParser;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.IFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.SemanticVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryProcessor {
    public static final SemanticVersion CQL_VERSION = new SemanticVersion("3.0.0-beta1");
    private static final Logger logger = LoggerFactory.getLogger(QueryProcessor.class);

    public static void validateKey(ByteBuffer key) throws InvalidRequestException {
        if (key == null || key.remaining() == 0) {
            throw new InvalidRequestException("Key may not be empty");
        }
        if (key.remaining() > 65535) {
            throw new InvalidRequestException("Key length of " + key.remaining() + " is longer than maximum of " + 65535);
        }
    }

    public static void validateColumnNames(Iterable<ByteBuffer> columns) throws InvalidRequestException {
        for (ByteBuffer name : columns) {
            if (name.remaining() > 65535) {
                throw new InvalidRequestException(String.format("column name is too long (%s > %s)", name.remaining(), 65535));
            }
            if (name.remaining() != 0) continue;
            throw new InvalidRequestException("zero-length column name");
        }
    }

    public static void validateColumnName(ByteBuffer column) throws InvalidRequestException {
        QueryProcessor.validateColumnNames(Collections.singletonList(column));
    }

    public static void validateFilter(CFMetaData metadata, IFilter filter) throws InvalidRequestException {
        if (filter instanceof SliceQueryFilter) {
            QueryProcessor.validateSliceFilter(metadata, (SliceQueryFilter)filter);
        } else {
            QueryProcessor.validateColumnNames(((NamesQueryFilter)filter).columns);
        }
    }

    public static void validateSliceFilter(CFMetaData metadata, SliceQueryFilter range) throws InvalidRequestException {
        try {
            AbstractType<?> comparator = metadata.getComparatorFor(null);
            ColumnSlice.validate(range.slices, comparator, range.reversed);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidRequestException(e.getMessage());
        }
    }

    private static ResultMessage processStatement(CQLStatement statement, ClientState clientState, List<ByteBuffer> variables) throws RequestExecutionException, RequestValidationException {
        statement.checkAccess(clientState);
        statement.validate(clientState);
        ResultMessage result = statement.execute(clientState, variables);
        return result == null ? ResultMessage.Void.instance() : result;
    }

    public static ResultMessage process(String queryString, ClientState clientState) throws RequestExecutionException, RequestValidationException {
        logger.trace("CQL QUERY: {}", (Object)queryString);
        return QueryProcessor.processStatement(QueryProcessor.getStatement((String)queryString, (ClientState)clientState).statement, clientState, Collections.<ByteBuffer>emptyList());
    }

    public static UntypedResultSet processInternal(String query) {
        try {
            ClientState state = new ClientState();
            ResultMessage result = QueryProcessor.processStatement(QueryProcessor.getStatement((String)query, (ClientState)state).statement, state, Collections.<ByteBuffer>emptyList());
            if (result instanceof ResultMessage.Rows) {
                return new UntypedResultSet(((ResultMessage.Rows)result).result);
            }
            return null;
        }
        catch (RequestExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (RequestValidationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static UntypedResultSet resultify(String query, Row row) {
        try {
            SelectStatement ss = (SelectStatement)QueryProcessor.getStatement((String)query, null).statement;
            ResultSet cqlRows = ss.process(Collections.singletonList(row));
            return new UntypedResultSet(cqlRows);
        }
        catch (RequestValidationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ResultMessage.Prepared prepare(String queryString, ClientState clientState) throws RequestValidationException {
        logger.trace("CQL QUERY: {}", (Object)queryString);
        ParsedStatement.Prepared prepared = QueryProcessor.getStatement(queryString, clientState);
        int statementId = QueryProcessor.makeStatementId(queryString);
        clientState.getCQL3Prepared().put(statementId, prepared.statement);
        logger.trace(String.format("Stored prepared statement #%d with %d bind markers", statementId, prepared.statement.getBoundsTerms()));
        assert (prepared.statement.getBoundsTerms() == prepared.boundNames.size());
        return new ResultMessage.Prepared(statementId, prepared.boundNames);
    }

    public static ResultMessage processPrepared(CQLStatement statement, ClientState clientState, List<ByteBuffer> variables) throws RequestExecutionException, RequestValidationException {
        if (!variables.isEmpty() || statement.getBoundsTerms() != 0) {
            if (variables.size() != statement.getBoundsTerms()) {
                throw new InvalidRequestException(String.format("there were %d markers(?) in CQL but %d bound variables", statement.getBoundsTerms(), variables.size()));
            }
            if (logger.isTraceEnabled()) {
                for (int i = 0; i < variables.size(); ++i) {
                    logger.trace("[{}] '{}'", (Object)(i + 1), (Object)variables.get(i));
                }
            }
        }
        return QueryProcessor.processStatement(statement, clientState, variables);
    }

    private static final int makeStatementId(String cql) {
        return cql.hashCode();
    }

    private static ParsedStatement.Prepared getStatement(String queryStr, ClientState clientState) throws RequestValidationException {
        ParsedStatement statement = QueryProcessor.parseStatement(queryStr);
        if (statement instanceof CFStatement) {
            ((CFStatement)statement).prepareKeyspace(clientState);
        }
        return statement.prepare();
    }

    public static ParsedStatement parseStatement(String queryStr) throws SyntaxException {
        try {
            ANTLRStringStream stream = new ANTLRStringStream(queryStr);
            CqlLexer lexer = new CqlLexer((CharStream)stream);
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            CqlParser parser = new CqlParser((TokenStream)tokenStream);
            ParsedStatement statement = parser.query();
            lexer.throwLastRecognitionError();
            parser.throwLastRecognitionError();
            return statement;
        }
        catch (RuntimeException re) {
            SyntaxException ire = new SyntaxException("Failed parsing statement: [" + queryStr + "] reason: " + re.getClass().getSimpleName() + " " + re.getMessage());
            throw ire;
        }
        catch (RecognitionException e) {
            SyntaxException ire = new SyntaxException("Invalid or malformed CQL query string: " + e.getMessage());
            throw ire;
        }
    }
}

