/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.apache.cassandra.cql.AbstractModification;
import org.apache.cassandra.cql.Attributes;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;

public class BatchStatement {
    protected final List<AbstractModification> statements;
    protected final ConsistencyLevel consistency;
    protected final Long timestamp;
    protected final int timeToLive;

    public BatchStatement(List<AbstractModification> statements, Attributes attrs) {
        this.statements = statements;
        this.consistency = attrs.getConsistencyLevel();
        this.timestamp = attrs.getTimestamp();
        this.timeToLive = attrs.getTimeToLive();
    }

    public List<AbstractModification> getStatements() {
        return this.statements;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistency;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public List<IMutation> getMutations(String keyspace, ClientState clientState, List<ByteBuffer> variables) throws InvalidRequestException, UnauthorizedException {
        LinkedList<IMutation> batch = new LinkedList<IMutation>();
        for (AbstractModification statement : this.statements) {
            batch.addAll(statement.prepareRowMutations(keyspace, clientState, this.timestamp, variables));
        }
        return batch;
    }

    public boolean isSetTimestamp() {
        return this.timestamp != null;
    }

    public String toString() {
        return String.format("BatchStatement(statements=%s, consistency=%s)", new Object[]{this.statements, this.consistency});
    }
}

