/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.cassandra.service;

import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SocketSessionManagementService
{
    public final static SocketSessionManagementService instance = new SocketSessionManagementService();
    public final static ThreadLocal<SocketAddress> remoteSocket = new ThreadLocal<SocketAddress>();
    private final Map<SocketAddress, ClientState> activeSocketSessions = new ConcurrentHashMap<SocketAddress, ClientState>();

    public ClientState get(SocketAddress key)
    {
        ClientState retval = null;
        if (key != null)
        {
            retval = activeSocketSessions.get(key);
        }
        return retval;
    }

    public void put(SocketAddress key, ClientState value)
    {
        if (key != null && value != null)
        {
            activeSocketSessions.put(key, value);
        }
    }

    public boolean remove(SocketAddress key)
    {
        assert key != null;
        return activeSocketSessions.remove(key) != null;
    }

    public void clear()
    {
        activeSocketSessions.clear();
    }

}
