/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.base.Joiner;
import com.google.common.collect.AbstractIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.cache.IRowCacheProvider;
import org.apache.cassandra.concurrent.CreationTimeAwareFuture;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.locator.PropertyFileSnitch;
import org.apache.cassandra.net.IAsyncResult;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.FastByteComparisons;
import org.apache.cassandra.utils.Pair;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FBUtilities {
    private static Logger logger_ = LoggerFactory.getLogger(FBUtilities.class);
    public static final BigInteger TWO = new BigInteger("2");
    private static volatile InetAddress localInetAddress_;
    private static volatile InetAddress broadcastInetAddress_;
    private static final ThreadLocal<MessageDigest> localMD5Digest;
    private static final ThreadLocal<Random> localRandom;
    public static final int MAX_UNSIGNED_SHORT = 65535;

    public static MessageDigest threadLocalMD5Digest() {
        return localMD5Digest.get();
    }

    public static MessageDigest newMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("the requested digest algorithm (" + algorithm + ") is not available", nsae);
        }
    }

    public static Random threadLocalRandom() {
        return localRandom.get();
    }

    public static InetAddress getLocalAddress() {
        if (localInetAddress_ == null) {
            try {
                localInetAddress_ = DatabaseDescriptor.getListenAddress() == null ? InetAddress.getLocalHost() : DatabaseDescriptor.getListenAddress();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return localInetAddress_;
    }

    public static InetAddress getBroadcastAddress() {
        if (broadcastInetAddress_ == null) {
            broadcastInetAddress_ = DatabaseDescriptor.getBroadcastAddress() == null ? FBUtilities.getLocalAddress() : DatabaseDescriptor.getBroadcastAddress();
        }
        return broadcastInetAddress_;
    }

    public static Pair<BigInteger, Boolean> midpoint(BigInteger left, BigInteger right, int sigbits) {
        BigInteger midpoint;
        boolean remainder;
        if (left.compareTo(right) < 0) {
            BigInteger sum = left.add(right);
            remainder = sum.testBit(0);
            midpoint = sum.shiftRight(1);
        } else {
            BigInteger max = TWO.pow(sigbits);
            BigInteger distance = max.add(right).subtract(left);
            remainder = distance.testBit(0);
            midpoint = distance.shiftRight(1).add(left).mod(max);
        }
        return new Pair<BigInteger, Boolean>(midpoint, remainder);
    }

    public static int compareUnsigned(byte[] bytes1, byte[] bytes2, int offset1, int offset2, int len1, int len2) {
        return FastByteComparisons.compareTo(bytes1, offset1, len1, bytes2, offset2, len2);
    }

    public static byte[] xor(byte[] left, byte[] right) {
        if (left == null || right == null) {
            return null;
        }
        if (left.length > right.length) {
            byte[] swap = left;
            left = right;
            right = swap;
        }
        byte[] out = Arrays.copyOf(right, right.length);
        for (int i = 0; i < left.length; ++i) {
            out[i] = (byte)(left[i] & 0xFF ^ right[i] & 0xFF);
        }
        return out;
    }

    public static BigInteger hashToBigInteger(ByteBuffer data) {
        byte[] result = FBUtilities.hash(data);
        BigInteger hash = new BigInteger(result);
        return hash.abs();
    }

    public static byte[] hash(ByteBuffer ... data) {
        MessageDigest messageDigest = localMD5Digest.get();
        for (ByteBuffer block : data) {
            if (block.hasArray()) {
                messageDigest.update(block.array(), block.position(), block.remaining());
                continue;
            }
            messageDigest.update(block.duplicate());
        }
        return messageDigest.digest();
    }

    public static void renameWithConfirm(String tmpFilename, String filename) throws IOException {
        if (!new File(tmpFilename).renameTo(new File(filename))) {
            throw new IOException("rename failed of " + filename);
        }
    }

    public static void serialize(TSerializer serializer, TBase struct, DataOutput out) throws IOException {
        byte[] bytes;
        assert (serializer != null);
        assert (struct != null);
        assert (out != null);
        try {
            bytes = serializer.serialize(struct);
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    public static void deserialize(TDeserializer deserializer, TBase struct, DataInput in) throws IOException {
        assert (deserializer != null);
        assert (struct != null);
        assert (in != null);
        byte[] bytes = new byte[in.readInt()];
        in.readFully(bytes);
        try {
            deserializer.deserialize(struct, bytes);
        }
        catch (TException ex) {
            throw new IOException(ex);
        }
    }

    public static void sortSampledKeys(List<DecoratedKey> keys, Range<Token> range) {
        if (((Token)range.left).compareTo((Token)range.right) >= 0) {
            final Token right = (Token)range.right;
            Comparator<DecoratedKey> comparator = new Comparator<DecoratedKey>(){

                @Override
                public int compare(DecoratedKey o1, DecoratedKey o2) {
                    if (right.compareTo(o1.token) < 0 && right.compareTo(o2.token) < 0 || right.compareTo(o1.token) > 0 && right.compareTo(o2.token) > 0) {
                        return o1.compareTo(o2);
                    }
                    return o2.compareTo(o1);
                }
            };
            Collections.sort(keys, comparator);
        } else {
            Collections.sort(keys);
        }
    }

    public static int encodedUTF8Length(String st) {
        int strlen = st.length();
        int utflen = 0;
        for (int i = 0; i < strlen; ++i) {
            char c = st.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        return utflen;
    }

    public static String resourceToFile(String filename) throws ConfigurationException {
        ClassLoader loader = PropertyFileSnitch.class.getClassLoader();
        URL scpurl = loader.getResource(filename);
        if (scpurl == null) {
            throw new ConfigurationException("unable to locate " + filename);
        }
        return scpurl.getFile();
    }

    public static String getReleaseVersionString() {
        try {
            InputStream in = FBUtilities.class.getClassLoader().getResourceAsStream("org/apache/cassandra/config/version.properties");
            if (in == null) {
                return "Unknown";
            }
            Properties props = new Properties();
            props.load(in);
            return props.getProperty("CassandraVersion");
        }
        catch (Exception e) {
            logger_.warn("Unable to load version.properties", (Throwable)e);
            return "debug version";
        }
    }

    public static long timestampMicros() {
        return System.currentTimeMillis() * 1000L;
    }

    public static void waitOnFutures(Iterable<Future<?>> futures) {
        for (Future<?> f : futures) {
            FBUtilities.waitOnFuture(f);
        }
    }

    public static void waitOnFuture(Future<?> future) {
        try {
            future.get();
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee);
        }
        catch (InterruptedException ie) {
            throw new AssertionError((Object)ie);
        }
    }

    public static void waitOnFutures(List<IAsyncResult> results, long ms) throws TimeoutException {
        for (IAsyncResult result : results) {
            result.get(ms, TimeUnit.MILLISECONDS);
        }
    }

    public static void waitOnFutures(List<CreationTimeAwareFuture<?>> hintFutures, long timeout, TimeUnit timeUnit) throws TimeoutException {
        for (CreationTimeAwareFuture<?> future : hintFutures) {
            try {
                future.get(timeout, timeUnit);
            }
            catch (InterruptedException ex) {
                throw new AssertionError((Object)ex);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static IPartitioner newPartitioner(String partitionerClassName) throws ConfigurationException {
        if (!partitionerClassName.contains(".")) {
            partitionerClassName = "org.apache.cassandra.dht." + partitionerClassName;
        }
        return (IPartitioner)FBUtilities.construct(partitionerClassName, "partitioner");
    }

    public static <T> Class<T> classForName(String classname, String readable) throws ConfigurationException {
        try {
            return Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(String.format("Unable to find %s class '%s'", readable, classname));
        }
    }

    public static <T> T construct(String classname, String readable) throws ConfigurationException {
        Class<T> cls = FBUtilities.classForName(classname, readable);
        try {
            return cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException(String.format("No default constructor for %s class '%s'.", readable, classname));
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(String.format("Default constructor for %s class '%s' is inaccessible.", readable, classname));
        }
        catch (InstantiationException e) {
            throw new ConfigurationException(String.format("Cannot use abstract class '%s' as %s.", classname, readable));
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ConfigurationException) {
                throw (ConfigurationException)e.getCause();
            }
            throw new ConfigurationException(String.format("Error instantiating %s class '%s'.", readable, classname), e);
        }
    }

    public static <T extends Comparable> SortedSet<T> singleton(T column) {
        return new TreeSet<Comparable>(Arrays.asList(column));
    }

    public static String toString(Map<?, ?> map) {
        Joiner.MapJoiner joiner = Joiner.on((String)", ").withKeyValueSeparator(":");
        return joiner.join(map);
    }

    public static Field getProtectedField(Class klass, String fieldName) {
        Field field;
        try {
            field = klass.getDeclaredField(fieldName);
            field.setAccessible(true);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        return field;
    }

    public static IRowCacheProvider newCacheProvider(String cache_provider) throws ConfigurationException {
        if (!cache_provider.contains(".")) {
            cache_provider = "org.apache.cassandra.cache." + cache_provider;
        }
        return (IRowCacheProvider)FBUtilities.construct(cache_provider, "row cache provider");
    }

    public static <T> CloseableIterator<T> closeableIterator(Iterator<T> iterator) {
        return new WrappedCloseableIterator<T>(iterator);
    }

    public static <T> byte[] serialize(T object, IVersionedSerializer<T> serializer, int version) throws IOException {
        int size = (int)serializer.serializedSize(object, version);
        DataOutputBuffer buffer = new DataOutputBuffer(size);
        serializer.serialize(object, buffer, version);
        assert (buffer.getLength() == size && buffer.getData().length == size) : String.format("Final buffer length %s to accomodate data size of %s (predicted %s) for %s", buffer.getData().length, buffer.getLength(), size, object);
        return buffer.getData();
    }

    public static RuntimeException unchecked(Exception e) {
        return e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
    }

    static {
        localMD5Digest = new ThreadLocal<MessageDigest>(){

            @Override
            protected MessageDigest initialValue() {
                return FBUtilities.newMessageDigest("MD5");
            }

            @Override
            public MessageDigest get() {
                MessageDigest digest = (MessageDigest)super.get();
                digest.reset();
                return digest;
            }
        };
        localRandom = new ThreadLocal<Random>(){

            @Override
            protected Random initialValue() {
                return new Random();
            }
        };
    }

    private static final class WrappedCloseableIterator<T>
    extends AbstractIterator<T>
    implements CloseableIterator<T> {
        private final Iterator<T> source;

        public WrappedCloseableIterator(Iterator<T> source) {
            this.source = source;
        }

        protected T computeNext() {
            if (!this.source.hasNext()) {
                return (T)this.endOfData();
            }
            return this.source.next();
        }

        @Override
        public void close() {
        }
    }
}

