/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.util.FastByteArrayInputStream;
import org.apache.cassandra.net.Header;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.OutboundTcpConnection;
import org.apache.cassandra.streaming.IncomingStreamReader;
import org.apache.cassandra.streaming.StreamHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncomingTcpConnection
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(IncomingTcpConnection.class);
    private static final int CHUNK_SIZE = 0x100000;
    private Socket socket;
    public InetAddress from;

    public IncomingTcpConnection(Socket socket) {
        assert (socket != null);
        this.socket = socket;
        this.from = socket.getInetAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            DataInputStream input = new DataInputStream(this.socket.getInputStream());
            MessagingService.validateMagic(input.readInt());
            int header = input.readInt();
            boolean isStream = MessagingService.getBits(header, 3, 1) == 1;
            int version = MessagingService.getBits(header, 15, 8);
            logger.debug("Version for {} is {}", (Object)this.from, (Object)version);
            if (isStream) {
                if (version == 4) {
                    int size = input.readInt();
                    byte[] headerBytes = new byte[size];
                    input.readFully(headerBytes);
                    this.stream(StreamHeader.serializer().deserialize(new DataInputStream(new FastByteArrayInputStream(headerBytes)), version), input);
                } else {
                    logger.error("Received stream using protocol version {} (my version {}). Terminating connection", (Object)version, (Object)4);
                }
                return;
            }
            try {
                input = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 4096));
                Message msg = this.receiveMessage(input, version);
                if (version > 4) {
                    Gossiper.instance.addSavedEndpoint(this.from);
                    logger.info("Received " + (isStream ? "streaming " : "") + "connection from newer protocol version. Ignorning");
                } else if (msg != null) {
                    Gossiper.instance.setVersion(msg.getFrom(), version);
                    logger.debug("set version for {} to {}", (Object)this.from, (Object)version);
                }
                while (true) {
                    MessagingService.validateMagic(input.readInt());
                    header = input.readInt();
                    assert (isStream == (MessagingService.getBits(header, 3, 1) == 1)) : "Connections cannot change type: " + isStream;
                    version = MessagingService.getBits(header, 15, 8);
                    logger.trace("Version is now {}", (Object)version);
                    this.receiveMessage(input, version);
                }
            }
            catch (EOFException e) {
                logger.trace("eof reading from socket; closing", (Throwable)e);
            }
            catch (IOException e) {
                logger.debug("IOError reading from socket; closing", (Throwable)e);
            }
        }
        finally {
            this.close();
        }
    }

    private Message receiveMessage(DataInputStream input, int version) throws IOException {
        int totalSize = input.readInt();
        String id = input.readUTF();
        Header header = Header.serializer().deserialize(input, version);
        int bodySize = input.readInt();
        byte[] body = new byte[bodySize];
        int remainder = bodySize % 0x100000;
        for (int offset = 0; offset < bodySize - remainder; offset += 0x100000) {
            input.readFully(body, offset, 0x100000);
        }
        input.readFully(body, bodySize - remainder, remainder);
        for (long remaining = (long)(totalSize - OutboundTcpConnection.messageLength(header, id, body)); remaining > 0L; remaining -= input.skip(remaining)) {
        }
        if (version <= 4) {
            Message message = new Message(header, body, version);
            MessagingService.instance().receive(message, id);
            return message;
        }
        logger.debug("Received connection from newer protocol version {}. Ignorning message", (Object)version);
        return null;
    }

    private void close() {
        block3: {
            if (this.from != null) {
                Gossiper.instance.resetVersion(this.from);
            }
            try {
                this.socket.close();
            }
            catch (IOException e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("error closing socket", (Throwable)e);
            }
        }
    }

    private void stream(StreamHeader streamHeader, DataInputStream input) throws IOException {
        new IncomingStreamReader(streamHeader, this.socket).read();
    }
}

