/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.CLibrary;

public class SequentialWriter
extends OutputStream {
    protected boolean isDirty = false;
    protected boolean syncNeeded = false;
    private final String filePath;
    private final byte[] singleByteBuffer = new byte[1];
    protected byte[] buffer;
    private final boolean skipIOCache;
    private final int fd;
    private final int directoryFD;
    private boolean directorySynced = false;
    protected long current = 0L;
    protected long bufferOffset;
    protected int validBufferBytes;
    protected final RandomAccessFile out;
    private long ioCacheStartOffset = 0L;
    private long bytesSinceCacheFlush = 0L;
    public final DataOutputStream stream;
    private MessageDigest digest;

    public SequentialWriter(File file, int bufferSize, boolean skipIOCache) throws IOException {
        this.out = new RandomAccessFile(file, "rw");
        this.filePath = file.getAbsolutePath();
        this.buffer = new byte[bufferSize];
        this.skipIOCache = skipIOCache;
        this.fd = CLibrary.getfd(this.out.getFD());
        this.directoryFD = CLibrary.tryOpenDirectory(file.getParent());
        this.stream = new DataOutputStream(this);
    }

    public static SequentialWriter open(File file) throws IOException {
        return SequentialWriter.open(file, 65536, false);
    }

    public static SequentialWriter open(File file, boolean skipIOCache) throws IOException {
        return SequentialWriter.open(file, 65536, skipIOCache);
    }

    public static SequentialWriter open(File file, int bufferSize, boolean skipIOCache) throws IOException {
        return new SequentialWriter(file, bufferSize, skipIOCache);
    }

    @Override
    public void write(int value) throws IOException {
        this.singleByteBuffer[0] = (byte)value;
        this.write(this.singleByteBuffer, 0, 1);
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        if (this.buffer == null) {
            throw new ClosedChannelException();
        }
        while (length > 0) {
            int n = this.writeAtMost(data, offset, length);
            offset += n;
            length -= n;
            this.isDirty = true;
            this.syncNeeded = true;
        }
    }

    private int writeAtMost(byte[] data, int offset, int length) throws IOException {
        if (this.current >= this.bufferOffset + (long)this.buffer.length) {
            this.reBuffer();
        }
        assert (this.current < this.bufferOffset + (long)this.buffer.length) : String.format("File (%s) offset %d, buffer offset %d.", this.getPath(), this.current, this.bufferOffset);
        int toCopy = Math.min(length, this.buffer.length - this.bufferCursor());
        System.arraycopy(data, offset, this.buffer, this.bufferCursor(), toCopy);
        assert (this.current <= this.bufferOffset + (long)this.buffer.length) : String.format("File (%s) offset %d, buffer offset %d.", this.getPath(), this.current, this.bufferOffset);
        this.validBufferBytes = Math.max(this.validBufferBytes, this.bufferCursor() + toCopy);
        this.current += (long)toCopy;
        return toCopy;
    }

    public void sync() throws IOException {
        this.syncInternal();
    }

    protected void syncInternal() throws IOException {
        if (this.syncNeeded) {
            this.flushInternal();
            this.out.getFD().sync();
            if (!this.directorySynced) {
                CLibrary.trySync(this.directoryFD);
                this.directorySynced = true;
            }
            this.syncNeeded = false;
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushInternal();
    }

    protected void flushInternal() throws IOException {
        if (this.isDirty) {
            this.flushData();
            if (this.skipIOCache) {
                this.bytesSinceCacheFlush += (long)this.validBufferBytes;
                if (this.bytesSinceCacheFlush >= RandomAccessReader.MAX_BYTES_IN_PAGE_CACHE) {
                    CLibrary.trySkipCache(this.fd, this.ioCacheStartOffset, 0);
                    this.ioCacheStartOffset = this.bufferOffset;
                    this.bytesSinceCacheFlush = 0L;
                }
            }
            this.resetBuffer();
            this.isDirty = false;
        }
    }

    protected void flushData() throws IOException {
        this.out.write(this.buffer, 0, this.validBufferBytes);
        if (this.digest != null) {
            this.digest.update(this.buffer, 0, this.validBufferBytes);
        }
    }

    public long getFilePointer() {
        return this.current;
    }

    public long length() throws IOException {
        return Math.max(Math.max(this.current, this.out.length()), this.bufferOffset + (long)this.validBufferBytes);
    }

    public String getPath() {
        return this.filePath;
    }

    protected void reBuffer() throws IOException {
        this.flushInternal();
        this.resetBuffer();
    }

    protected void resetBuffer() {
        this.bufferOffset = this.current;
        this.validBufferBytes = 0;
    }

    private int bufferCursor() {
        return (int)(this.current - this.bufferOffset);
    }

    public FileMark mark() {
        return new BufferedFileWriterMark(this.current);
    }

    public void resetAndTruncate(FileMark mark) throws IOException {
        assert (mark instanceof BufferedFileWriterMark);
        long previous = this.current;
        this.current = ((BufferedFileWriterMark)mark).pointer;
        if (previous - this.current <= (long)this.validBufferBytes) {
            this.validBufferBytes -= (int)(previous - this.current);
            return;
        }
        this.syncInternal();
        this.truncate(this.current);
        this.out.seek(this.current);
        this.resetBuffer();
    }

    public void truncate(long toSize) throws IOException {
        this.out.getChannel().truncate(toSize);
    }

    @Override
    public void close() throws IOException {
        if (this.buffer == null) {
            return;
        }
        this.syncInternal();
        this.buffer = null;
        if (this.skipIOCache && this.bytesSinceCacheFlush > 0L) {
            CLibrary.trySkipCache(this.fd, 0L, 0);
        }
        this.out.close();
        CLibrary.tryCloseFD(this.directoryFD);
    }

    public void setComputeDigest() {
        if (this.current != 0L) {
            throw new IllegalStateException();
        }
        try {
            this.digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] digest() {
        if (this.buffer != null) {
            throw new IllegalStateException();
        }
        return this.digest == null ? null : this.digest.digest();
    }

    protected static class BufferedFileWriterMark
    implements FileMark {
        long pointer;

        public BufferedFileWriterMark(long pointer) {
            this.pointer = pointer;
        }
    }
}

