/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.TreeMapBackedSortedColumns;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.io.sstable.AbstractSSTableSimpleWriter;
import org.apache.cassandra.io.sstable.SSTableWriter;

public class SSTableSimpleUnsortedWriter
extends AbstractSSTableSimpleWriter {
    private static final Buffer SENTINEL = new Buffer();
    private Buffer buffer = new Buffer();
    private final long bufferSize;
    private long currentSize;
    private final BlockingQueue<Buffer> writeQueue = new SynchronousQueue<Buffer>();
    private final DiskWriter diskWriter = new DiskWriter();

    public SSTableSimpleUnsortedWriter(File directory, IPartitioner partitioner, String keyspace, String columnFamily, AbstractType<?> comparator, AbstractType<?> subComparator, int bufferSizeInMB, CompressionParameters compressParameters) throws IOException {
        super(directory, new CFMetaData(keyspace, columnFamily, subComparator == null ? ColumnFamilyType.Standard : ColumnFamilyType.Super, comparator, subComparator).compressionParameters(compressParameters), partitioner);
        this.bufferSize = (long)bufferSizeInMB * 1024L * 1024L;
        this.diskWriter.start();
    }

    public SSTableSimpleUnsortedWriter(File directory, IPartitioner partitioner, String keyspace, String columnFamily, AbstractType<?> comparator, AbstractType<?> subComparator, int bufferSizeInMB) throws IOException {
        this(directory, partitioner, keyspace, columnFamily, comparator, subComparator, bufferSizeInMB, new CompressionParameters(null));
    }

    @Override
    protected void writeRow(DecoratedKey key, ColumnFamily columnFamily) throws IOException {
        this.currentSize = (long)((double)this.currentSize + ((double)key.key.remaining() + (double)columnFamily.serializedSize() * 1.2));
        if (this.currentSize > this.bufferSize) {
            this.sync();
        }
    }

    @Override
    protected ColumnFamily getColumnFamily() {
        ColumnFamily previous = (ColumnFamily)this.buffer.get(this.currentKey);
        if (previous == null) {
            previous = ColumnFamily.create(this.metadata, TreeMapBackedSortedColumns.factory());
            this.buffer.put(this.currentKey, previous);
        } else {
            this.currentSize = (long)((double)this.currentSize - ((double)this.currentKey.key.remaining() + (double)previous.serializedSize() * 1.2));
        }
        return previous;
    }

    @Override
    public void close() throws IOException {
        this.sync();
        try {
            this.writeQueue.put(SENTINEL);
            this.diskWriter.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.checkForWriterException();
    }

    private void sync() throws IOException {
        if (this.buffer.isEmpty()) {
            return;
        }
        this.checkForWriterException();
        try {
            this.writeQueue.put(this.buffer);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.buffer = new Buffer();
        this.currentSize = 0L;
    }

    private void checkForWriterException() throws IOException {
        if (this.diskWriter.exception != null) {
            if (this.diskWriter.exception instanceof IOException) {
                throw (IOException)this.diskWriter.exception;
            }
            throw new RuntimeException(this.diskWriter.exception);
        }
    }

    private class DiskWriter
    extends Thread {
        volatile Exception exception = null;

        private DiskWriter() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Buffer b;
                    if ((b = (Buffer)SSTableSimpleUnsortedWriter.this.writeQueue.take()) == SENTINEL) {
                        return;
                    }
                    SSTableWriter writer = SSTableSimpleUnsortedWriter.this.getWriter();
                    for (Map.Entry entry : b.entrySet()) {
                        writer.append((DecoratedKey)entry.getKey(), (ColumnFamily)entry.getValue());
                    }
                    writer.closeAndOpenReader();
                }
            }
            catch (Exception e) {
                this.exception = e;
                return;
            }
        }
    }

    private static class Buffer
    extends TreeMap<DecoratedKey, ColumnFamily> {
        private Buffer() {
        }
    }
}

