/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.util.Utf8;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.io.compress.ICompressor;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class CompressionParameters {
    public static final int DEFAULT_CHUNK_LENGTH = 65536;
    public static final double DEFAULT_CRC_CHECK_CHANCE = 1.0;
    public static final String SSTABLE_COMPRESSION = "sstable_compression";
    public static final String CHUNK_LENGTH_KB = "chunk_length_kb";
    public static final String CRC_CHECK_CHANCE = "crc_check_chance";
    public final ICompressor sstableCompressor;
    private final Integer chunkLength;
    public final double crcChance;
    public final Map<String, String> otherOptions;

    public static CompressionParameters create(Map<? extends CharSequence, ? extends CharSequence> opts) throws ConfigurationException {
        Map<String, String> options = CompressionParameters.copyOptions(opts);
        String sstableCompressionClass = options.get(SSTABLE_COMPRESSION);
        String chunkLength = options.get(CHUNK_LENGTH_KB);
        options.remove(SSTABLE_COMPRESSION);
        options.remove(CHUNK_LENGTH_KB);
        CompressionParameters cp = new CompressionParameters(sstableCompressionClass, CompressionParameters.parseChunkLength(chunkLength), options);
        cp.validate();
        return cp;
    }

    public CompressionParameters(String sstableCompressorClass, Integer chunkLength, Map<String, String> otherOptions) throws ConfigurationException {
        this(CompressionParameters.createCompressor(CompressionParameters.parseCompressorClass(sstableCompressorClass), otherOptions), chunkLength, otherOptions);
    }

    public CompressionParameters(ICompressor sstableCompressor) {
        this(sstableCompressor, null, Collections.emptyMap());
    }

    public CompressionParameters(ICompressor sstableCompressor, Integer chunkLength, Map<String, String> otherOptions) {
        this.sstableCompressor = sstableCompressor;
        this.chunkLength = chunkLength;
        this.otherOptions = otherOptions;
        String chance = otherOptions.get(CRC_CHECK_CHANCE);
        this.crcChance = chance == null ? 1.0 : Double.parseDouble(chance);
    }

    public int chunkLength() {
        return this.chunkLength == null ? 65536 : this.chunkLength;
    }

    private static Class<? extends ICompressor> parseCompressorClass(String className) throws ConfigurationException {
        if (className == null || className.isEmpty()) {
            return null;
        }
        className = className.contains(".") ? className : "org.apache.cassandra.io.compress." + className;
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not create Compression for type " + className, e);
        }
    }

    private static ICompressor createCompressor(Class<? extends ICompressor> compressorClass, Map<String, String> compressionOptions) throws ConfigurationException {
        if (compressorClass == null) {
            return null;
        }
        try {
            Method method = compressorClass.getMethod("create", Map.class);
            return (ICompressor)method.invoke(null, compressionOptions);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("create method not found", e);
        }
        catch (SecurityException e) {
            throw new ConfigurationException("Access forbiden", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Cannot access method create in " + compressorClass.getName(), e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            throw new ConfigurationException(String.format("%s.create() threw an error: %s", compressorClass.getSimpleName(), cause == null ? e.getClass().getName() + " " + e.getMessage() : cause.getClass().getName() + " " + cause.getMessage()), e);
        }
        catch (ExceptionInInitializerError e) {
            throw new ConfigurationException("Cannot initialize class " + compressorClass.getName());
        }
    }

    private static Map<String, String> copyOptions(Map<? extends CharSequence, ? extends CharSequence> co) {
        if (co == null || co.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> compressionOptions = new HashMap<String, String>();
        for (Map.Entry<? extends CharSequence, ? extends CharSequence> entry : co.entrySet()) {
            compressionOptions.put(((Object)entry.getKey()).toString(), ((Object)entry.getValue()).toString());
        }
        return compressionOptions;
    }

    private static Integer parseChunkLength(String chLengthKB) throws ConfigurationException {
        if (chLengthKB == null) {
            return null;
        }
        try {
            int parsed = Integer.parseInt(chLengthKB);
            if (parsed > 0x1FFFFF) {
                throw new ConfigurationException("Value of chunk_length_kb is too large (" + parsed + ")");
            }
            return 1024 * parsed;
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Invalid value for chunk_length_kb", e);
        }
    }

    private void validate() throws ConfigurationException {
        if (this.chunkLength != null) {
            if (this.chunkLength <= 0) {
                throw new ConfigurationException("Invalid negative or null chunk_length_kb");
            }
            boolean found = false;
            for (int c = this.chunkLength.intValue(); c != 0; c >>= 1) {
                if ((c & 1) == 0) continue;
                if (found) {
                    throw new ConfigurationException("chunk_length_kb must be a power of 2");
                }
                found = true;
            }
        }
        if (this.crcChance > 1.0 || this.crcChance < 0.0) {
            throw new ConfigurationException("crc_check_chance should be between 0.0 to 1.0");
        }
    }

    public Map<CharSequence, CharSequence> asAvroOptions() {
        HashMap<CharSequence, CharSequence> options = new HashMap<CharSequence, CharSequence>();
        for (Map.Entry<String, String> entry : this.otherOptions.entrySet()) {
            options.put((CharSequence)new Utf8(entry.getKey()), (CharSequence)new Utf8(entry.getValue()));
        }
        if (this.sstableCompressor == null) {
            return options;
        }
        options.put((CharSequence)new Utf8(SSTABLE_COMPRESSION), (CharSequence)new Utf8(this.sstableCompressor.getClass().getName()));
        if (this.chunkLength != null) {
            options.put((CharSequence)new Utf8(CHUNK_LENGTH_KB), (CharSequence)new Utf8(this.chunkLengthInKB()));
        }
        return options;
    }

    public Map<String, String> asThriftOptions() {
        HashMap<String, String> options = new HashMap<String, String>(this.otherOptions);
        if (this.sstableCompressor == null) {
            return options;
        }
        options.put(SSTABLE_COMPRESSION, this.sstableCompressor.getClass().getName());
        if (this.chunkLength != null) {
            options.put(CHUNK_LENGTH_KB, this.chunkLengthInKB());
        }
        return options;
    }

    private String chunkLengthInKB() {
        return String.valueOf(this.chunkLength() / 1024);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CompressionParameters cp = (CompressionParameters)obj;
        return new EqualsBuilder().append((Object)this.sstableCompressor, (Object)cp.sstableCompressor).append((Object)this.chunkLength, (Object)cp.chunkLength).append(this.otherOptions, cp.otherOptions).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(29, 1597).append((Object)this.sstableCompressor).append((Object)this.chunkLength).append(this.otherOptions).toHashCode();
    }
}

