/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.migration;

import java.io.IOException;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.db.migration.MigrationHelper;

public class DropColumnFamily
extends Migration {
    private final String ksName;
    private final String cfName;

    public DropColumnFamily(String ksName, String cfName) throws ConfigurationException {
        super(System.nanoTime());
        KSMetaData ksm = Schema.instance.getTableDefinition(ksName);
        if (ksm == null) {
            throw new ConfigurationException("Can't drop ColumnFamily: No such keyspace '" + ksName + "'.");
        }
        if (!ksm.cfMetaData().containsKey(cfName)) {
            throw new ConfigurationException(String.format("Can't drop ColumnFamily (ks=%s, cf=%s) : Not defined in that keyspace.", ksName, cfName));
        }
        this.ksName = ksName;
        this.cfName = cfName;
    }

    @Override
    protected void applyImpl() throws ConfigurationException, IOException {
        MigrationHelper.dropColumnFamily(this.ksName, this.cfName, this.timestamp);
    }

    public String toString() {
        return String.format("Drop column family: %s.%s", this.ksName, this.cfName);
    }
}

