/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.migration;

import java.io.IOException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.db.migration.MigrationHelper;

public class AddKeyspace
extends Migration {
    private final KSMetaData ksm;

    public AddKeyspace(KSMetaData ksm) throws ConfigurationException {
        super(System.nanoTime());
        if (Schema.instance.getTableDefinition(ksm.name) != null) {
            throw new ConfigurationException(String.format("Can't add Keyspace '%s': Already exists.", ksm.name));
        }
        if (!Migration.isLegalName(ksm.name)) {
            throw new ConfigurationException(String.format("Can't add Keyspace '%s': Invalid name.", ksm.name));
        }
        for (CFMetaData cfm : ksm.cfMetaData().values()) {
            if (Migration.isLegalName(cfm.cfName)) continue;
            throw new ConfigurationException(String.format("Can't add Keyspace '%s': Invalid ColumnFamily name '%s'.", ksm.name, cfm.cfName));
        }
        this.ksm = ksm;
    }

    @Override
    protected void applyImpl() throws ConfigurationException, IOException {
        MigrationHelper.addKeyspace(this.ksm, this.timestamp);
    }

    public String toString() {
        return "Add keyspace: " + this.ksm.toString();
    }
}

