/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.TreeSet;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.filter.IFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtendedFilter {
    private static Logger logger = LoggerFactory.getLogger(ExtendedFilter.class);
    public final ColumnFamilyStore cfs;
    protected final IFilter originalFilter;
    private final int maxResults;
    private final boolean maxIsColumns;

    public static ExtendedFilter create(ColumnFamilyStore cfs, IFilter filter, List<IndexExpression> clause, int maxResults, boolean maxIsColumns) {
        if (clause == null || clause.isEmpty()) {
            return new EmptyClauseFilter(cfs, filter, maxResults, maxIsColumns);
        }
        return new FilterWithClauses(cfs, filter, clause, maxResults, maxIsColumns);
    }

    protected ExtendedFilter(ColumnFamilyStore cfs, IFilter filter, int maxResults, boolean maxIsColumns) {
        assert (cfs != null);
        assert (filter != null);
        this.cfs = cfs;
        this.originalFilter = filter;
        this.maxResults = maxResults;
        this.maxIsColumns = maxIsColumns;
        if (maxIsColumns) {
            this.originalFilter.updateColumnsLimit(maxResults);
        }
    }

    public int maxRows() {
        return this.maxIsColumns ? Integer.MAX_VALUE : this.maxResults;
    }

    public int maxColumns() {
        return this.maxIsColumns ? this.maxResults : Integer.MAX_VALUE;
    }

    public void updateColumnsLimit(int columnsCount) {
        if (!this.maxIsColumns) {
            return;
        }
        int remaining = this.maxResults - columnsCount;
        this.initialFilter().updateColumnsLimit(remaining);
    }

    public abstract IFilter initialFilter();

    public abstract List<IndexExpression> getClause();

    public abstract IFilter getExtraFilter(ColumnFamily var1);

    public abstract ColumnFamily prune(ColumnFamily var1);

    public abstract boolean isSatisfiedBy(ColumnFamily var1);

    public static boolean satisfies(int comparison, IndexOperator op) {
        switch (op) {
            case EQ: {
                return comparison == 0;
            }
            case GTE: {
                return comparison >= 0;
            }
            case GT: {
                return comparison > 0;
            }
            case LTE: {
                return comparison <= 0;
            }
            case LT: {
                return comparison < 0;
            }
        }
        throw new IllegalStateException();
    }

    private static class EmptyClauseFilter
    extends ExtendedFilter {
        public EmptyClauseFilter(ColumnFamilyStore cfs, IFilter filter, int maxResults, boolean maxIsColumns) {
            super(cfs, filter, maxResults, maxIsColumns);
        }

        @Override
        public IFilter initialFilter() {
            return this.originalFilter;
        }

        @Override
        public List<IndexExpression> getClause() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IFilter getExtraFilter(ColumnFamily data) {
            return null;
        }

        @Override
        public ColumnFamily prune(ColumnFamily data) {
            return data;
        }

        @Override
        public boolean isSatisfiedBy(ColumnFamily data) {
            return true;
        }
    }

    private static class FilterWithClauses
    extends ExtendedFilter {
        protected final List<IndexExpression> clause;
        protected final IFilter initialFilter;

        public FilterWithClauses(ColumnFamilyStore cfs, IFilter filter, List<IndexExpression> clause, int maxResults, boolean maxIsColumns) {
            super(cfs, filter, maxResults, maxIsColumns);
            assert (clause != null);
            this.clause = clause;
            this.initialFilter = this.computeInitialFilter();
        }

        private IFilter computeInitialFilter() {
            if (this.originalFilter instanceof SliceQueryFilter) {
                if (this.cfs.getMaxRowSize() < (long)DatabaseDescriptor.getColumnIndexSize()) {
                    logger.debug("Expanding slice filter to entire row to cover additional expressions");
                    return new SliceQueryFilter(ByteBufferUtil.EMPTY_BYTE_BUFFER, ByteBufferUtil.EMPTY_BYTE_BUFFER, ((SliceQueryFilter)this.originalFilter).reversed, Integer.MAX_VALUE);
                }
            } else {
                logger.debug("adding columns to original Filter to cover additional expressions");
                assert (this.originalFilter instanceof NamesQueryFilter);
                TreeSet<ByteBuffer> columns = new TreeSet<ByteBuffer>(this.cfs.getComparator());
                for (IndexExpression expr : this.clause) {
                    columns.add(expr.column_name);
                }
                if (columns.size() > 0) {
                    columns.addAll(((NamesQueryFilter)this.originalFilter).columns);
                    return new NamesQueryFilter(columns);
                }
            }
            return this.originalFilter;
        }

        @Override
        public IFilter initialFilter() {
            return this.initialFilter;
        }

        @Override
        public List<IndexExpression> getClause() {
            return this.clause;
        }

        private boolean needsExtraQuery(ColumnFamily data) {
            if (!(this.originalFilter instanceof SliceQueryFilter)) {
                return false;
            }
            SliceQueryFilter filter = (SliceQueryFilter)this.originalFilter;
            if (filter.start.equals(ByteBufferUtil.EMPTY_BYTE_BUFFER) && filter.finish.equals(ByteBufferUtil.EMPTY_BYTE_BUFFER) && filter.count == Integer.MAX_VALUE) {
                return false;
            }
            for (IndexExpression expr : this.clause) {
                if (data.getColumn(expr.column_name) != null) continue;
                logger.debug("adding extraFilter to cover additional expressions");
                return true;
            }
            return false;
        }

        @Override
        public IFilter getExtraFilter(ColumnFamily data) {
            if (!this.needsExtraQuery(data)) {
                return null;
            }
            TreeSet<ByteBuffer> columns = new TreeSet<ByteBuffer>(this.cfs.getComparator());
            for (IndexExpression expr : this.clause) {
                if (data.getColumn(expr.column_name) != null) continue;
                columns.add(expr.column_name);
            }
            assert (!columns.isEmpty());
            return new NamesQueryFilter(columns);
        }

        @Override
        public ColumnFamily prune(ColumnFamily data) {
            if (this.initialFilter == this.originalFilter) {
                return data;
            }
            ColumnFamily pruned = data.cloneMeShallow();
            IColumnIterator iter = this.originalFilter.getMemtableColumnIterator(data, null);
            this.originalFilter.collectReducedColumns(pruned, iter, this.cfs.gcBefore());
            return pruned;
        }

        @Override
        public boolean isSatisfiedBy(ColumnFamily data) {
            for (IndexExpression expression : this.clause) {
                IColumn column = data.getColumn(expression.column_name);
                if (column == null) {
                    return false;
                }
                int v = data.metadata().getValueValidator(expression.column_name).compare(column.value(), expression.value);
                if (FilterWithClauses.satisfies(v, expression.op)) continue;
                return false;
            }
            return true;
        }
    }
}

