/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import edu.stanford.ppl.concurrent.SnapTreeMap;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.ISortedColumns;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.utils.Allocator;

public class AtomicSortedColumns
implements ISortedColumns {
    private final AtomicReference<Holder> ref;
    public static final ISortedColumns.Factory factory = new ISortedColumns.Factory(){

        @Override
        public ISortedColumns create(AbstractType<?> comparator, boolean insertReversed) {
            return new AtomicSortedColumns(comparator);
        }

        @Override
        public ISortedColumns fromSorted(SortedMap<ByteBuffer, IColumn> sortedMap, boolean insertReversed) {
            return new AtomicSortedColumns(sortedMap);
        }
    };

    public static ISortedColumns.Factory factory() {
        return factory;
    }

    private AtomicSortedColumns(AbstractType<?> comparator) {
        this(new Holder(comparator));
    }

    private AtomicSortedColumns(SortedMap<ByteBuffer, IColumn> columns) {
        this(new Holder(columns));
    }

    private AtomicSortedColumns(Holder holder) {
        this.ref = new AtomicReference<Holder>(holder);
    }

    @Override
    public AbstractType<?> getComparator() {
        return (AbstractType)this.ref.get().map.comparator();
    }

    @Override
    public ISortedColumns.Factory getFactory() {
        return factory;
    }

    @Override
    public ISortedColumns cloneMe() {
        return new AtomicSortedColumns(this.ref.get().cloneMe());
    }

    @Override
    public ISortedColumns.DeletionInfo getDeletionInfo() {
        return this.ref.get().deletionInfo;
    }

    @Override
    public void delete(ISortedColumns.DeletionInfo info) {
        Holder current;
        do {
            current = this.ref.get();
        } while (current.deletionInfo.markedForDeleteAt < info.markedForDeleteAt && !this.ref.compareAndSet(current, current.with(info)));
    }

    @Override
    public void maybeResetDeletionTimes(int gcBefore) {
        Holder current;
        do {
            current = this.ref.get();
        } while (current.deletionInfo.localDeletionTime <= gcBefore && !this.ref.compareAndSet(current, current.with(new ISortedColumns.DeletionInfo())));
    }

    @Override
    public void retainAll(ISortedColumns columns) {
        Holder modified;
        Holder current;
        do {
            current = this.ref.get();
            modified = current.cloneMe();
            modified.retainAll(columns);
        } while (!this.ref.compareAndSet(current, modified));
    }

    @Override
    public void addColumn(IColumn column, Allocator allocator) {
        Holder modified;
        Holder current;
        do {
            current = this.ref.get();
            modified = current.cloneMe();
            modified.addColumn(column, allocator);
        } while (!this.ref.compareAndSet(current, modified));
    }

    @Override
    public void addAll(ISortedColumns cm, Allocator allocator, Function<IColumn, IColumn> transformation) {
        Holder modified;
        Holder current;
        block0: do {
            current = this.ref.get();
            ISortedColumns.DeletionInfo newDelInfo = current.deletionInfo;
            if (newDelInfo.markedForDeleteAt < cm.getDeletionInfo().markedForDeleteAt) {
                newDelInfo = cm.getDeletionInfo();
            }
            modified = new Holder((SnapTreeMap<ByteBuffer, IColumn>)current.map.clone(), newDelInfo);
            for (IColumn column : cm.getSortedColumns()) {
                modified.addColumn((IColumn)transformation.apply((Object)column), allocator);
                if (this.ref.get() == current) continue;
                continue block0;
            }
        } while (!this.ref.compareAndSet(current, modified));
    }

    @Override
    public boolean replace(IColumn oldColumn, IColumn newColumn) {
        boolean replaced;
        Holder modified;
        Holder current;
        if (!oldColumn.name().equals(newColumn.name())) {
            throw new IllegalArgumentException();
        }
        do {
            current = this.ref.get();
            modified = current.cloneMe();
            replaced = modified.map.replace((Object)oldColumn.name(), (Object)oldColumn, (Object)newColumn);
        } while (!this.ref.compareAndSet(current, modified));
        return replaced;
    }

    @Override
    public void removeColumn(ByteBuffer name) {
        Holder modified;
        Holder current;
        do {
            current = this.ref.get();
            modified = current.cloneMe();
            modified.map.remove((Object)name);
        } while (!this.ref.compareAndSet(current, modified));
    }

    @Override
    public void clear() {
        Holder modified;
        Holder current;
        while (!this.ref.compareAndSet(current = this.ref.get(), modified = current.clear())) {
        }
    }

    @Override
    public IColumn getColumn(ByteBuffer name) {
        return (IColumn)this.ref.get().map.get((Object)name);
    }

    @Override
    public SortedSet<ByteBuffer> getColumnNames() {
        return this.ref.get().map.keySet();
    }

    @Override
    public Collection<IColumn> getSortedColumns() {
        return this.ref.get().map.values();
    }

    @Override
    public Collection<IColumn> getReverseSortedColumns() {
        return this.ref.get().map.descendingMap().values();
    }

    @Override
    public int size() {
        return this.ref.get().map.size();
    }

    @Override
    public int getEstimatedColumnCount() {
        return this.size();
    }

    @Override
    public boolean isEmpty() {
        return this.ref.get().map.isEmpty();
    }

    @Override
    public Iterator<IColumn> iterator() {
        return this.getSortedColumns().iterator();
    }

    @Override
    public Iterator<IColumn> reverseIterator() {
        return this.getReverseSortedColumns().iterator();
    }

    @Override
    public Iterator<IColumn> iterator(ByteBuffer start) {
        return this.ref.get().map.tailMap((Object)start).values().iterator();
    }

    @Override
    public Iterator<IColumn> reverseIterator(ByteBuffer start) {
        return this.ref.get().map.descendingMap().tailMap(start).values().iterator();
    }

    @Override
    public boolean isInsertReversed() {
        return false;
    }

    private static class Holder {
        final SnapTreeMap<ByteBuffer, IColumn> map;
        final ISortedColumns.DeletionInfo deletionInfo;

        Holder(AbstractType<?> comparator) {
            this((SnapTreeMap<ByteBuffer, IColumn>)new SnapTreeMap(comparator), new ISortedColumns.DeletionInfo());
        }

        Holder(SortedMap<ByteBuffer, IColumn> columns) {
            this((SnapTreeMap<ByteBuffer, IColumn>)new SnapTreeMap(columns), new ISortedColumns.DeletionInfo());
        }

        Holder(SnapTreeMap<ByteBuffer, IColumn> map, ISortedColumns.DeletionInfo deletionInfo) {
            this.map = map;
            this.deletionInfo = deletionInfo;
        }

        Holder cloneMe() {
            return this.with((SnapTreeMap<ByteBuffer, IColumn>)this.map.clone());
        }

        Holder with(ISortedColumns.DeletionInfo info) {
            return new Holder(this.map, info);
        }

        Holder with(SnapTreeMap<ByteBuffer, IColumn> newMap) {
            return new Holder(newMap, this.deletionInfo);
        }

        Holder clear() {
            return new Holder((SnapTreeMap<ByteBuffer, IColumn>)new SnapTreeMap(this.map.comparator()), this.deletionInfo);
        }

        void addColumn(IColumn column, Allocator allocator) {
            IColumn oldColumn;
            ByteBuffer name = column.name();
            while ((oldColumn = (IColumn)this.map.putIfAbsent((Object)name, (Object)column)) != null) {
                if (oldColumn instanceof SuperColumn) {
                    assert (column instanceof SuperColumn);
                    ((SuperColumn)oldColumn).putColumn((SuperColumn)column, allocator);
                    break;
                }
                IColumn reconciledColumn = column.reconcile(oldColumn, allocator);
                if (!this.map.replace((Object)name, (Object)oldColumn, (Object)reconciledColumn)) continue;
                break;
            }
        }

        void retainAll(ISortedColumns columns) {
            Iterator iter = this.map.values().iterator();
            Iterator toRetain = columns.iterator();
            IColumn current = iter.hasNext() ? (IColumn)iter.next() : null;
            IColumn retain = toRetain.hasNext() ? (IColumn)toRetain.next() : null;
            Comparator comparator = this.map.comparator();
            while (current != null && retain != null) {
                int c = comparator.compare(current.name(), retain.name());
                if (c == 0) {
                    if (current instanceof SuperColumn) {
                        assert (retain instanceof SuperColumn);
                        ((SuperColumn)current).retainAll((SuperColumn)retain);
                    }
                    current = iter.hasNext() ? (IColumn)iter.next() : null;
                    retain = toRetain.hasNext() ? (IColumn)toRetain.next() : null;
                    continue;
                }
                if (c < 0) {
                    iter.remove();
                    current = iter.hasNext() ? (IColumn)iter.next() : null;
                    continue;
                }
                retain = toRetain.hasNext() ? (IColumn)toRetain.next() : null;
            }
            while (current != null) {
                iter.remove();
                current = iter.hasNext() ? (IColumn)iter.next() : null;
            }
        }
    }
}

