/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.SchemaDisagreementException;

public abstract class SchemaAlteringStatement
extends CFStatement
implements CQLStatement {
    private static final long timeLimitForSchemaAgreement = 10000L;
    private final boolean isColumnFamilyLevel;

    protected SchemaAlteringStatement() {
        super(null);
        this.isColumnFamilyLevel = false;
    }

    protected SchemaAlteringStatement(CFName name) {
        super(name);
        this.isColumnFamilyLevel = true;
    }

    @Override
    public void prepareKeyspace(ClientState state) throws InvalidRequestException {
        if (this.isColumnFamilyLevel) {
            super.prepareKeyspace(state);
        }
    }

    @Override
    public ParsedStatement.Prepared prepare() throws InvalidRequestException {
        return new ParsedStatement.Prepared(this);
    }

    public abstract Migration getMigration() throws InvalidRequestException, IOException, ConfigurationException;

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException {
        if (this.isColumnFamilyLevel) {
            state.hasColumnFamilySchemaAccess(Permission.WRITE);
        } else {
            state.hasKeyspaceSchemaAccess(Permission.WRITE);
        }
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException, SchemaDisagreementException {
        SchemaAlteringStatement.validateSchemaAgreement();
    }

    @Override
    public CqlResult execute(ClientState state, List<ByteBuffer> variables) throws InvalidRequestException, SchemaDisagreementException {
        try {
            SchemaAlteringStatement.applyMigrationOnStage(this.getMigration());
        }
        catch (ConfigurationException e) {
            InvalidRequestException ex = new InvalidRequestException(e.toString());
            ex.initCause((Throwable)e);
            throw ex;
        }
        catch (IOException e) {
            InvalidRequestException ex = new InvalidRequestException(e.toString());
            ex.initCause((Throwable)e);
            throw ex;
        }
        return null;
    }

    private static void validateSchemaAgreement() throws SchemaDisagreementException {
        if (SchemaAlteringStatement.describeSchemaVersions().size() > 1) {
            throw new SchemaDisagreementException();
        }
    }

    private static void applyMigrationOnStage(final Migration m) throws SchemaDisagreementException, InvalidRequestException {
        Future<Object> f = StageManager.getStage(Stage.MIGRATION).submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                m.apply();
                m.announce();
                return null;
            }
        });
        try {
            f.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() != null) {
                InvalidRequestException ex = new InvalidRequestException(e.getCause().getMessage());
                ex.initCause(e.getCause());
                throw ex;
            }
            InvalidRequestException ex = new InvalidRequestException(e.getMessage());
            ex.initCause((Throwable)e);
            throw ex;
        }
        SchemaAlteringStatement.validateSchemaIsSettled();
    }

    private static Map<String, List<String>> describeSchemaVersions() {
        return Maps.filterKeys(StorageProxy.describeSchemaVersions(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)"UNREACHABLE")));
    }

    private static void validateSchemaIsSettled() throws SchemaDisagreementException {
        long limit = System.currentTimeMillis() + 10000L;
        block0: while (limit - System.currentTimeMillis() >= 0L) {
            String currentVersionId = Schema.instance.getVersion().toString();
            for (String version : SchemaAlteringStatement.describeSchemaVersions().keySet()) {
                if (version.equals(currentVersionId)) continue;
                continue block0;
            }
            return;
        }
        throw new SchemaDisagreementException();
    }
}

