/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.db.migration.UpdateColumnFamily;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.IndexType;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.ThriftValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateIndexStatement
extends SchemaAlteringStatement {
    private static final Logger logger = LoggerFactory.getLogger(CreateIndexStatement.class);
    private final String indexName;
    private final ColumnIdentifier columnName;

    public CreateIndexStatement(CFName name, String indexName, ColumnIdentifier columnName) {
        super(name);
        this.indexName = indexName;
        this.columnName = columnName;
    }

    @Override
    public Migration getMigration() throws InvalidRequestException, ConfigurationException {
        try {
            CFMetaData oldCfm = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
            boolean columnExists = false;
            CfDef cf_def = oldCfm.toThrift();
            for (ColumnDef cd : cf_def.column_metadata) {
                if (!cd.name.equals(this.columnName.key)) continue;
                if (cd.index_type != null) {
                    throw new InvalidRequestException("Index already exists");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Updating column {} definition for index {}", (Object)this.columnName, (Object)this.indexName);
                }
                cd.setIndex_type(IndexType.KEYS);
                cd.setIndex_name(this.indexName);
                columnExists = true;
                break;
            }
            if (!columnExists) {
                CFDefinition cfDef = oldCfm.getCfDef();
                CFDefinition.Name name = cfDef.get(this.columnName);
                if (name != null) {
                    switch (name.kind) {
                        case KEY_ALIAS: 
                        case COLUMN_ALIAS: {
                            throw new InvalidRequestException(String.format("Cannot create index on PRIMARY KEY part %s", this.columnName));
                        }
                        case VALUE_ALIAS: {
                            throw new InvalidRequestException(String.format("Cannot create index on column %s of compact CF", this.columnName));
                        }
                    }
                }
                throw new InvalidRequestException("No column definition found for column " + this.columnName);
            }
            CFMetaData.addDefaultIndexNames(cf_def);
            ThriftValidation.validateCfDef(cf_def, oldCfm);
            return new UpdateColumnFamily(cf_def);
        }
        catch (InvalidRequestException e) {
            logger.error("oups", (Throwable)e);
            throw e;
        }
        catch (ConfigurationException e) {
            logger.error("oups", (Throwable)e);
            throw e;
        }
    }
}

