/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql.CFPropDefs;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.InvalidRequestException;

public class AlterTableStatement {
    public final OperationType oType;
    public final String columnFamily;
    public final String columnName;
    public final String validator;
    private final CFPropDefs cfProps = new CFPropDefs();

    public AlterTableStatement(String columnFamily, OperationType type, String columnName) {
        this(columnFamily, type, columnName, null);
    }

    public AlterTableStatement(String columnFamily, OperationType type, String columnName, String validator) {
        this(columnFamily, type, columnName, validator, null);
    }

    public AlterTableStatement(String columnFamily, OperationType type, String columnName, String validator, Map<String, String> propertyMap) {
        this.columnFamily = columnFamily;
        this.oType = type;
        this.columnName = columnName;
        this.validator = CFPropDefs.comparators.get(validator);
        if (propertyMap != null) {
            for (Map.Entry<String, String> prop : propertyMap.entrySet()) {
                this.cfProps.addProperty(prop.getKey(), prop.getValue());
            }
        }
    }

    public CfDef getCfDef(String keyspace) throws ConfigurationException, InvalidRequestException {
        CFMetaData meta = Schema.instance.getCFMetaData(keyspace, this.columnFamily);
        CfDef cfDef = meta.toThrift();
        ByteBuffer columnName = this.oType == OperationType.OPTS ? null : meta.comparator.fromString(this.columnName);
        switch (this.oType) {
            case ADD: {
                if (cfDef.key_alias != null && cfDef.key_alias.equals(columnName)) {
                    throw new InvalidRequestException("Invalid column name: " + this.columnName + ", because it equals to key_alias.");
                }
                cfDef.column_metadata.add(new ColumnDefinition(columnName, TypeParser.parse(this.validator), null, null, null).toThrift());
                break;
            }
            case ALTER: {
                if (cfDef.key_alias != null && cfDef.key_alias.equals(columnName)) {
                    cfDef.setKey_validation_class(TypeParser.parse(this.validator).toString());
                    break;
                }
                ColumnDef toUpdate = null;
                for (ColumnDef columnDef : cfDef.column_metadata) {
                    if (!columnDef.name.equals(columnName)) continue;
                    toUpdate = columnDef;
                    break;
                }
                if (toUpdate == null) {
                    throw new InvalidRequestException(String.format("Column '%s' was not found in CF '%s'", this.columnName, this.columnFamily));
                }
                toUpdate.setValidation_class(TypeParser.parse(this.validator).toString());
                break;
            }
            case DROP: {
                ColumnDef toDelete = null;
                for (ColumnDef columnDef : cfDef.column_metadata) {
                    if (!columnDef.name.equals(columnName)) continue;
                    toDelete = columnDef;
                }
                if (toDelete == null) {
                    throw new InvalidRequestException(String.format("Column '%s' was not found in CF '%s'", this.columnName, this.columnFamily));
                }
                cfDef.column_metadata.remove(toDelete);
                break;
            }
            case OPTS: {
                if (this.cfProps == null) {
                    throw new InvalidRequestException(String.format("ALTER COLUMNFAMILY WITH invoked, but no parameters found", new Object[0]));
                }
                this.cfProps.validate();
                AlterTableStatement.applyPropertiesToCfDef(cfDef, this.cfProps);
            }
        }
        return cfDef;
    }

    public String toString() {
        return String.format("AlterTableStatement(cf=%s, type=%s, column=%s, validator=%s)", new Object[]{this.columnFamily, this.oType, this.columnName, this.validator});
    }

    public static void applyPropertiesToCfDef(CfDef cfDef, CFPropDefs cfProps) throws InvalidRequestException {
        if (cfProps.hasProperty("comparator").booleanValue()) {
            throw new InvalidRequestException("Can't change CF comparator after creation");
        }
        if (cfProps.hasProperty("comment").booleanValue()) {
            cfDef.comment = cfProps.getProperty("comment");
        }
        if (cfProps.hasProperty("default_validation").booleanValue()) {
            try {
                cfDef.default_validation_class = cfProps.getValidator().toString();
            }
            catch (ConfigurationException e) {
                throw new InvalidRequestException(String.format("Invalid validation type %s", cfProps.getProperty("default_validation")));
            }
        }
        cfDef.read_repair_chance = cfProps.getPropertyDouble("read_repair_chance", cfDef.read_repair_chance);
        cfDef.dclocal_read_repair_chance = cfProps.getPropertyDouble("dclocal_read_repair_chance", cfDef.dclocal_read_repair_chance);
        cfDef.gc_grace_seconds = cfProps.getPropertyInt("gc_grace_seconds", cfDef.gc_grace_seconds);
        cfDef.replicate_on_write = cfProps.getPropertyBoolean("replicate_on_write", cfDef.replicate_on_write);
        cfDef.min_compaction_threshold = cfProps.getPropertyInt("min_compaction_threshold", cfDef.min_compaction_threshold);
        cfDef.max_compaction_threshold = cfProps.getPropertyInt("max_compaction_threshold", cfDef.max_compaction_threshold);
        if (!cfProps.compactionStrategyOptions.isEmpty()) {
            cfDef.compaction_strategy_options = new HashMap();
            for (Map.Entry<String, String> entry : cfProps.compactionStrategyOptions.entrySet()) {
                cfDef.compaction_strategy_options.put(entry.getKey(), entry.getValue());
            }
        }
        if (!cfProps.compressionParameters.isEmpty()) {
            cfDef.compression_options = new HashMap();
            for (Map.Entry<String, String> entry : cfProps.compressionParameters.entrySet()) {
                cfDef.compression_options.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public static enum OperationType {
        ADD,
        ALTER,
        DROP,
        OPTS;

    }
}

