/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.migration.MigrationHelper;
import org.apache.cassandra.db.migration.avro.ColumnDef;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.IndexType;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ColumnDefinition {
    public final ByteBuffer name;
    private AbstractType<?> validator;
    private IndexType index_type;
    private Map<String, String> index_options;
    private String index_name;

    public ColumnDefinition(ByteBuffer name, AbstractType<?> validator, IndexType index_type, Map<String, String> index_options, String index_name) {
        this.name = name;
        this.index_name = index_name;
        this.validator = validator;
        this.setIndexType(index_type, index_options);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnDefinition that = (ColumnDefinition)o;
        if (this.index_name != null ? !this.index_name.equals(that.index_name) : that.index_name != null) {
            return false;
        }
        if (this.index_type != that.index_type) {
            return false;
        }
        if (this.index_options != null ? !((Object)this.index_options).equals(that.index_options) : that.index_options != null) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return !(this.validator == null ? that.validator != null : !this.validator.equals(that.validator));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.validator != null ? this.validator.hashCode() : 0);
        result = 31 * result + (this.index_type != null ? this.index_type.hashCode() : 0);
        result = 31 * result + (this.index_options != null ? ((Object)this.index_options).hashCode() : 0);
        result = 31 * result + (this.index_name != null ? this.index_name.hashCode() : 0);
        return result;
    }

    @Deprecated
    public static ColumnDefinition fromAvro(ColumnDef cd) {
        IndexType index_type = cd.index_type == null ? null : Enum.valueOf(IndexType.class, cd.index_type.name());
        String index_name = cd.index_name == null ? null : ((Object)cd.index_name).toString();
        try {
            AbstractType<?> validatorType = TypeParser.parse(cd.validation_class);
            return new ColumnDefinition(ByteBufferUtil.clone(cd.name), validatorType, index_type, ColumnDefinition.getStringMap(cd.index_options), index_name);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public org.apache.cassandra.thrift.ColumnDef toThrift() {
        org.apache.cassandra.thrift.ColumnDef cd = new org.apache.cassandra.thrift.ColumnDef();
        cd.setName(ByteBufferUtil.clone(this.name));
        cd.setValidation_class(this.validator.toString());
        cd.setIndex_type(this.index_type == null ? null : IndexType.valueOf((String)this.index_type.name()));
        cd.setIndex_name(this.index_name == null ? null : this.index_name);
        cd.setIndex_options(this.index_options == null ? null : Maps.newHashMap(this.index_options));
        return cd;
    }

    public static ColumnDefinition fromThrift(org.apache.cassandra.thrift.ColumnDef thriftColumnDef) throws ConfigurationException {
        return new ColumnDefinition(ByteBufferUtil.clone(thriftColumnDef.name), TypeParser.parse(thriftColumnDef.validation_class), thriftColumnDef.index_type, thriftColumnDef.index_options, thriftColumnDef.index_name);
    }

    public static Map<ByteBuffer, ColumnDefinition> fromThrift(List<org.apache.cassandra.thrift.ColumnDef> thriftDefs) throws ConfigurationException {
        if (thriftDefs == null) {
            return new HashMap<ByteBuffer, ColumnDefinition>();
        }
        TreeMap<ByteBuffer, ColumnDefinition> cds = new TreeMap<ByteBuffer, ColumnDefinition>();
        for (org.apache.cassandra.thrift.ColumnDef thriftColumnDef : thriftDefs) {
            cds.put(ByteBufferUtil.clone(thriftColumnDef.name), ColumnDefinition.fromThrift(thriftColumnDef));
        }
        return cds;
    }

    public static Map<ByteBuffer, org.apache.cassandra.thrift.ColumnDef> toMap(List<org.apache.cassandra.thrift.ColumnDef> columnDefs) {
        HashMap<ByteBuffer, org.apache.cassandra.thrift.ColumnDef> map = new HashMap<ByteBuffer, org.apache.cassandra.thrift.ColumnDef>();
        if (columnDefs == null) {
            return map;
        }
        for (org.apache.cassandra.thrift.ColumnDef columnDef : columnDefs) {
            map.put(columnDef.name, columnDef);
        }
        return map;
    }

    public static void deleteFromSchema(RowMutation mutation, String cfName, AbstractType comparator, ByteBuffer columnName, long timestamp) {
        ColumnDefinition.toSchema(mutation, comparator, cfName, columnName, null, timestamp, true);
    }

    public static void addToSchema(RowMutation mutation, String cfName, AbstractType comparator, org.apache.cassandra.thrift.ColumnDef columnDef, long timestamp) {
        ColumnDefinition.toSchema(mutation, comparator, cfName, columnDef.name, columnDef, timestamp, false);
    }

    private static void toSchema(RowMutation mutation, AbstractType comparator, String cfName, ByteBuffer columnName, org.apache.cassandra.thrift.ColumnDef columnDef, long timestamp, boolean delete) {
        for (ColumnDef._Fields field : ColumnDef._Fields.values()) {
            QueryPath path = new QueryPath("schema_columns", null, MigrationHelper.compositeNameFor(cfName, MigrationHelper.readableColumnName(columnName, comparator), field.getFieldName()));
            if (delete) {
                mutation.delete(path, timestamp);
                continue;
            }
            mutation.add(path, MigrationHelper.valueAsBytes(columnDef.getFieldValue(field)), timestamp);
        }
    }

    public static ColumnFamily readSchema(String ksName, String cfName) {
        DecoratedKey key = StorageService.getPartitioner().decorateKey(SystemTable.getSchemaKSKey(ksName));
        ColumnFamilyStore columnsStore = SystemTable.schemaCFS("schema_columns");
        return columnsStore.getColumnFamily(key, new QueryPath("schema_columns"), MigrationHelper.searchComposite(cfName, true), MigrationHelper.searchComposite(cfName, false), false, Integer.MAX_VALUE);
    }

    public static List<org.apache.cassandra.thrift.ColumnDef> fromSchema(ColumnFamily columns) {
        if (columns == null || columns.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, org.apache.cassandra.thrift.ColumnDef> contenders = new HashMap<String, org.apache.cassandra.thrift.ColumnDef>();
        for (IColumn column : columns.getSortedColumns()) {
            if (column.isMarkedForDelete()) continue;
            String[] components = columns.getComparator().getString(column.name()).split(":");
            assert (components.length == 3);
            org.apache.cassandra.thrift.ColumnDef columnDef = (org.apache.cassandra.thrift.ColumnDef)contenders.get(components[1]);
            if (columnDef == null) {
                columnDef = new org.apache.cassandra.thrift.ColumnDef();
                contenders.put(components[1], columnDef);
            }
            ColumnDef._Fields field = ColumnDef._Fields.findByName((String)components[2]);
            columnDef.setFieldValue(field, MigrationHelper.deserializeValue(column.value(), MigrationHelper.getValueClass(org.apache.cassandra.thrift.ColumnDef.class, field.getFieldName())));
        }
        ArrayList<org.apache.cassandra.thrift.ColumnDef> columnDefs = new ArrayList<org.apache.cassandra.thrift.ColumnDef>();
        for (org.apache.cassandra.thrift.ColumnDef columnDef : contenders.values()) {
            if (!columnDef.isSetName() || !columnDef.isSetValidation_class()) continue;
            columnDefs.add(columnDef);
        }
        return columnDefs;
    }

    public String toString() {
        return "ColumnDefinition{name=" + ByteBufferUtil.bytesToHex(this.name) + ", validator=" + this.validator + ", index_type=" + this.index_type + ", index_name='" + this.index_name + '\'' + '}';
    }

    public String getIndexName() {
        return this.index_name;
    }

    public void setIndexName(String s) {
        this.index_name = s;
    }

    public void setIndexType(IndexType index_type, Map<String, String> index_options) {
        this.index_type = index_type;
        this.index_options = index_options;
    }

    public IndexType getIndexType() {
        return this.index_type;
    }

    public Map<String, String> getIndexOptions() {
        return this.index_options;
    }

    public AbstractType<?> getValidator() {
        return this.validator;
    }

    public void setValidator(AbstractType<?> validator) {
        this.validator = validator;
    }

    public static Map<String, String> getStringMap(Map<CharSequence, CharSequence> charMap) {
        if (charMap == null) {
            return null;
        }
        HashMap<String, String> stringMap = new HashMap<String, String>();
        for (Map.Entry<CharSequence, CharSequence> entry : charMap.entrySet()) {
            stringMap.put(((Object)entry.getKey()).toString(), ((Object)entry.getValue()).toString());
        }
        return stringMap;
    }
}

