/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.Weigher;
import com.googlecode.concurrentlinkedhashmap.Weighers;
import java.util.Set;
import org.apache.cassandra.cache.ICache;

public class ConcurrentLinkedHashCache<K, V>
implements ICache<K, V> {
    public static final int DEFAULT_CONCURENCY_LEVEL = 64;
    private final ConcurrentLinkedHashMap<K, V> map;

    public ConcurrentLinkedHashCache(ConcurrentLinkedHashMap<K, V> map) {
        this.map = map;
    }

    public static <K, V> ConcurrentLinkedHashCache<K, V> create(int capacity) {
        return ConcurrentLinkedHashCache.create(capacity, Weighers.singleton());
    }

    public static <K, V> ConcurrentLinkedHashCache<K, V> create(int weightedCapacity, Weigher<V> weigher) {
        ConcurrentLinkedHashMap map = new ConcurrentLinkedHashMap.Builder().weigher(weigher).initialCapacity(0).maximumWeightedCapacity(weightedCapacity).concurrencyLevel(64).build();
        return new ConcurrentLinkedHashCache<K, V>(map);
    }

    @Override
    public int capacity() {
        return this.map.capacity();
    }

    @Override
    public void setCapacity(int capacity) {
        this.map.setCapacity(capacity);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public int weightedSize() {
        return this.map.weightedSize();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public V get(K key) {
        return (V)this.map.get(key);
    }

    @Override
    public void put(K key, V value) {
        this.map.put(key, value);
    }

    @Override
    public void remove(K key) {
        this.map.remove(key);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Set<K> hotKeySet(int n) {
        return this.map.descendingKeySetWithLimit(n);
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean isPutCopying() {
        return false;
    }
}

