// $ANTLR 3.2 Sep 23, 2009 12:02:23 /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g 2012-02-16 10:44:25

    package org.apache.cassandra.cql3;

    import java.util.Map;
    import java.util.HashMap;
    import java.util.Collections;
    import java.util.List;
    import java.util.ArrayList;

    import org.apache.cassandra.cql3.statements.*;
    import org.apache.cassandra.utils.Pair;
    import org.apache.cassandra.thrift.ConsistencyLevel;
    import org.apache.cassandra.thrift.InvalidRequestException;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

public class CqlParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "K_USE", "K_SELECT", "K_COUNT", "K_FROM", "K_USING", "K_CONSISTENCY", "K_LEVEL", "K_WHERE", "K_ORDER", "K_ASC", "K_DESC", "K_LIMIT", "INTEGER", "K_AND", "K_INSERT", "K_INTO", "K_VALUES", "K_TIMESTAMP", "K_TTL", "K_UPDATE", "K_SET", "K_DELETE", "K_BEGIN", "K_BATCH", "K_APPLY", "K_CREATE", "K_KEYSPACE", "K_WITH", "K_COLUMNFAMILY", "K_PRIMARY", "K_KEY", "K_COMPACT", "K_STORAGE", "K_INDEX", "IDENT", "K_ON", "K_ALTER", "K_TYPE", "K_ADD", "K_DROP", "K_TRUNCATE", "UUID", "QUOTED_NAME", "STRING_LITERAL", "FLOAT", "QMARK", "COMPIDENT", "K_IN", "S", "E", "L", "C", "T", "F", "R", "O", "M", "W", "H", "A", "N", "D", "K", "Y", "I", "U", "P", "G", "Q", "B", "X", "V", "J", "Z", "DIGIT", "LETTER", "HEX", "WS", "COMMENT", "MULTILINE_COMMENT", "';'", "'('", "')'", "'\\*'", "','", "'='", "'.'", "'+'", "'-'", "'<'", "'<='", "'>='", "'>'"
    };
    public static final int LETTER=79;
    public static final int K_CREATE=29;
    public static final int EOF=-1;
    public static final int K_PRIMARY=33;
    public static final int T__93=93;
    public static final int T__94=94;
    public static final int T__91=91;
    public static final int K_VALUES=20;
    public static final int T__92=92;
    public static final int K_USE=4;
    public static final int STRING_LITERAL=47;
    public static final int T__90=90;
    public static final int K_ON=39;
    public static final int K_USING=8;
    public static final int K_ADD=42;
    public static final int K_ASC=13;
    public static final int K_KEY=34;
    public static final int COMMENT=82;
    public static final int K_TRUNCATE=44;
    public static final int K_ORDER=12;
    public static final int T__96=96;
    public static final int T__95=95;
    public static final int D=65;
    public static final int E=53;
    public static final int F=57;
    public static final int G=71;
    public static final int K_KEYSPACE=30;
    public static final int K_COUNT=6;
    public static final int K_TYPE=41;
    public static final int A=63;
    public static final int B=73;
    public static final int C=55;
    public static final int L=54;
    public static final int M=60;
    public static final int N=64;
    public static final int O=59;
    public static final int H=62;
    public static final int I=68;
    public static final int K_UPDATE=23;
    public static final int J=76;
    public static final int K=66;
    public static final int U=69;
    public static final int T=56;
    public static final int W=61;
    public static final int V=75;
    public static final int Q=72;
    public static final int K_COMPACT=35;
    public static final int P=70;
    public static final int S=52;
    public static final int R=58;
    public static final int T__85=85;
    public static final int T__84=84;
    public static final int T__87=87;
    public static final int K_TTL=22;
    public static final int T__86=86;
    public static final int T__89=89;
    public static final int Y=67;
    public static final int T__88=88;
    public static final int X=74;
    public static final int Z=77;
    public static final int K_INDEX=37;
    public static final int K_INSERT=18;
    public static final int WS=81;
    public static final int K_APPLY=28;
    public static final int K_STORAGE=36;
    public static final int K_TIMESTAMP=21;
    public static final int K_AND=17;
    public static final int K_DESC=14;
    public static final int QMARK=49;
    public static final int K_LEVEL=10;
    public static final int K_BATCH=27;
    public static final int UUID=45;
    public static final int K_DELETE=25;
    public static final int FLOAT=48;
    public static final int K_SELECT=5;
    public static final int K_LIMIT=15;
    public static final int K_ALTER=40;
    public static final int K_SET=24;
    public static final int K_WHERE=11;
    public static final int QUOTED_NAME=46;
    public static final int MULTILINE_COMMENT=83;
    public static final int HEX=80;
    public static final int K_INTO=19;
    public static final int IDENT=38;
    public static final int DIGIT=78;
    public static final int K_BEGIN=26;
    public static final int INTEGER=16;
    public static final int K_CONSISTENCY=9;
    public static final int K_WITH=31;
    public static final int COMPIDENT=50;
    public static final int K_IN=51;
    public static final int K_FROM=7;
    public static final int K_COLUMNFAMILY=32;
    public static final int K_DROP=43;

    // delegates
    // delegators


        public CqlParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public CqlParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return CqlParser.tokenNames; }
    public String getGrammarFileName() { return "/tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g"; }


        private List<String> recognitionErrors = new ArrayList<String>();
        private int currentBindMarkerIdx = -1;

        public void displayRecognitionError(String[] tokenNames, RecognitionException e)
        {
            String hdr = getErrorHeader(e);
            String msg = getErrorMessage(e, tokenNames);
            recognitionErrors.add(hdr + " " + msg);
        }

        public List<String> getRecognitionErrors()
        {
            return recognitionErrors;
        }

        public void throwLastRecognitionError() throws InvalidRequestException
        {
            if (recognitionErrors.size() > 0)
                throw new InvalidRequestException(recognitionErrors.get((recognitionErrors.size()-1)));
        }

        // used by UPDATE of the counter columns to validate if '-' was supplied by user
        public void validateMinusSupplied(Object op, final Term value, IntStream stream) throws MissingTokenException
        {
            if (op == null && (value.isBindMarker() || Long.parseLong(value.getText()) > 0))
                throw new MissingTokenException(102, stream, value);
        }




    // $ANTLR start "query"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:116:1: query returns [ParsedStatement stmnt] : st= cqlStatement ( ';' )* EOF ;
    public final ParsedStatement query() throws RecognitionException {
        ParsedStatement stmnt = null;

        ParsedStatement st = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:119:5: (st= cqlStatement ( ';' )* EOF )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:119:7: st= cqlStatement ( ';' )* EOF
            {
            pushFollow(FOLLOW_cqlStatement_in_query72);
            st=cqlStatement();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:119:23: ( ';' )*
            loop1:
            do {
                int alt1=2;
                int LA1_0 = input.LA(1);

                if ( (LA1_0==84) ) {
                    alt1=1;
                }


                switch (alt1) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:119:24: ';'
            	    {
            	    match(input,84,FOLLOW_84_in_query75); 

            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);

            match(input,EOF,FOLLOW_EOF_in_query79); 
             stmnt = st; 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmnt;
    }
    // $ANTLR end "query"


    // $ANTLR start "cqlStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:122:1: cqlStatement returns [ParsedStatement stmt] : (st1= selectStatement | st2= insertStatement | st3= updateStatement | st4= batchStatement | st5= deleteStatement | st6= useStatement | st7= truncateStatement | st8= createKeyspaceStatement | st9= createColumnFamilyStatement | st10= createIndexStatement | st11= dropKeyspaceStatement | st12= dropColumnFamilyStatement | st13= dropIndexStatement | st14= alterTableStatement );
    public final ParsedStatement cqlStatement() throws RecognitionException {
        ParsedStatement stmt = null;

        SelectStatement.RawStatement st1 = null;

        UpdateStatement st2 = null;

        UpdateStatement st3 = null;

        BatchStatement st4 = null;

        DeleteStatement st5 = null;

        UseStatement st6 = null;

        TruncateStatement st7 = null;

        CreateKeyspaceStatement st8 = null;

        CreateColumnFamilyStatement.RawStatement st9 = null;

        CreateIndexStatement st10 = null;

        DropKeyspaceStatement st11 = null;

        DropColumnFamilyStatement st12 = null;

        DropIndexStatement st13 = null;

        AlterTableStatement st14 = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:124:5: (st1= selectStatement | st2= insertStatement | st3= updateStatement | st4= batchStatement | st5= deleteStatement | st6= useStatement | st7= truncateStatement | st8= createKeyspaceStatement | st9= createColumnFamilyStatement | st10= createIndexStatement | st11= dropKeyspaceStatement | st12= dropColumnFamilyStatement | st13= dropIndexStatement | st14= alterTableStatement )
            int alt2=14;
            alt2 = dfa2.predict(input);
            switch (alt2) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:124:7: st1= selectStatement
                    {
                    pushFollow(FOLLOW_selectStatement_in_cqlStatement113);
                    st1=selectStatement();

                    state._fsp--;

                     stmt = st1; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:125:7: st2= insertStatement
                    {
                    pushFollow(FOLLOW_insertStatement_in_cqlStatement138);
                    st2=insertStatement();

                    state._fsp--;

                     stmt = st2; 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:126:7: st3= updateStatement
                    {
                    pushFollow(FOLLOW_updateStatement_in_cqlStatement163);
                    st3=updateStatement();

                    state._fsp--;

                     stmt = st3; 

                    }
                    break;
                case 4 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:127:7: st4= batchStatement
                    {
                    pushFollow(FOLLOW_batchStatement_in_cqlStatement188);
                    st4=batchStatement();

                    state._fsp--;

                     stmt = st4; 

                    }
                    break;
                case 5 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:128:7: st5= deleteStatement
                    {
                    pushFollow(FOLLOW_deleteStatement_in_cqlStatement214);
                    st5=deleteStatement();

                    state._fsp--;

                     stmt = st5; 

                    }
                    break;
                case 6 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:129:7: st6= useStatement
                    {
                    pushFollow(FOLLOW_useStatement_in_cqlStatement239);
                    st6=useStatement();

                    state._fsp--;

                     stmt = st6; 

                    }
                    break;
                case 7 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:130:7: st7= truncateStatement
                    {
                    pushFollow(FOLLOW_truncateStatement_in_cqlStatement267);
                    st7=truncateStatement();

                    state._fsp--;

                     stmt = st7; 

                    }
                    break;
                case 8 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:131:7: st8= createKeyspaceStatement
                    {
                    pushFollow(FOLLOW_createKeyspaceStatement_in_cqlStatement290);
                    st8=createKeyspaceStatement();

                    state._fsp--;

                     stmt = st8; 

                    }
                    break;
                case 9 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:132:7: st9= createColumnFamilyStatement
                    {
                    pushFollow(FOLLOW_createColumnFamilyStatement_in_cqlStatement307);
                    st9=createColumnFamilyStatement();

                    state._fsp--;

                     stmt = st9; 

                    }
                    break;
                case 10 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:133:7: st10= createIndexStatement
                    {
                    pushFollow(FOLLOW_createIndexStatement_in_cqlStatement319);
                    st10=createIndexStatement();

                    state._fsp--;

                     stmt = st10; 

                    }
                    break;
                case 11 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:134:7: st11= dropKeyspaceStatement
                    {
                    pushFollow(FOLLOW_dropKeyspaceStatement_in_cqlStatement338);
                    st11=dropKeyspaceStatement();

                    state._fsp--;

                     stmt = st11; 

                    }
                    break;
                case 12 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:135:7: st12= dropColumnFamilyStatement
                    {
                    pushFollow(FOLLOW_dropColumnFamilyStatement_in_cqlStatement356);
                    st12=dropColumnFamilyStatement();

                    state._fsp--;

                     stmt = st12; 

                    }
                    break;
                case 13 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:136:7: st13= dropIndexStatement
                    {
                    pushFollow(FOLLOW_dropIndexStatement_in_cqlStatement370);
                    st13=dropIndexStatement();

                    state._fsp--;

                     stmt = st13; 

                    }
                    break;
                case 14 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:137:7: st14= alterTableStatement
                    {
                    pushFollow(FOLLOW_alterTableStatement_in_cqlStatement391);
                    st14=alterTableStatement();

                    state._fsp--;

                     stmt = st14; 

                    }
                    break;

            }
             if (stmt != null) stmt.setBoundTerms(currentBindMarkerIdx + 1); 
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "cqlStatement"


    // $ANTLR start "useStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:143:1: useStatement returns [UseStatement stmt] : K_USE ks= keyspaceName ;
    public final UseStatement useStatement() throws RecognitionException {
        UseStatement stmt = null;

        String ks = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:144:5: ( K_USE ks= keyspaceName )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:144:7: K_USE ks= keyspaceName
            {
            match(input,K_USE,FOLLOW_K_USE_in_useStatement424); 
            pushFollow(FOLLOW_keyspaceName_in_useStatement428);
            ks=keyspaceName();

            state._fsp--;

             stmt = new UseStatement(ks); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "useStatement"


    // $ANTLR start "selectStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:147:1: selectStatement returns [SelectStatement.RawStatement expr] : K_SELECT (sclause= selectClause | ( K_COUNT '(' sclause= selectClause ')' ) ) K_FROM cf= columnFamilyName ( K_USING K_CONSISTENCY K_LEVEL )? ( K_WHERE wclause= whereClause )? ( K_ORDER ( K_ASC | K_DESC ) )? ( K_LIMIT rows= INTEGER )? ;
    public final SelectStatement.RawStatement selectStatement() throws RecognitionException {
        SelectStatement.RawStatement expr = null;

        Token rows=null;
        Token K_LEVEL1=null;
        List<ColumnIdentifier> sclause = null;

        CFName cf = null;

        List<Relation> wclause = null;



                boolean isCount = false;
                ConsistencyLevel cLevel = ConsistencyLevel.ONE;
                int limit = 10000;
                boolean reversed = false;
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:161:5: ( K_SELECT (sclause= selectClause | ( K_COUNT '(' sclause= selectClause ')' ) ) K_FROM cf= columnFamilyName ( K_USING K_CONSISTENCY K_LEVEL )? ( K_WHERE wclause= whereClause )? ( K_ORDER ( K_ASC | K_DESC ) )? ( K_LIMIT rows= INTEGER )? )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:161:7: K_SELECT (sclause= selectClause | ( K_COUNT '(' sclause= selectClause ')' ) ) K_FROM cf= columnFamilyName ( K_USING K_CONSISTENCY K_LEVEL )? ( K_WHERE wclause= whereClause )? ( K_ORDER ( K_ASC | K_DESC ) )? ( K_LIMIT rows= INTEGER )?
            {
            match(input,K_SELECT,FOLLOW_K_SELECT_in_selectStatement462); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:161:16: (sclause= selectClause | ( K_COUNT '(' sclause= selectClause ')' ) )
            int alt3=2;
            int LA3_0 = input.LA(1);

            if ( (LA3_0==INTEGER||LA3_0==IDENT||(LA3_0>=UUID && LA3_0<=QUOTED_NAME)||LA3_0==87) ) {
                alt3=1;
            }
            else if ( (LA3_0==K_COUNT) ) {
                alt3=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 3, 0, input);

                throw nvae;
            }
            switch (alt3) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:161:18: sclause= selectClause
                    {
                    pushFollow(FOLLOW_selectClause_in_selectStatement468);
                    sclause=selectClause();

                    state._fsp--;


                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:161:41: ( K_COUNT '(' sclause= selectClause ')' )
                    {
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:161:41: ( K_COUNT '(' sclause= selectClause ')' )
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:161:42: K_COUNT '(' sclause= selectClause ')'
                    {
                    match(input,K_COUNT,FOLLOW_K_COUNT_in_selectStatement473); 
                    match(input,85,FOLLOW_85_in_selectStatement475); 
                    pushFollow(FOLLOW_selectClause_in_selectStatement479);
                    sclause=selectClause();

                    state._fsp--;

                    match(input,86,FOLLOW_86_in_selectStatement481); 
                     isCount = true; 

                    }


                    }
                    break;

            }

            match(input,K_FROM,FOLLOW_K_FROM_in_selectStatement494); 
            pushFollow(FOLLOW_columnFamilyName_in_selectStatement498);
            cf=columnFamilyName();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:163:7: ( K_USING K_CONSISTENCY K_LEVEL )?
            int alt4=2;
            int LA4_0 = input.LA(1);

            if ( (LA4_0==K_USING) ) {
                alt4=1;
            }
            switch (alt4) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:163:9: K_USING K_CONSISTENCY K_LEVEL
                    {
                    match(input,K_USING,FOLLOW_K_USING_in_selectStatement508); 
                    match(input,K_CONSISTENCY,FOLLOW_K_CONSISTENCY_in_selectStatement510); 
                    K_LEVEL1=(Token)match(input,K_LEVEL,FOLLOW_K_LEVEL_in_selectStatement512); 
                     cLevel = ConsistencyLevel.valueOf((K_LEVEL1!=null?K_LEVEL1.getText():null).toUpperCase()); 

                    }
                    break;

            }

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:164:7: ( K_WHERE wclause= whereClause )?
            int alt5=2;
            int LA5_0 = input.LA(1);

            if ( (LA5_0==K_WHERE) ) {
                alt5=1;
            }
            switch (alt5) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:164:9: K_WHERE wclause= whereClause
                    {
                    match(input,K_WHERE,FOLLOW_K_WHERE_in_selectStatement527); 
                    pushFollow(FOLLOW_whereClause_in_selectStatement531);
                    wclause=whereClause();

                    state._fsp--;


                    }
                    break;

            }

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:165:7: ( K_ORDER ( K_ASC | K_DESC ) )?
            int alt7=2;
            int LA7_0 = input.LA(1);

            if ( (LA7_0==K_ORDER) ) {
                alt7=1;
            }
            switch (alt7) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:165:9: K_ORDER ( K_ASC | K_DESC )
                    {
                    match(input,K_ORDER,FOLLOW_K_ORDER_in_selectStatement544); 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:165:17: ( K_ASC | K_DESC )
                    int alt6=2;
                    int LA6_0 = input.LA(1);

                    if ( (LA6_0==K_ASC) ) {
                        alt6=1;
                    }
                    else if ( (LA6_0==K_DESC) ) {
                        alt6=2;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("", 6, 0, input);

                        throw nvae;
                    }
                    switch (alt6) {
                        case 1 :
                            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:165:18: K_ASC
                            {
                            match(input,K_ASC,FOLLOW_K_ASC_in_selectStatement547); 

                            }
                            break;
                        case 2 :
                            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:165:26: K_DESC
                            {
                            match(input,K_DESC,FOLLOW_K_DESC_in_selectStatement551); 
                             reversed = true; 

                            }
                            break;

                    }


                    }
                    break;

            }

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:166:7: ( K_LIMIT rows= INTEGER )?
            int alt8=2;
            int LA8_0 = input.LA(1);

            if ( (LA8_0==K_LIMIT) ) {
                alt8=1;
            }
            switch (alt8) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:166:9: K_LIMIT rows= INTEGER
                    {
                    match(input,K_LIMIT,FOLLOW_K_LIMIT_in_selectStatement567); 
                    rows=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_selectStatement571); 
                     limit = Integer.parseInt((rows!=null?rows.getText():null)); 

                    }
                    break;

            }


                      SelectStatement.Parameters params = new SelectStatement.Parameters(cLevel,
                                                                                         limit,
                                                                                         reversed,
                                                                                         isCount);
                      expr = new SelectStatement.RawStatement(cf, params, sclause, wclause);
                  

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "selectStatement"


    // $ANTLR start "selectClause"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:176:1: selectClause returns [List<ColumnIdentifier> expr] : (ids= cidentList | '\\*' );
    public final List<ColumnIdentifier> selectClause() throws RecognitionException {
        List<ColumnIdentifier> expr = null;

        List<ColumnIdentifier> ids = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:177:5: (ids= cidentList | '\\*' )
            int alt9=2;
            int LA9_0 = input.LA(1);

            if ( (LA9_0==INTEGER||LA9_0==IDENT||(LA9_0>=UUID && LA9_0<=QUOTED_NAME)) ) {
                alt9=1;
            }
            else if ( (LA9_0==87) ) {
                alt9=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 9, 0, input);

                throw nvae;
            }
            switch (alt9) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:177:7: ids= cidentList
                    {
                    pushFollow(FOLLOW_cidentList_in_selectClause607);
                    ids=cidentList();

                    state._fsp--;

                     expr = ids; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:178:7: '\\*'
                    {
                    match(input,87,FOLLOW_87_in_selectClause617); 
                     expr = Collections.<ColumnIdentifier>emptyList();

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "selectClause"


    // $ANTLR start "whereClause"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:181:1: whereClause returns [List<Relation> clause] : first= relation ( K_AND next= relation )* ;
    public final List<Relation> whereClause() throws RecognitionException {
        List<Relation> clause = null;

        Relation first = null;

        Relation next = null;


         clause = new ArrayList<Relation>(); 
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:183:5: (first= relation ( K_AND next= relation )* )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:183:7: first= relation ( K_AND next= relation )*
            {
            pushFollow(FOLLOW_relation_in_whereClause660);
            first=relation();

            state._fsp--;

             clause.add(first); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:183:46: ( K_AND next= relation )*
            loop10:
            do {
                int alt10=2;
                int LA10_0 = input.LA(1);

                if ( (LA10_0==K_AND) ) {
                    alt10=1;
                }


                switch (alt10) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:183:47: K_AND next= relation
            	    {
            	    match(input,K_AND,FOLLOW_K_AND_in_whereClause665); 
            	    pushFollow(FOLLOW_relation_in_whereClause669);
            	    next=relation();

            	    state._fsp--;

            	     clause.add(next); 

            	    }
            	    break;

            	default :
            	    break loop10;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return clause;
    }
    // $ANTLR end "whereClause"


    // $ANTLR start "insertStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:186:1: insertStatement returns [UpdateStatement expr] : K_INSERT K_INTO cf= columnFamilyName '(' c1= cident ( ',' cn= cident )+ ')' K_VALUES '(' v1= term ( ',' vn= term )+ ')' ( usingClause[attrs] )? ;
    public final UpdateStatement insertStatement() throws RecognitionException {
        UpdateStatement expr = null;

        CFName cf = null;

        ColumnIdentifier c1 = null;

        ColumnIdentifier cn = null;

        Term v1 = null;

        Term vn = null;



                Attributes attrs = new Attributes();
                List<ColumnIdentifier> columnNames  = new ArrayList<ColumnIdentifier>();
                List<Term> columnValues = new ArrayList<Term>();
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:199:5: ( K_INSERT K_INTO cf= columnFamilyName '(' c1= cident ( ',' cn= cident )+ ')' K_VALUES '(' v1= term ( ',' vn= term )+ ')' ( usingClause[attrs] )? )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:199:7: K_INSERT K_INTO cf= columnFamilyName '(' c1= cident ( ',' cn= cident )+ ')' K_VALUES '(' v1= term ( ',' vn= term )+ ')' ( usingClause[attrs] )?
            {
            match(input,K_INSERT,FOLLOW_K_INSERT_in_insertStatement705); 
            match(input,K_INTO,FOLLOW_K_INTO_in_insertStatement707); 
            pushFollow(FOLLOW_columnFamilyName_in_insertStatement711);
            cf=columnFamilyName();

            state._fsp--;

            match(input,85,FOLLOW_85_in_insertStatement723); 
            pushFollow(FOLLOW_cident_in_insertStatement727);
            c1=cident();

            state._fsp--;

             columnNames.add(c1); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:200:51: ( ',' cn= cident )+
            int cnt11=0;
            loop11:
            do {
                int alt11=2;
                int LA11_0 = input.LA(1);

                if ( (LA11_0==88) ) {
                    alt11=1;
                }


                switch (alt11) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:200:53: ',' cn= cident
            	    {
            	    match(input,88,FOLLOW_88_in_insertStatement734); 
            	    pushFollow(FOLLOW_cident_in_insertStatement738);
            	    cn=cident();

            	    state._fsp--;

            	     columnNames.add(cn); 

            	    }
            	    break;

            	default :
            	    if ( cnt11 >= 1 ) break loop11;
                        EarlyExitException eee =
                            new EarlyExitException(11, input);
                        throw eee;
                }
                cnt11++;
            } while (true);

            match(input,86,FOLLOW_86_in_insertStatement745); 
            match(input,K_VALUES,FOLLOW_K_VALUES_in_insertStatement755); 
            match(input,85,FOLLOW_85_in_insertStatement767); 
            pushFollow(FOLLOW_term_in_insertStatement771);
            v1=term();

            state._fsp--;

             columnValues.add(v1); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:202:49: ( ',' vn= term )+
            int cnt12=0;
            loop12:
            do {
                int alt12=2;
                int LA12_0 = input.LA(1);

                if ( (LA12_0==88) ) {
                    alt12=1;
                }


                switch (alt12) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:202:51: ',' vn= term
            	    {
            	    match(input,88,FOLLOW_88_in_insertStatement777); 
            	    pushFollow(FOLLOW_term_in_insertStatement781);
            	    vn=term();

            	    state._fsp--;

            	     columnValues.add(vn); 

            	    }
            	    break;

            	default :
            	    if ( cnt12 >= 1 ) break loop12;
                        EarlyExitException eee =
                            new EarlyExitException(12, input);
                        throw eee;
                }
                cnt12++;
            } while (true);

            match(input,86,FOLLOW_86_in_insertStatement788); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:203:9: ( usingClause[attrs] )?
            int alt13=2;
            int LA13_0 = input.LA(1);

            if ( (LA13_0==K_USING) ) {
                alt13=1;
            }
            switch (alt13) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:203:11: usingClause[attrs]
                    {
                    pushFollow(FOLLOW_usingClause_in_insertStatement800);
                    usingClause(attrs);

                    state._fsp--;


                    }
                    break;

            }


                      expr = new UpdateStatement(cf, columnNames, columnValues, attrs);
                  

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "insertStatement"


    // $ANTLR start "usingClause"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:209:1: usingClause[Attributes attrs] : K_USING usingClauseObjective[attrs] ( ( K_AND )? usingClauseObjective[attrs] )* ;
    public final void usingClause(Attributes attrs) throws RecognitionException {
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:210:5: ( K_USING usingClauseObjective[attrs] ( ( K_AND )? usingClauseObjective[attrs] )* )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:210:7: K_USING usingClauseObjective[attrs] ( ( K_AND )? usingClauseObjective[attrs] )*
            {
            match(input,K_USING,FOLLOW_K_USING_in_usingClause830); 
            pushFollow(FOLLOW_usingClauseObjective_in_usingClause832);
            usingClauseObjective(attrs);

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:210:43: ( ( K_AND )? usingClauseObjective[attrs] )*
            loop15:
            do {
                int alt15=2;
                int LA15_0 = input.LA(1);

                if ( (LA15_0==K_CONSISTENCY||LA15_0==K_AND||(LA15_0>=K_TIMESTAMP && LA15_0<=K_TTL)) ) {
                    alt15=1;
                }


                switch (alt15) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:210:45: ( K_AND )? usingClauseObjective[attrs]
            	    {
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:210:45: ( K_AND )?
            	    int alt14=2;
            	    int LA14_0 = input.LA(1);

            	    if ( (LA14_0==K_AND) ) {
            	        alt14=1;
            	    }
            	    switch (alt14) {
            	        case 1 :
            	            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:210:45: K_AND
            	            {
            	            match(input,K_AND,FOLLOW_K_AND_in_usingClause837); 

            	            }
            	            break;

            	    }

            	    pushFollow(FOLLOW_usingClauseObjective_in_usingClause840);
            	    usingClauseObjective(attrs);

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop15;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "usingClause"


    // $ANTLR start "usingClauseDelete"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:213:1: usingClauseDelete[Attributes attrs] : K_USING usingClauseDeleteObjective[attrs] ( ( K_AND )? usingClauseDeleteObjective[attrs] )* ;
    public final void usingClauseDelete(Attributes attrs) throws RecognitionException {
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:214:5: ( K_USING usingClauseDeleteObjective[attrs] ( ( K_AND )? usingClauseDeleteObjective[attrs] )* )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:214:7: K_USING usingClauseDeleteObjective[attrs] ( ( K_AND )? usingClauseDeleteObjective[attrs] )*
            {
            match(input,K_USING,FOLLOW_K_USING_in_usingClauseDelete862); 
            pushFollow(FOLLOW_usingClauseDeleteObjective_in_usingClauseDelete864);
            usingClauseDeleteObjective(attrs);

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:214:49: ( ( K_AND )? usingClauseDeleteObjective[attrs] )*
            loop17:
            do {
                int alt17=2;
                int LA17_0 = input.LA(1);

                if ( (LA17_0==K_CONSISTENCY||LA17_0==K_AND||LA17_0==K_TIMESTAMP) ) {
                    alt17=1;
                }


                switch (alt17) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:214:51: ( K_AND )? usingClauseDeleteObjective[attrs]
            	    {
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:214:51: ( K_AND )?
            	    int alt16=2;
            	    int LA16_0 = input.LA(1);

            	    if ( (LA16_0==K_AND) ) {
            	        alt16=1;
            	    }
            	    switch (alt16) {
            	        case 1 :
            	            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:214:51: K_AND
            	            {
            	            match(input,K_AND,FOLLOW_K_AND_in_usingClauseDelete869); 

            	            }
            	            break;

            	    }

            	    pushFollow(FOLLOW_usingClauseDeleteObjective_in_usingClauseDelete872);
            	    usingClauseDeleteObjective(attrs);

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop17;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "usingClauseDelete"


    // $ANTLR start "usingClauseDeleteObjective"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:217:1: usingClauseDeleteObjective[Attributes attrs] : ( K_CONSISTENCY K_LEVEL | K_TIMESTAMP ts= INTEGER );
    public final void usingClauseDeleteObjective(Attributes attrs) throws RecognitionException {
        Token ts=null;
        Token K_LEVEL2=null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:218:5: ( K_CONSISTENCY K_LEVEL | K_TIMESTAMP ts= INTEGER )
            int alt18=2;
            int LA18_0 = input.LA(1);

            if ( (LA18_0==K_CONSISTENCY) ) {
                alt18=1;
            }
            else if ( (LA18_0==K_TIMESTAMP) ) {
                alt18=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 18, 0, input);

                throw nvae;
            }
            switch (alt18) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:218:7: K_CONSISTENCY K_LEVEL
                    {
                    match(input,K_CONSISTENCY,FOLLOW_K_CONSISTENCY_in_usingClauseDeleteObjective894); 
                    K_LEVEL2=(Token)match(input,K_LEVEL,FOLLOW_K_LEVEL_in_usingClauseDeleteObjective896); 
                     attrs.cLevel = ConsistencyLevel.valueOf((K_LEVEL2!=null?K_LEVEL2.getText():null).toUpperCase()); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:219:7: K_TIMESTAMP ts= INTEGER
                    {
                    match(input,K_TIMESTAMP,FOLLOW_K_TIMESTAMP_in_usingClauseDeleteObjective907); 
                    ts=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_usingClauseDeleteObjective911); 
                     attrs.timestamp = Long.valueOf((ts!=null?ts.getText():null)); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "usingClauseDeleteObjective"


    // $ANTLR start "usingClauseObjective"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:222:1: usingClauseObjective[Attributes attrs] : ( usingClauseDeleteObjective[attrs] | K_TTL t= INTEGER );
    public final void usingClauseObjective(Attributes attrs) throws RecognitionException {
        Token t=null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:223:5: ( usingClauseDeleteObjective[attrs] | K_TTL t= INTEGER )
            int alt19=2;
            int LA19_0 = input.LA(1);

            if ( (LA19_0==K_CONSISTENCY||LA19_0==K_TIMESTAMP) ) {
                alt19=1;
            }
            else if ( (LA19_0==K_TTL) ) {
                alt19=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 19, 0, input);

                throw nvae;
            }
            switch (alt19) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:223:7: usingClauseDeleteObjective[attrs]
                    {
                    pushFollow(FOLLOW_usingClauseDeleteObjective_in_usingClauseObjective931);
                    usingClauseDeleteObjective(attrs);

                    state._fsp--;


                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:224:7: K_TTL t= INTEGER
                    {
                    match(input,K_TTL,FOLLOW_K_TTL_in_usingClauseObjective940); 
                    t=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_usingClauseObjective944); 
                     attrs.timeToLive = Integer.valueOf((t!=null?t.getText():null)); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "usingClauseObjective"


    // $ANTLR start "updateStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:227:1: updateStatement returns [UpdateStatement expr] : K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET termPairWithOperation[columns] ( ',' termPairWithOperation[columns] )* K_WHERE wclause= whereClause ;
    public final UpdateStatement updateStatement() throws RecognitionException {
        UpdateStatement expr = null;

        CFName cf = null;

        List<Relation> wclause = null;



                Attributes attrs = new Attributes();
                Map<ColumnIdentifier, Operation> columns = new HashMap<ColumnIdentifier, Operation>();
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:238:5: ( K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET termPairWithOperation[columns] ( ',' termPairWithOperation[columns] )* K_WHERE wclause= whereClause )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:238:7: K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET termPairWithOperation[columns] ( ',' termPairWithOperation[columns] )* K_WHERE wclause= whereClause
            {
            match(input,K_UPDATE,FOLLOW_K_UPDATE_in_updateStatement978); 
            pushFollow(FOLLOW_columnFamilyName_in_updateStatement982);
            cf=columnFamilyName();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:239:7: ( usingClause[attrs] )?
            int alt20=2;
            int LA20_0 = input.LA(1);

            if ( (LA20_0==K_USING) ) {
                alt20=1;
            }
            switch (alt20) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:239:9: usingClause[attrs]
                    {
                    pushFollow(FOLLOW_usingClause_in_updateStatement992);
                    usingClause(attrs);

                    state._fsp--;


                    }
                    break;

            }

            match(input,K_SET,FOLLOW_K_SET_in_updateStatement1004); 
            pushFollow(FOLLOW_termPairWithOperation_in_updateStatement1006);
            termPairWithOperation(columns);

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:240:44: ( ',' termPairWithOperation[columns] )*
            loop21:
            do {
                int alt21=2;
                int LA21_0 = input.LA(1);

                if ( (LA21_0==88) ) {
                    alt21=1;
                }


                switch (alt21) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:240:45: ',' termPairWithOperation[columns]
            	    {
            	    match(input,88,FOLLOW_88_in_updateStatement1010); 
            	    pushFollow(FOLLOW_termPairWithOperation_in_updateStatement1012);
            	    termPairWithOperation(columns);

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop21;
                }
            } while (true);

            match(input,K_WHERE,FOLLOW_K_WHERE_in_updateStatement1023); 
            pushFollow(FOLLOW_whereClause_in_updateStatement1027);
            wclause=whereClause();

            state._fsp--;


                      return new UpdateStatement(cf, columns, wclause, attrs);
                  

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "updateStatement"


    // $ANTLR start "deleteStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:247:1: deleteStatement returns [DeleteStatement expr] : K_DELETE (ids= cidentList )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause ;
    public final DeleteStatement deleteStatement() throws RecognitionException {
        DeleteStatement expr = null;

        List<ColumnIdentifier> ids = null;

        CFName cf = null;

        List<Relation> wclause = null;



                Attributes attrs = new Attributes();
                List<ColumnIdentifier> columnsList = Collections.emptyList();
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:258:5: ( K_DELETE (ids= cidentList )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:258:7: K_DELETE (ids= cidentList )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause
            {
            match(input,K_DELETE,FOLLOW_K_DELETE_in_deleteStatement1067); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:258:16: (ids= cidentList )?
            int alt22=2;
            int LA22_0 = input.LA(1);

            if ( (LA22_0==INTEGER||LA22_0==IDENT||(LA22_0>=UUID && LA22_0<=QUOTED_NAME)) ) {
                alt22=1;
            }
            switch (alt22) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:258:18: ids= cidentList
                    {
                    pushFollow(FOLLOW_cidentList_in_deleteStatement1073);
                    ids=cidentList();

                    state._fsp--;

                     columnsList = ids; 

                    }
                    break;

            }

            match(input,K_FROM,FOLLOW_K_FROM_in_deleteStatement1086); 
            pushFollow(FOLLOW_columnFamilyName_in_deleteStatement1090);
            cf=columnFamilyName();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:260:7: ( usingClauseDelete[attrs] )?
            int alt23=2;
            int LA23_0 = input.LA(1);

            if ( (LA23_0==K_USING) ) {
                alt23=1;
            }
            switch (alt23) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:260:9: usingClauseDelete[attrs]
                    {
                    pushFollow(FOLLOW_usingClauseDelete_in_deleteStatement1100);
                    usingClauseDelete(attrs);

                    state._fsp--;


                    }
                    break;

            }

            match(input,K_WHERE,FOLLOW_K_WHERE_in_deleteStatement1112); 
            pushFollow(FOLLOW_whereClause_in_deleteStatement1116);
            wclause=whereClause();

            state._fsp--;


                      return new DeleteStatement(cf, columnsList, wclause, attrs);
                  

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "deleteStatement"


    // $ANTLR start "batchStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:268:1: batchStatement returns [BatchStatement expr] : K_BEGIN K_BATCH ( usingClause[attrs] )? s1= batchStatementObjective ( ';' )? (sN= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH ;
    public final BatchStatement batchStatement() throws RecognitionException {
        BatchStatement expr = null;

        ModificationStatement s1 = null;

        ModificationStatement sN = null;



                Attributes attrs = new Attributes();
                List<ModificationStatement> statements = new ArrayList<ModificationStatement>();
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:297:5: ( K_BEGIN K_BATCH ( usingClause[attrs] )? s1= batchStatementObjective ( ';' )? (sN= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:297:7: K_BEGIN K_BATCH ( usingClause[attrs] )? s1= batchStatementObjective ( ';' )? (sN= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH
            {
            match(input,K_BEGIN,FOLLOW_K_BEGIN_in_batchStatement1157); 
            match(input,K_BATCH,FOLLOW_K_BATCH_in_batchStatement1159); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:297:23: ( usingClause[attrs] )?
            int alt24=2;
            int LA24_0 = input.LA(1);

            if ( (LA24_0==K_USING) ) {
                alt24=1;
            }
            switch (alt24) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:297:25: usingClause[attrs]
                    {
                    pushFollow(FOLLOW_usingClause_in_batchStatement1163);
                    usingClause(attrs);

                    state._fsp--;


                    }
                    break;

            }

            pushFollow(FOLLOW_batchStatementObjective_in_batchStatement1181);
            s1=batchStatementObjective();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:298:38: ( ';' )?
            int alt25=2;
            int LA25_0 = input.LA(1);

            if ( (LA25_0==84) ) {
                alt25=1;
            }
            switch (alt25) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:298:38: ';'
                    {
                    match(input,84,FOLLOW_84_in_batchStatement1183); 

                    }
                    break;

            }

             statements.add(s1); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:298:67: (sN= batchStatementObjective ( ';' )? )*
            loop27:
            do {
                int alt27=2;
                int LA27_0 = input.LA(1);

                if ( (LA27_0==K_INSERT||LA27_0==K_UPDATE||LA27_0==K_DELETE) ) {
                    alt27=1;
                }


                switch (alt27) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:298:69: sN= batchStatementObjective ( ';' )?
            	    {
            	    pushFollow(FOLLOW_batchStatementObjective_in_batchStatement1192);
            	    sN=batchStatementObjective();

            	    state._fsp--;

            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:298:96: ( ';' )?
            	    int alt26=2;
            	    int LA26_0 = input.LA(1);

            	    if ( (LA26_0==84) ) {
            	        alt26=1;
            	    }
            	    switch (alt26) {
            	        case 1 :
            	            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:298:96: ';'
            	            {
            	            match(input,84,FOLLOW_84_in_batchStatement1194); 

            	            }
            	            break;

            	    }

            	     statements.add(sN); 

            	    }
            	    break;

            	default :
            	    break loop27;
                }
            } while (true);

            match(input,K_APPLY,FOLLOW_K_APPLY_in_batchStatement1208); 
            match(input,K_BATCH,FOLLOW_K_BATCH_in_batchStatement1210); 

                      return new BatchStatement(statements, attrs);
                  

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "batchStatement"


    // $ANTLR start "batchStatementObjective"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:305:1: batchStatementObjective returns [ModificationStatement statement] : (i= insertStatement | u= updateStatement | d= deleteStatement );
    public final ModificationStatement batchStatementObjective() throws RecognitionException {
        ModificationStatement statement = null;

        UpdateStatement i = null;

        UpdateStatement u = null;

        DeleteStatement d = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:306:5: (i= insertStatement | u= updateStatement | d= deleteStatement )
            int alt28=3;
            switch ( input.LA(1) ) {
            case K_INSERT:
                {
                alt28=1;
                }
                break;
            case K_UPDATE:
                {
                alt28=2;
                }
                break;
            case K_DELETE:
                {
                alt28=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 28, 0, input);

                throw nvae;
            }

            switch (alt28) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:306:7: i= insertStatement
                    {
                    pushFollow(FOLLOW_insertStatement_in_batchStatementObjective1241);
                    i=insertStatement();

                    state._fsp--;

                     statement = i; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:307:7: u= updateStatement
                    {
                    pushFollow(FOLLOW_updateStatement_in_batchStatementObjective1254);
                    u=updateStatement();

                    state._fsp--;

                     statement = u; 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:308:7: d= deleteStatement
                    {
                    pushFollow(FOLLOW_deleteStatement_in_batchStatementObjective1267);
                    d=deleteStatement();

                    state._fsp--;

                     statement = d; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return statement;
    }
    // $ANTLR end "batchStatementObjective"


    // $ANTLR start "createKeyspaceStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:311:1: createKeyspaceStatement returns [CreateKeyspaceStatement expr] : K_CREATE K_KEYSPACE ks= keyspaceName K_WITH props= properties ;
    public final CreateKeyspaceStatement createKeyspaceStatement() throws RecognitionException {
        CreateKeyspaceStatement expr = null;

        String ks = null;

        Map<String, String> props = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:315:5: ( K_CREATE K_KEYSPACE ks= keyspaceName K_WITH props= properties )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:315:7: K_CREATE K_KEYSPACE ks= keyspaceName K_WITH props= properties
            {
            match(input,K_CREATE,FOLLOW_K_CREATE_in_createKeyspaceStatement1293); 
            match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_createKeyspaceStatement1295); 
            pushFollow(FOLLOW_keyspaceName_in_createKeyspaceStatement1299);
            ks=keyspaceName();

            state._fsp--;

            match(input,K_WITH,FOLLOW_K_WITH_in_createKeyspaceStatement1307); 
            pushFollow(FOLLOW_properties_in_createKeyspaceStatement1311);
            props=properties();

            state._fsp--;

             expr = new CreateKeyspaceStatement(ks, props); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "createKeyspaceStatement"


    // $ANTLR start "createColumnFamilyStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:319:1: createColumnFamilyStatement returns [CreateColumnFamilyStatement.RawStatement expr] : K_CREATE K_COLUMNFAMILY cf= columnFamilyName cfamDefinition[expr] ;
    public final CreateColumnFamilyStatement.RawStatement createColumnFamilyStatement() throws RecognitionException {
        CreateColumnFamilyStatement.RawStatement expr = null;

        CFName cf = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:327:5: ( K_CREATE K_COLUMNFAMILY cf= columnFamilyName cfamDefinition[expr] )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:327:7: K_CREATE K_COLUMNFAMILY cf= columnFamilyName cfamDefinition[expr]
            {
            match(input,K_CREATE,FOLLOW_K_CREATE_in_createColumnFamilyStatement1336); 
            match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_createColumnFamilyStatement1338); 
            pushFollow(FOLLOW_columnFamilyName_in_createColumnFamilyStatement1342);
            cf=columnFamilyName();

            state._fsp--;

             expr = new CreateColumnFamilyStatement.RawStatement(cf); 
            pushFollow(FOLLOW_cfamDefinition_in_createColumnFamilyStatement1352);
            cfamDefinition(expr);

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "createColumnFamilyStatement"


    // $ANTLR start "cfamDefinition"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:331:1: cfamDefinition[CreateColumnFamilyStatement.RawStatement expr] : '(' cfamColumns[expr] ( ',' ( cfamColumns[expr] )? )* ')' ( K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )* )? ;
    public final void cfamDefinition(CreateColumnFamilyStatement.RawStatement expr) throws RecognitionException {
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:332:5: ( '(' cfamColumns[expr] ( ',' ( cfamColumns[expr] )? )* ')' ( K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )* )? )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:332:7: '(' cfamColumns[expr] ( ',' ( cfamColumns[expr] )? )* ')' ( K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )* )?
            {
            match(input,85,FOLLOW_85_in_cfamDefinition1371); 
            pushFollow(FOLLOW_cfamColumns_in_cfamDefinition1373);
            cfamColumns(expr);

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:332:29: ( ',' ( cfamColumns[expr] )? )*
            loop30:
            do {
                int alt30=2;
                int LA30_0 = input.LA(1);

                if ( (LA30_0==88) ) {
                    alt30=1;
                }


                switch (alt30) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:332:31: ',' ( cfamColumns[expr] )?
            	    {
            	    match(input,88,FOLLOW_88_in_cfamDefinition1378); 
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:332:35: ( cfamColumns[expr] )?
            	    int alt29=2;
            	    int LA29_0 = input.LA(1);

            	    if ( (LA29_0==INTEGER||LA29_0==K_PRIMARY||LA29_0==IDENT||(LA29_0>=UUID && LA29_0<=QUOTED_NAME)) ) {
            	        alt29=1;
            	    }
            	    switch (alt29) {
            	        case 1 :
            	            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:332:35: cfamColumns[expr]
            	            {
            	            pushFollow(FOLLOW_cfamColumns_in_cfamDefinition1380);
            	            cfamColumns(expr);

            	            state._fsp--;


            	            }
            	            break;

            	    }


            	    }
            	    break;

            	default :
            	    break loop30;
                }
            } while (true);

            match(input,86,FOLLOW_86_in_cfamDefinition1387); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:333:7: ( K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )* )?
            int alt32=2;
            int LA32_0 = input.LA(1);

            if ( (LA32_0==K_WITH) ) {
                alt32=1;
            }
            switch (alt32) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:333:9: K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )*
                    {
                    match(input,K_WITH,FOLLOW_K_WITH_in_cfamDefinition1397); 
                    pushFollow(FOLLOW_cfamProperty_in_cfamDefinition1399);
                    cfamProperty(expr);

                    state._fsp--;

                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:333:35: ( K_AND cfamProperty[expr] )*
                    loop31:
                    do {
                        int alt31=2;
                        int LA31_0 = input.LA(1);

                        if ( (LA31_0==K_AND) ) {
                            alt31=1;
                        }


                        switch (alt31) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:333:37: K_AND cfamProperty[expr]
                    	    {
                    	    match(input,K_AND,FOLLOW_K_AND_in_cfamDefinition1404); 
                    	    pushFollow(FOLLOW_cfamProperty_in_cfamDefinition1406);
                    	    cfamProperty(expr);

                    	    state._fsp--;


                    	    }
                    	    break;

                    	default :
                    	    break loop31;
                        }
                    } while (true);


                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "cfamDefinition"


    // $ANTLR start "cfamColumns"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:336:1: cfamColumns[CreateColumnFamilyStatement.RawStatement expr] : (k= cident v= comparatorType ( K_PRIMARY K_KEY )? | K_PRIMARY K_KEY '(' k= cident ( ',' c= cident )* ')' );
    public final void cfamColumns(CreateColumnFamilyStatement.RawStatement expr) throws RecognitionException {
        ColumnIdentifier k = null;

        String v = null;

        ColumnIdentifier c = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:337:5: (k= cident v= comparatorType ( K_PRIMARY K_KEY )? | K_PRIMARY K_KEY '(' k= cident ( ',' c= cident )* ')' )
            int alt35=2;
            int LA35_0 = input.LA(1);

            if ( (LA35_0==INTEGER||LA35_0==IDENT||(LA35_0>=UUID && LA35_0<=QUOTED_NAME)) ) {
                alt35=1;
            }
            else if ( (LA35_0==K_PRIMARY) ) {
                alt35=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 35, 0, input);

                throw nvae;
            }
            switch (alt35) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:337:7: k= cident v= comparatorType ( K_PRIMARY K_KEY )?
                    {
                    pushFollow(FOLLOW_cident_in_cfamColumns1432);
                    k=cident();

                    state._fsp--;

                    pushFollow(FOLLOW_comparatorType_in_cfamColumns1436);
                    v=comparatorType();

                    state._fsp--;

                     expr.addDefinition(k, v); 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:337:64: ( K_PRIMARY K_KEY )?
                    int alt33=2;
                    int LA33_0 = input.LA(1);

                    if ( (LA33_0==K_PRIMARY) ) {
                        alt33=1;
                    }
                    switch (alt33) {
                        case 1 :
                            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:337:65: K_PRIMARY K_KEY
                            {
                            match(input,K_PRIMARY,FOLLOW_K_PRIMARY_in_cfamColumns1441); 
                            match(input,K_KEY,FOLLOW_K_KEY_in_cfamColumns1443); 
                             expr.setKeyAlias(k); 

                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:338:7: K_PRIMARY K_KEY '(' k= cident ( ',' c= cident )* ')'
                    {
                    match(input,K_PRIMARY,FOLLOW_K_PRIMARY_in_cfamColumns1455); 
                    match(input,K_KEY,FOLLOW_K_KEY_in_cfamColumns1457); 
                    match(input,85,FOLLOW_85_in_cfamColumns1459); 
                    pushFollow(FOLLOW_cident_in_cfamColumns1463);
                    k=cident();

                    state._fsp--;

                     expr.setKeyAlias(k); 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:338:62: ( ',' c= cident )*
                    loop34:
                    do {
                        int alt34=2;
                        int LA34_0 = input.LA(1);

                        if ( (LA34_0==88) ) {
                            alt34=1;
                        }


                        switch (alt34) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:338:63: ',' c= cident
                    	    {
                    	    match(input,88,FOLLOW_88_in_cfamColumns1468); 
                    	    pushFollow(FOLLOW_cident_in_cfamColumns1472);
                    	    c=cident();

                    	    state._fsp--;

                    	     expr.addColumnAlias(c); 

                    	    }
                    	    break;

                    	default :
                    	    break loop34;
                        }
                    } while (true);

                    match(input,86,FOLLOW_86_in_cfamColumns1479); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "cfamColumns"


    // $ANTLR start "cfamProperty"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:341:1: cfamProperty[CreateColumnFamilyStatement.RawStatement expr] : (k= property '=' v= propertyValue | K_COMPACT K_STORAGE );
    public final void cfamProperty(CreateColumnFamilyStatement.RawStatement expr) throws RecognitionException {
        String k = null;

        String v = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:342:5: (k= property '=' v= propertyValue | K_COMPACT K_STORAGE )
            int alt36=2;
            int LA36_0 = input.LA(1);

            if ( (LA36_0==IDENT||LA36_0==COMPIDENT) ) {
                alt36=1;
            }
            else if ( (LA36_0==K_COMPACT) ) {
                alt36=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 36, 0, input);

                throw nvae;
            }
            switch (alt36) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:342:7: k= property '=' v= propertyValue
                    {
                    pushFollow(FOLLOW_property_in_cfamProperty1499);
                    k=property();

                    state._fsp--;

                    match(input,89,FOLLOW_89_in_cfamProperty1501); 
                    pushFollow(FOLLOW_propertyValue_in_cfamProperty1505);
                    v=propertyValue();

                    state._fsp--;

                     expr.addProperty(k, v); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:343:7: K_COMPACT K_STORAGE
                    {
                    match(input,K_COMPACT,FOLLOW_K_COMPACT_in_cfamProperty1515); 
                    match(input,K_STORAGE,FOLLOW_K_STORAGE_in_cfamProperty1517); 
                     expr.setCompactStorage(); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "cfamProperty"


    // $ANTLR start "createIndexStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:346:1: createIndexStatement returns [CreateIndexStatement expr] : K_CREATE K_INDEX (idxName= IDENT )? K_ON cf= columnFamilyName '(' id= cident ')' ;
    public final CreateIndexStatement createIndexStatement() throws RecognitionException {
        CreateIndexStatement expr = null;

        Token idxName=null;
        CFName cf = null;

        ColumnIdentifier id = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:350:5: ( K_CREATE K_INDEX (idxName= IDENT )? K_ON cf= columnFamilyName '(' id= cident ')' )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:350:7: K_CREATE K_INDEX (idxName= IDENT )? K_ON cf= columnFamilyName '(' id= cident ')'
            {
            match(input,K_CREATE,FOLLOW_K_CREATE_in_createIndexStatement1542); 
            match(input,K_INDEX,FOLLOW_K_INDEX_in_createIndexStatement1544); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:350:24: (idxName= IDENT )?
            int alt37=2;
            int LA37_0 = input.LA(1);

            if ( (LA37_0==IDENT) ) {
                alt37=1;
            }
            switch (alt37) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:350:25: idxName= IDENT
                    {
                    idxName=(Token)match(input,IDENT,FOLLOW_IDENT_in_createIndexStatement1549); 

                    }
                    break;

            }

            match(input,K_ON,FOLLOW_K_ON_in_createIndexStatement1553); 
            pushFollow(FOLLOW_columnFamilyName_in_createIndexStatement1557);
            cf=columnFamilyName();

            state._fsp--;

            match(input,85,FOLLOW_85_in_createIndexStatement1559); 
            pushFollow(FOLLOW_cident_in_createIndexStatement1563);
            id=cident();

            state._fsp--;

            match(input,86,FOLLOW_86_in_createIndexStatement1565); 
             expr = new CreateIndexStatement(cf, (idxName!=null?idxName.getText():null), id); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "createIndexStatement"


    // $ANTLR start "alterTableStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:354:1: alterTableStatement returns [AlterTableStatement expr] : K_ALTER K_COLUMNFAMILY cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType | K_DROP id= cident | K_WITH props= properties ) ;
    public final AlterTableStatement alterTableStatement() throws RecognitionException {
        AlterTableStatement expr = null;

        CFName cf = null;

        ColumnIdentifier id = null;

        String v = null;

        Map<String, String> props = null;



                AlterTableStatement.Type type = null;
                String validator = null;
                ColumnIdentifier columnName = null;
                Map<String, String> propertyMap = null;
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:367:5: ( K_ALTER K_COLUMNFAMILY cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType | K_DROP id= cident | K_WITH props= properties ) )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:367:7: K_ALTER K_COLUMNFAMILY cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType | K_DROP id= cident | K_WITH props= properties )
            {
            match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTableStatement1605); 
            match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_alterTableStatement1607); 
            pushFollow(FOLLOW_columnFamilyName_in_alterTableStatement1611);
            cf=columnFamilyName();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:368:11: ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType | K_DROP id= cident | K_WITH props= properties )
            int alt38=4;
            switch ( input.LA(1) ) {
            case K_ALTER:
                {
                alt38=1;
                }
                break;
            case K_ADD:
                {
                alt38=2;
                }
                break;
            case K_DROP:
                {
                alt38=3;
                }
                break;
            case K_WITH:
                {
                alt38=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 38, 0, input);

                throw nvae;
            }

            switch (alt38) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:368:13: K_ALTER id= cident K_TYPE v= comparatorType
                    {
                    match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTableStatement1625); 
                    pushFollow(FOLLOW_cident_in_alterTableStatement1629);
                    id=cident();

                    state._fsp--;

                    match(input,K_TYPE,FOLLOW_K_TYPE_in_alterTableStatement1631); 
                    pushFollow(FOLLOW_comparatorType_in_alterTableStatement1635);
                    v=comparatorType();

                    state._fsp--;

                     type = AlterTableStatement.Type.ALTER; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:369:13: K_ADD id= cident v= comparatorType
                    {
                    match(input,K_ADD,FOLLOW_K_ADD_in_alterTableStatement1651); 
                    pushFollow(FOLLOW_cident_in_alterTableStatement1657);
                    id=cident();

                    state._fsp--;

                    pushFollow(FOLLOW_comparatorType_in_alterTableStatement1661);
                    v=comparatorType();

                    state._fsp--;

                     type = AlterTableStatement.Type.ADD; 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:370:13: K_DROP id= cident
                    {
                    match(input,K_DROP,FOLLOW_K_DROP_in_alterTableStatement1684); 
                    pushFollow(FOLLOW_cident_in_alterTableStatement1689);
                    id=cident();

                    state._fsp--;

                     type = AlterTableStatement.Type.DROP; 

                    }
                    break;
                case 4 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:371:13: K_WITH props= properties
                    {
                    match(input,K_WITH,FOLLOW_K_WITH_in_alterTableStatement1729); 
                    pushFollow(FOLLOW_properties_in_alterTableStatement1734);
                    props=properties();

                    state._fsp--;

                     type = AlterTableStatement.Type.OPTS; 

                    }
                    break;

            }


                    expr = new AlterTableStatement(cf, type, id, v, props);
                

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "alterTableStatement"


    // $ANTLR start "dropKeyspaceStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:378:1: dropKeyspaceStatement returns [DropKeyspaceStatement ksp] : K_DROP K_KEYSPACE ks= keyspaceName ;
    public final DropKeyspaceStatement dropKeyspaceStatement() throws RecognitionException {
        DropKeyspaceStatement ksp = null;

        String ks = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:382:5: ( K_DROP K_KEYSPACE ks= keyspaceName )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:382:7: K_DROP K_KEYSPACE ks= keyspaceName
            {
            match(input,K_DROP,FOLLOW_K_DROP_in_dropKeyspaceStatement1794); 
            match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_dropKeyspaceStatement1796); 
            pushFollow(FOLLOW_keyspaceName_in_dropKeyspaceStatement1800);
            ks=keyspaceName();

            state._fsp--;

             ksp = new DropKeyspaceStatement(ks); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ksp;
    }
    // $ANTLR end "dropKeyspaceStatement"


    // $ANTLR start "dropColumnFamilyStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:385:1: dropColumnFamilyStatement returns [DropColumnFamilyStatement stmt] : K_DROP K_COLUMNFAMILY cf= columnFamilyName ;
    public final DropColumnFamilyStatement dropColumnFamilyStatement() throws RecognitionException {
        DropColumnFamilyStatement stmt = null;

        CFName cf = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:389:5: ( K_DROP K_COLUMNFAMILY cf= columnFamilyName )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:389:7: K_DROP K_COLUMNFAMILY cf= columnFamilyName
            {
            match(input,K_DROP,FOLLOW_K_DROP_in_dropColumnFamilyStatement1825); 
            match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_dropColumnFamilyStatement1827); 
            pushFollow(FOLLOW_columnFamilyName_in_dropColumnFamilyStatement1831);
            cf=columnFamilyName();

            state._fsp--;

             stmt = new DropColumnFamilyStatement(cf); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "dropColumnFamilyStatement"


    // $ANTLR start "dropIndexStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:392:1: dropIndexStatement returns [DropIndexStatement expr] : K_DROP K_INDEX index= IDENT ;
    public final DropIndexStatement dropIndexStatement() throws RecognitionException {
        DropIndexStatement expr = null;

        Token index=null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:396:5: ( K_DROP K_INDEX index= IDENT )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:397:7: K_DROP K_INDEX index= IDENT
            {
            match(input,K_DROP,FOLLOW_K_DROP_in_dropIndexStatement1862); 
            match(input,K_INDEX,FOLLOW_K_INDEX_in_dropIndexStatement1864); 
            index=(Token)match(input,IDENT,FOLLOW_IDENT_in_dropIndexStatement1868); 
             expr = new DropIndexStatement((index!=null?index.getText():null)); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "dropIndexStatement"


    // $ANTLR start "truncateStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:401:1: truncateStatement returns [TruncateStatement stmt] : K_TRUNCATE cf= columnFamilyName ;
    public final TruncateStatement truncateStatement() throws RecognitionException {
        TruncateStatement stmt = null;

        CFName cf = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:405:5: ( K_TRUNCATE cf= columnFamilyName )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:405:7: K_TRUNCATE cf= columnFamilyName
            {
            match(input,K_TRUNCATE,FOLLOW_K_TRUNCATE_in_truncateStatement1899); 
            pushFollow(FOLLOW_columnFamilyName_in_truncateStatement1903);
            cf=columnFamilyName();

            state._fsp--;

             stmt = new TruncateStatement(cf); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "truncateStatement"


    // $ANTLR start "cident"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:409:1: cident returns [ColumnIdentifier id] : (t= ( IDENT | UUID | INTEGER ) | t= QUOTED_NAME );
    public final ColumnIdentifier cident() throws RecognitionException {
        ColumnIdentifier id = null;

        Token t=null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:413:5: (t= ( IDENT | UUID | INTEGER ) | t= QUOTED_NAME )
            int alt39=2;
            int LA39_0 = input.LA(1);

            if ( (LA39_0==INTEGER||LA39_0==IDENT||LA39_0==UUID) ) {
                alt39=1;
            }
            else if ( (LA39_0==QUOTED_NAME) ) {
                alt39=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 39, 0, input);

                throw nvae;
            }
            switch (alt39) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:413:7: t= ( IDENT | UUID | INTEGER )
                    {
                    t=(Token)input.LT(1);
                    if ( input.LA(1)==INTEGER||input.LA(1)==IDENT||input.LA(1)==UUID ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                     id = new ColumnIdentifier((t!=null?t.getText():null), false); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:414:7: t= QUOTED_NAME
                    {
                    t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_cident1957); 
                     id = new ColumnIdentifier((t!=null?t.getText():null), true); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return id;
    }
    // $ANTLR end "cident"


    // $ANTLR start "keyspaceName"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:418:1: keyspaceName returns [String id] : cfOrKsName[name, true] ;
    public final String keyspaceName() throws RecognitionException {
        String id = null;

         CFName name = new CFName(); 
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:420:5: ( cfOrKsName[name, true] )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:420:7: cfOrKsName[name, true]
            {
            pushFollow(FOLLOW_cfOrKsName_in_keyspaceName2005);
            cfOrKsName(name, true);

            state._fsp--;

             id = name.getKeyspace(); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return id;
    }
    // $ANTLR end "keyspaceName"


    // $ANTLR start "columnFamilyName"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:423:1: columnFamilyName returns [CFName name] : ( cfOrKsName[name, true] '.' )? cfOrKsName[name, false] ;
    public final CFName columnFamilyName() throws RecognitionException {
        CFName name = null;

         name = new CFName(); 
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:425:5: ( ( cfOrKsName[name, true] '.' )? cfOrKsName[name, false] )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:425:7: ( cfOrKsName[name, true] '.' )? cfOrKsName[name, false]
            {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:425:7: ( cfOrKsName[name, true] '.' )?
            int alt40=2;
            int LA40_0 = input.LA(1);

            if ( (LA40_0==IDENT) ) {
                int LA40_1 = input.LA(2);

                if ( (LA40_1==90) ) {
                    alt40=1;
                }
            }
            else if ( (LA40_0==QUOTED_NAME) ) {
                int LA40_2 = input.LA(2);

                if ( (LA40_2==90) ) {
                    alt40=1;
                }
            }
            switch (alt40) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:425:8: cfOrKsName[name, true] '.'
                    {
                    pushFollow(FOLLOW_cfOrKsName_in_columnFamilyName2039);
                    cfOrKsName(name, true);

                    state._fsp--;

                    match(input,90,FOLLOW_90_in_columnFamilyName2042); 

                    }
                    break;

            }

            pushFollow(FOLLOW_cfOrKsName_in_columnFamilyName2046);
            cfOrKsName(name, false);

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return name;
    }
    // $ANTLR end "columnFamilyName"


    // $ANTLR start "cfOrKsName"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:428:1: cfOrKsName[CFName name, boolean isKs] : (t= IDENT | t= QUOTED_NAME );
    public final void cfOrKsName(CFName name, boolean isKs) throws RecognitionException {
        Token t=null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:429:5: (t= IDENT | t= QUOTED_NAME )
            int alt41=2;
            int LA41_0 = input.LA(1);

            if ( (LA41_0==IDENT) ) {
                alt41=1;
            }
            else if ( (LA41_0==QUOTED_NAME) ) {
                alt41=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 41, 0, input);

                throw nvae;
            }
            switch (alt41) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:429:7: t= IDENT
                    {
                    t=(Token)match(input,IDENT,FOLLOW_IDENT_in_cfOrKsName2067); 
                     if (isKs) name.setKeyspace((t!=null?t.getText():null), false); else name.setColumnFamily((t!=null?t.getText():null), false); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:430:7: t= QUOTED_NAME
                    {
                    t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_cfOrKsName2086); 
                     if (isKs) name.setKeyspace((t!=null?t.getText():null), true); else name.setColumnFamily((t!=null?t.getText():null), true); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "cfOrKsName"


    // $ANTLR start "cidentList"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:433:1: cidentList returns [List<ColumnIdentifier> items] : t1= cident ( ',' tN= cident )* ;
    public final List<ColumnIdentifier> cidentList() throws RecognitionException {
        List<ColumnIdentifier> items = null;

        ColumnIdentifier t1 = null;

        ColumnIdentifier tN = null;


         items = new ArrayList<ColumnIdentifier>(); 
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:435:5: (t1= cident ( ',' tN= cident )* )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:435:8: t1= cident ( ',' tN= cident )*
            {
            pushFollow(FOLLOW_cident_in_cidentList2121);
            t1=cident();

            state._fsp--;

             items.add(t1); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:435:38: ( ',' tN= cident )*
            loop42:
            do {
                int alt42=2;
                int LA42_0 = input.LA(1);

                if ( (LA42_0==88) ) {
                    alt42=1;
                }


                switch (alt42) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:435:39: ',' tN= cident
            	    {
            	    match(input,88,FOLLOW_88_in_cidentList2126); 
            	    pushFollow(FOLLOW_cident_in_cidentList2130);
            	    tN=cident();

            	    state._fsp--;

            	     items.add(tN); 

            	    }
            	    break;

            	default :
            	    break loop42;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return items;
    }
    // $ANTLR end "cidentList"


    // $ANTLR start "term"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:439:1: term returns [Term term] : (t= ( STRING_LITERAL | UUID | IDENT | INTEGER | FLOAT ) | t= QMARK );
    public final Term term() throws RecognitionException {
        Term term = null;

        Token t=null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:440:5: (t= ( STRING_LITERAL | UUID | IDENT | INTEGER | FLOAT ) | t= QMARK )
            int alt43=2;
            int LA43_0 = input.LA(1);

            if ( (LA43_0==INTEGER||LA43_0==IDENT||LA43_0==UUID||(LA43_0>=STRING_LITERAL && LA43_0<=FLOAT)) ) {
                alt43=1;
            }
            else if ( (LA43_0==QMARK) ) {
                alt43=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 43, 0, input);

                throw nvae;
            }
            switch (alt43) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:440:7: t= ( STRING_LITERAL | UUID | IDENT | INTEGER | FLOAT )
                    {
                    t=(Token)input.LT(1);
                    if ( input.LA(1)==INTEGER||input.LA(1)==IDENT||input.LA(1)==UUID||(input.LA(1)>=STRING_LITERAL && input.LA(1)<=FLOAT) ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                     term = new Term((t!=null?t.getText():null), (t!=null?t.getType():0)); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:441:7: t= QMARK
                    {
                    t=(Token)match(input,QMARK,FOLLOW_QMARK_in_term2189); 
                     term = new Term((t!=null?t.getText():null), (t!=null?t.getType():0), ++currentBindMarkerIdx); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return term;
    }
    // $ANTLR end "term"


    // $ANTLR start "intTerm"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:444:1: intTerm returns [Term integer] : (t= INTEGER | t= QMARK );
    public final Term intTerm() throws RecognitionException {
        Term integer = null;

        Token t=null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:445:5: (t= INTEGER | t= QMARK )
            int alt44=2;
            int LA44_0 = input.LA(1);

            if ( (LA44_0==INTEGER) ) {
                alt44=1;
            }
            else if ( (LA44_0==QMARK) ) {
                alt44=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 44, 0, input);

                throw nvae;
            }
            switch (alt44) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:445:7: t= INTEGER
                    {
                    t=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_intTerm2259); 
                     integer = new Term((t!=null?t.getText():null), (t!=null?t.getType():0)); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:446:7: t= QMARK
                    {
                    t=(Token)match(input,QMARK,FOLLOW_QMARK_in_intTerm2271); 
                     integer = new Term((t!=null?t.getText():null), (t!=null?t.getType():0), ++currentBindMarkerIdx); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return integer;
    }
    // $ANTLR end "intTerm"


    // $ANTLR start "termPairWithOperation"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:449:1: termPairWithOperation[Map<ColumnIdentifier, Operation> columns] : key= cident '=' (value= term | c= cident ( '+' v= intTerm | (op= '-' )? v= intTerm ) ) ;
    public final void termPairWithOperation(Map<ColumnIdentifier, Operation> columns) throws RecognitionException {
        Token op=null;
        ColumnIdentifier key = null;

        Term value = null;

        ColumnIdentifier c = null;

        Term v = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:450:5: (key= cident '=' (value= term | c= cident ( '+' v= intTerm | (op= '-' )? v= intTerm ) ) )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:450:7: key= cident '=' (value= term | c= cident ( '+' v= intTerm | (op= '-' )? v= intTerm ) )
            {
            pushFollow(FOLLOW_cident_in_termPairWithOperation2295);
            key=cident();

            state._fsp--;

            match(input,89,FOLLOW_89_in_termPairWithOperation2297); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:451:9: (value= term | c= cident ( '+' v= intTerm | (op= '-' )? v= intTerm ) )
            int alt47=2;
            switch ( input.LA(1) ) {
            case INTEGER:
            case IDENT:
            case UUID:
                {
                int LA47_1 = input.LA(2);

                if ( (LA47_1==INTEGER||LA47_1==QMARK||(LA47_1>=91 && LA47_1<=92)) ) {
                    alt47=2;
                }
                else if ( (LA47_1==K_WHERE||LA47_1==88) ) {
                    alt47=1;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 47, 1, input);

                    throw nvae;
                }
                }
                break;
            case STRING_LITERAL:
            case FLOAT:
            case QMARK:
                {
                alt47=1;
                }
                break;
            case QUOTED_NAME:
                {
                alt47=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 47, 0, input);

                throw nvae;
            }

            switch (alt47) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:451:11: value= term
                    {
                    pushFollow(FOLLOW_term_in_termPairWithOperation2311);
                    value=term();

                    state._fsp--;

                     columns.put(key, new Operation(value)); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:452:11: c= cident ( '+' v= intTerm | (op= '-' )? v= intTerm )
                    {
                    pushFollow(FOLLOW_cident_in_termPairWithOperation2327);
                    c=cident();

                    state._fsp--;

                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:452:20: ( '+' v= intTerm | (op= '-' )? v= intTerm )
                    int alt46=2;
                    int LA46_0 = input.LA(1);

                    if ( (LA46_0==91) ) {
                        alt46=1;
                    }
                    else if ( (LA46_0==INTEGER||LA46_0==QMARK||LA46_0==92) ) {
                        alt46=2;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("", 46, 0, input);

                        throw nvae;
                    }
                    switch (alt46) {
                        case 1 :
                            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:452:22: '+' v= intTerm
                            {
                            match(input,91,FOLLOW_91_in_termPairWithOperation2331); 
                            pushFollow(FOLLOW_intTerm_in_termPairWithOperation2339);
                            v=intTerm();

                            state._fsp--;

                             columns.put(key, new Operation(c, Operation.Type.PLUS, v)); 

                            }
                            break;
                        case 2 :
                            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:453:22: (op= '-' )? v= intTerm
                            {
                            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:453:24: (op= '-' )?
                            int alt45=2;
                            int LA45_0 = input.LA(1);

                            if ( (LA45_0==92) ) {
                                alt45=1;
                            }
                            switch (alt45) {
                                case 1 :
                                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:453:24: op= '-'
                                    {
                                    op=(Token)match(input,92,FOLLOW_92_in_termPairWithOperation2366); 

                                    }
                                    break;

                            }

                            pushFollow(FOLLOW_intTerm_in_termPairWithOperation2371);
                            v=intTerm();

                            state._fsp--;


                                                   validateMinusSupplied(op, v, input);
                                                   if (op == null)
                                                       v = new Term(-(Long.valueOf(v.getText())), v.getType());
                                                   columns.put(key, new Operation(c, Operation.Type.MINUS, v));
                                                 

                            }
                            break;

                    }


                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "termPairWithOperation"


    // $ANTLR start "property"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:464:1: property returns [String str] : p= ( COMPIDENT | IDENT ) ;
    public final String property() throws RecognitionException {
        String str = null;

        Token p=null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:465:5: (p= ( COMPIDENT | IDENT ) )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:465:7: p= ( COMPIDENT | IDENT )
            {
            p=(Token)input.LT(1);
            if ( input.LA(1)==IDENT||input.LA(1)==COMPIDENT ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

             str = (p!=null?p.getText():null); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return str;
    }
    // $ANTLR end "property"


    // $ANTLR start "propertyValue"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:468:1: propertyValue returns [String str] : v= ( STRING_LITERAL | IDENT | INTEGER | FLOAT ) ;
    public final String propertyValue() throws RecognitionException {
        String str = null;

        Token v=null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:469:5: (v= ( STRING_LITERAL | IDENT | INTEGER | FLOAT ) )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:469:7: v= ( STRING_LITERAL | IDENT | INTEGER | FLOAT )
            {
            v=(Token)input.LT(1);
            if ( input.LA(1)==INTEGER||input.LA(1)==IDENT||(input.LA(1)>=STRING_LITERAL && input.LA(1)<=FLOAT) ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

             str = (v!=null?v.getText():null); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return str;
    }
    // $ANTLR end "propertyValue"


    // $ANTLR start "properties"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:472:1: properties returns [Map<String, String> props] : k1= property '=' v1= propertyValue ( K_AND kn= property '=' vn= propertyValue )* ;
    public final Map<String, String> properties() throws RecognitionException {
        Map<String, String> props = null;

        String k1 = null;

        String v1 = null;

        String kn = null;

        String vn = null;


         props = new HashMap<String, String>(); 
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:474:5: (k1= property '=' v1= propertyValue ( K_AND kn= property '=' vn= propertyValue )* )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:474:7: k1= property '=' v1= propertyValue ( K_AND kn= property '=' vn= propertyValue )*
            {
            pushFollow(FOLLOW_property_in_properties2527);
            k1=property();

            state._fsp--;

            match(input,89,FOLLOW_89_in_properties2529); 
            pushFollow(FOLLOW_propertyValue_in_properties2533);
            v1=propertyValue();

            state._fsp--;

             props.put(k1, v1); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:474:64: ( K_AND kn= property '=' vn= propertyValue )*
            loop48:
            do {
                int alt48=2;
                int LA48_0 = input.LA(1);

                if ( (LA48_0==K_AND) ) {
                    alt48=1;
                }


                switch (alt48) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:474:65: K_AND kn= property '=' vn= propertyValue
            	    {
            	    match(input,K_AND,FOLLOW_K_AND_in_properties2538); 
            	    pushFollow(FOLLOW_property_in_properties2542);
            	    kn=property();

            	    state._fsp--;

            	    match(input,89,FOLLOW_89_in_properties2544); 
            	    pushFollow(FOLLOW_propertyValue_in_properties2548);
            	    vn=propertyValue();

            	    state._fsp--;

            	     props.put(kn, vn); 

            	    }
            	    break;

            	default :
            	    break loop48;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return props;
    }
    // $ANTLR end "properties"


    // $ANTLR start "relation"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:477:1: relation returns [Relation rel] : (name= cident type= ( '=' | '<' | '<=' | '>=' | '>' ) t= term | name= cident K_IN '(' f1= term ( ',' fN= term )* ')' );
    public final Relation relation() throws RecognitionException {
        Relation rel = null;

        Token type=null;
        ColumnIdentifier name = null;

        Term t = null;

        Term f1 = null;

        Term fN = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:478:5: (name= cident type= ( '=' | '<' | '<=' | '>=' | '>' ) t= term | name= cident K_IN '(' f1= term ( ',' fN= term )* ')' )
            int alt50=2;
            int LA50_0 = input.LA(1);

            if ( (LA50_0==INTEGER||LA50_0==IDENT||LA50_0==UUID) ) {
                int LA50_1 = input.LA(2);

                if ( (LA50_1==K_IN) ) {
                    alt50=2;
                }
                else if ( (LA50_1==89||(LA50_1>=93 && LA50_1<=96)) ) {
                    alt50=1;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 50, 1, input);

                    throw nvae;
                }
            }
            else if ( (LA50_0==QUOTED_NAME) ) {
                int LA50_2 = input.LA(2);

                if ( (LA50_2==K_IN) ) {
                    alt50=2;
                }
                else if ( (LA50_2==89||(LA50_2>=93 && LA50_2<=96)) ) {
                    alt50=1;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 50, 2, input);

                    throw nvae;
                }
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 50, 0, input);

                throw nvae;
            }
            switch (alt50) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:478:7: name= cident type= ( '=' | '<' | '<=' | '>=' | '>' ) t= term
                    {
                    pushFollow(FOLLOW_cident_in_relation2576);
                    name=cident();

                    state._fsp--;

                    type=(Token)input.LT(1);
                    if ( input.LA(1)==89||(input.LA(1)>=93 && input.LA(1)<=96) ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                    pushFollow(FOLLOW_term_in_relation2602);
                    t=term();

                    state._fsp--;

                     rel = new Relation(name, (type!=null?type.getText():null), t); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:479:7: name= cident K_IN '(' f1= term ( ',' fN= term )* ')'
                    {
                    pushFollow(FOLLOW_cident_in_relation2614);
                    name=cident();

                    state._fsp--;

                    match(input,K_IN,FOLLOW_K_IN_in_relation2616); 
                     rel = Relation.createInRelation(name); 
                    match(input,85,FOLLOW_85_in_relation2626); 
                    pushFollow(FOLLOW_term_in_relation2630);
                    f1=term();

                    state._fsp--;

                     rel.addInValue(f1); 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:480:44: ( ',' fN= term )*
                    loop49:
                    do {
                        int alt49=2;
                        int LA49_0 = input.LA(1);

                        if ( (LA49_0==88) ) {
                            alt49=1;
                        }


                        switch (alt49) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:480:45: ',' fN= term
                    	    {
                    	    match(input,88,FOLLOW_88_in_relation2635); 
                    	    pushFollow(FOLLOW_term_in_relation2639);
                    	    fN=term();

                    	    state._fsp--;

                    	     rel.addInValue(fN); 

                    	    }
                    	    break;

                    	default :
                    	    break loop49;
                        }
                    } while (true);

                    match(input,86,FOLLOW_86_in_relation2646); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return rel;
    }
    // $ANTLR end "relation"


    // $ANTLR start "comparatorType"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:483:1: comparatorType returns [String str] : c= ( IDENT | STRING_LITERAL | K_TIMESTAMP ) ;
    public final String comparatorType() throws RecognitionException {
        String str = null;

        Token c=null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:484:5: (c= ( IDENT | STRING_LITERAL | K_TIMESTAMP ) )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:484:7: c= ( IDENT | STRING_LITERAL | K_TIMESTAMP )
            {
            c=(Token)input.LT(1);
            if ( input.LA(1)==K_TIMESTAMP||input.LA(1)==IDENT||input.LA(1)==STRING_LITERAL ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

             str = (c!=null?c.getText():null); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return str;
    }
    // $ANTLR end "comparatorType"

    // Delegated rules


    protected DFA2 dfa2 = new DFA2(this);
    static final String DFA2_eotS =
        "\21\uffff";
    static final String DFA2_eofS =
        "\21\uffff";
    static final String DFA2_minS =
        "\1\4\7\uffff\2\36\7\uffff";
    static final String DFA2_maxS =
        "\1\54\7\uffff\2\45\7\uffff";
    static final String DFA2_acceptS =
        "\1\uffff\1\1\1\2\1\3\1\4\1\5\1\6\1\7\2\uffff\1\16\1\10\1\11\1\12"+
        "\1\13\1\14\1\15";
    static final String DFA2_specialS =
        "\21\uffff}>";
    static final String[] DFA2_transitionS = {
            "\1\6\1\1\14\uffff\1\2\4\uffff\1\3\1\uffff\1\5\1\4\2\uffff\1"+
            "\10\12\uffff\1\12\2\uffff\1\11\1\7",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\13\1\uffff\1\14\4\uffff\1\15",
            "\1\16\1\uffff\1\17\4\uffff\1\20",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA2_eot = DFA.unpackEncodedString(DFA2_eotS);
    static final short[] DFA2_eof = DFA.unpackEncodedString(DFA2_eofS);
    static final char[] DFA2_min = DFA.unpackEncodedStringToUnsignedChars(DFA2_minS);
    static final char[] DFA2_max = DFA.unpackEncodedStringToUnsignedChars(DFA2_maxS);
    static final short[] DFA2_accept = DFA.unpackEncodedString(DFA2_acceptS);
    static final short[] DFA2_special = DFA.unpackEncodedString(DFA2_specialS);
    static final short[][] DFA2_transition;

    static {
        int numStates = DFA2_transitionS.length;
        DFA2_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA2_transition[i] = DFA.unpackEncodedString(DFA2_transitionS[i]);
        }
    }

    class DFA2 extends DFA {

        public DFA2(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 2;
            this.eot = DFA2_eot;
            this.eof = DFA2_eof;
            this.min = DFA2_min;
            this.max = DFA2_max;
            this.accept = DFA2_accept;
            this.special = DFA2_special;
            this.transition = DFA2_transition;
        }
        public String getDescription() {
            return "122:1: cqlStatement returns [ParsedStatement stmt] : (st1= selectStatement | st2= insertStatement | st3= updateStatement | st4= batchStatement | st5= deleteStatement | st6= useStatement | st7= truncateStatement | st8= createKeyspaceStatement | st9= createColumnFamilyStatement | st10= createIndexStatement | st11= dropKeyspaceStatement | st12= dropColumnFamilyStatement | st13= dropIndexStatement | st14= alterTableStatement );";
        }
    }
 

    public static final BitSet FOLLOW_cqlStatement_in_query72 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
    public static final BitSet FOLLOW_84_in_query75 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
    public static final BitSet FOLLOW_EOF_in_query79 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_selectStatement_in_cqlStatement113 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_insertStatement_in_cqlStatement138 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_updateStatement_in_cqlStatement163 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_batchStatement_in_cqlStatement188 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_deleteStatement_in_cqlStatement214 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_useStatement_in_cqlStatement239 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_truncateStatement_in_cqlStatement267 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_createKeyspaceStatement_in_cqlStatement290 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_createColumnFamilyStatement_in_cqlStatement307 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_createIndexStatement_in_cqlStatement319 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dropKeyspaceStatement_in_cqlStatement338 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dropColumnFamilyStatement_in_cqlStatement356 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dropIndexStatement_in_cqlStatement370 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_alterTableStatement_in_cqlStatement391 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_USE_in_useStatement424 = new BitSet(new long[]{0x0000404000000000L});
    public static final BitSet FOLLOW_keyspaceName_in_useStatement428 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_SELECT_in_selectStatement462 = new BitSet(new long[]{0x0000604000010040L,0x0000000000800000L});
    public static final BitSet FOLLOW_selectClause_in_selectStatement468 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_K_COUNT_in_selectStatement473 = new BitSet(new long[]{0x0000000000000000L,0x0000000000200000L});
    public static final BitSet FOLLOW_85_in_selectStatement475 = new BitSet(new long[]{0x0000604000010000L,0x0000000000800000L});
    public static final BitSet FOLLOW_selectClause_in_selectStatement479 = new BitSet(new long[]{0x0000000000000000L,0x0000000000400000L});
    public static final BitSet FOLLOW_86_in_selectStatement481 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_K_FROM_in_selectStatement494 = new BitSet(new long[]{0x0000404000000000L});
    public static final BitSet FOLLOW_columnFamilyName_in_selectStatement498 = new BitSet(new long[]{0x0000000000009902L});
    public static final BitSet FOLLOW_K_USING_in_selectStatement508 = new BitSet(new long[]{0x0000000000000200L});
    public static final BitSet FOLLOW_K_CONSISTENCY_in_selectStatement510 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_K_LEVEL_in_selectStatement512 = new BitSet(new long[]{0x0000000000009802L});
    public static final BitSet FOLLOW_K_WHERE_in_selectStatement527 = new BitSet(new long[]{0x0000604000010000L});
    public static final BitSet FOLLOW_whereClause_in_selectStatement531 = new BitSet(new long[]{0x0000000000009002L});
    public static final BitSet FOLLOW_K_ORDER_in_selectStatement544 = new BitSet(new long[]{0x0000000000006000L});
    public static final BitSet FOLLOW_K_ASC_in_selectStatement547 = new BitSet(new long[]{0x0000000000008002L});
    public static final BitSet FOLLOW_K_DESC_in_selectStatement551 = new BitSet(new long[]{0x0000000000008002L});
    public static final BitSet FOLLOW_K_LIMIT_in_selectStatement567 = new BitSet(new long[]{0x0000000000010000L});
    public static final BitSet FOLLOW_INTEGER_in_selectStatement571 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cidentList_in_selectClause607 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_87_in_selectClause617 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_relation_in_whereClause660 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_K_AND_in_whereClause665 = new BitSet(new long[]{0x0000604000010000L});
    public static final BitSet FOLLOW_relation_in_whereClause669 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_K_INSERT_in_insertStatement705 = new BitSet(new long[]{0x0000000000080000L});
    public static final BitSet FOLLOW_K_INTO_in_insertStatement707 = new BitSet(new long[]{0x0000404000000000L});
    public static final BitSet FOLLOW_columnFamilyName_in_insertStatement711 = new BitSet(new long[]{0x0000000000000000L,0x0000000000200000L});
    public static final BitSet FOLLOW_85_in_insertStatement723 = new BitSet(new long[]{0x0000604000010000L});
    public static final BitSet FOLLOW_cident_in_insertStatement727 = new BitSet(new long[]{0x0000000000000000L,0x0000000001000000L});
    public static final BitSet FOLLOW_88_in_insertStatement734 = new BitSet(new long[]{0x0000604000010000L});
    public static final BitSet FOLLOW_cident_in_insertStatement738 = new BitSet(new long[]{0x0000000000000000L,0x0000000001400000L});
    public static final BitSet FOLLOW_86_in_insertStatement745 = new BitSet(new long[]{0x0000000000100000L});
    public static final BitSet FOLLOW_K_VALUES_in_insertStatement755 = new BitSet(new long[]{0x0000000000000000L,0x0000000000200000L});
    public static final BitSet FOLLOW_85_in_insertStatement767 = new BitSet(new long[]{0x0003A04000010000L});
    public static final BitSet FOLLOW_term_in_insertStatement771 = new BitSet(new long[]{0x0000000000000000L,0x0000000001000000L});
    public static final BitSet FOLLOW_88_in_insertStatement777 = new BitSet(new long[]{0x0003A04000010000L});
    public static final BitSet FOLLOW_term_in_insertStatement781 = new BitSet(new long[]{0x0000000000000000L,0x0000000001400000L});
    public static final BitSet FOLLOW_86_in_insertStatement788 = new BitSet(new long[]{0x0000000000000102L});
    public static final BitSet FOLLOW_usingClause_in_insertStatement800 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_USING_in_usingClause830 = new BitSet(new long[]{0x0000000000600200L});
    public static final BitSet FOLLOW_usingClauseObjective_in_usingClause832 = new BitSet(new long[]{0x0000000000620202L});
    public static final BitSet FOLLOW_K_AND_in_usingClause837 = new BitSet(new long[]{0x0000000000600200L});
    public static final BitSet FOLLOW_usingClauseObjective_in_usingClause840 = new BitSet(new long[]{0x0000000000620202L});
    public static final BitSet FOLLOW_K_USING_in_usingClauseDelete862 = new BitSet(new long[]{0x0000000000200200L});
    public static final BitSet FOLLOW_usingClauseDeleteObjective_in_usingClauseDelete864 = new BitSet(new long[]{0x0000000000220202L});
    public static final BitSet FOLLOW_K_AND_in_usingClauseDelete869 = new BitSet(new long[]{0x0000000000200200L});
    public static final BitSet FOLLOW_usingClauseDeleteObjective_in_usingClauseDelete872 = new BitSet(new long[]{0x0000000000220202L});
    public static final BitSet FOLLOW_K_CONSISTENCY_in_usingClauseDeleteObjective894 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_K_LEVEL_in_usingClauseDeleteObjective896 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TIMESTAMP_in_usingClauseDeleteObjective907 = new BitSet(new long[]{0x0000000000010000L});
    public static final BitSet FOLLOW_INTEGER_in_usingClauseDeleteObjective911 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_usingClauseDeleteObjective_in_usingClauseObjective931 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TTL_in_usingClauseObjective940 = new BitSet(new long[]{0x0000000000010000L});
    public static final BitSet FOLLOW_INTEGER_in_usingClauseObjective944 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_UPDATE_in_updateStatement978 = new BitSet(new long[]{0x0000404000000000L});
    public static final BitSet FOLLOW_columnFamilyName_in_updateStatement982 = new BitSet(new long[]{0x0000000001000100L});
    public static final BitSet FOLLOW_usingClause_in_updateStatement992 = new BitSet(new long[]{0x0000000001000000L});
    public static final BitSet FOLLOW_K_SET_in_updateStatement1004 = new BitSet(new long[]{0x0000604000010000L});
    public static final BitSet FOLLOW_termPairWithOperation_in_updateStatement1006 = new BitSet(new long[]{0x0000000000000800L,0x0000000001000000L});
    public static final BitSet FOLLOW_88_in_updateStatement1010 = new BitSet(new long[]{0x0000604000010000L});
    public static final BitSet FOLLOW_termPairWithOperation_in_updateStatement1012 = new BitSet(new long[]{0x0000000000000800L,0x0000000001000000L});
    public static final BitSet FOLLOW_K_WHERE_in_updateStatement1023 = new BitSet(new long[]{0x0000604000010000L});
    public static final BitSet FOLLOW_whereClause_in_updateStatement1027 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DELETE_in_deleteStatement1067 = new BitSet(new long[]{0x0000604000010080L});
    public static final BitSet FOLLOW_cidentList_in_deleteStatement1073 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_K_FROM_in_deleteStatement1086 = new BitSet(new long[]{0x0000404000000000L});
    public static final BitSet FOLLOW_columnFamilyName_in_deleteStatement1090 = new BitSet(new long[]{0x0000000000000900L});
    public static final BitSet FOLLOW_usingClauseDelete_in_deleteStatement1100 = new BitSet(new long[]{0x0000000000000800L});
    public static final BitSet FOLLOW_K_WHERE_in_deleteStatement1112 = new BitSet(new long[]{0x0000604000010000L});
    public static final BitSet FOLLOW_whereClause_in_deleteStatement1116 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_BEGIN_in_batchStatement1157 = new BitSet(new long[]{0x0000000008000000L});
    public static final BitSet FOLLOW_K_BATCH_in_batchStatement1159 = new BitSet(new long[]{0x0000000002840100L});
    public static final BitSet FOLLOW_usingClause_in_batchStatement1163 = new BitSet(new long[]{0x0000000002840100L});
    public static final BitSet FOLLOW_batchStatementObjective_in_batchStatement1181 = new BitSet(new long[]{0x0000000012840100L,0x0000000000100000L});
    public static final BitSet FOLLOW_84_in_batchStatement1183 = new BitSet(new long[]{0x0000000012840100L});
    public static final BitSet FOLLOW_batchStatementObjective_in_batchStatement1192 = new BitSet(new long[]{0x0000000012840100L,0x0000000000100000L});
    public static final BitSet FOLLOW_84_in_batchStatement1194 = new BitSet(new long[]{0x0000000012840100L});
    public static final BitSet FOLLOW_K_APPLY_in_batchStatement1208 = new BitSet(new long[]{0x0000000008000000L});
    public static final BitSet FOLLOW_K_BATCH_in_batchStatement1210 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_insertStatement_in_batchStatementObjective1241 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_updateStatement_in_batchStatementObjective1254 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_deleteStatement_in_batchStatementObjective1267 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_CREATE_in_createKeyspaceStatement1293 = new BitSet(new long[]{0x0000000040000000L});
    public static final BitSet FOLLOW_K_KEYSPACE_in_createKeyspaceStatement1295 = new BitSet(new long[]{0x0000404000000000L});
    public static final BitSet FOLLOW_keyspaceName_in_createKeyspaceStatement1299 = new BitSet(new long[]{0x0000000080000000L});
    public static final BitSet FOLLOW_K_WITH_in_createKeyspaceStatement1307 = new BitSet(new long[]{0x0004004000000000L});
    public static final BitSet FOLLOW_properties_in_createKeyspaceStatement1311 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_CREATE_in_createColumnFamilyStatement1336 = new BitSet(new long[]{0x0000000100000000L});
    public static final BitSet FOLLOW_K_COLUMNFAMILY_in_createColumnFamilyStatement1338 = new BitSet(new long[]{0x0000404000000000L});
    public static final BitSet FOLLOW_columnFamilyName_in_createColumnFamilyStatement1342 = new BitSet(new long[]{0x0000000000000000L,0x0000000000200000L});
    public static final BitSet FOLLOW_cfamDefinition_in_createColumnFamilyStatement1352 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_85_in_cfamDefinition1371 = new BitSet(new long[]{0x0000604200010000L});
    public static final BitSet FOLLOW_cfamColumns_in_cfamDefinition1373 = new BitSet(new long[]{0x0000000000000000L,0x0000000001400000L});
    public static final BitSet FOLLOW_88_in_cfamDefinition1378 = new BitSet(new long[]{0x0000604200010000L,0x0000000001400000L});
    public static final BitSet FOLLOW_cfamColumns_in_cfamDefinition1380 = new BitSet(new long[]{0x0000000000000000L,0x0000000001400000L});
    public static final BitSet FOLLOW_86_in_cfamDefinition1387 = new BitSet(new long[]{0x0000000080000002L});
    public static final BitSet FOLLOW_K_WITH_in_cfamDefinition1397 = new BitSet(new long[]{0x0004004800000000L});
    public static final BitSet FOLLOW_cfamProperty_in_cfamDefinition1399 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_K_AND_in_cfamDefinition1404 = new BitSet(new long[]{0x0004004800000000L});
    public static final BitSet FOLLOW_cfamProperty_in_cfamDefinition1406 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_cident_in_cfamColumns1432 = new BitSet(new long[]{0x0000804000200000L});
    public static final BitSet FOLLOW_comparatorType_in_cfamColumns1436 = new BitSet(new long[]{0x0000000200000002L});
    public static final BitSet FOLLOW_K_PRIMARY_in_cfamColumns1441 = new BitSet(new long[]{0x0000000400000000L});
    public static final BitSet FOLLOW_K_KEY_in_cfamColumns1443 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_PRIMARY_in_cfamColumns1455 = new BitSet(new long[]{0x0000000400000000L});
    public static final BitSet FOLLOW_K_KEY_in_cfamColumns1457 = new BitSet(new long[]{0x0000000000000000L,0x0000000000200000L});
    public static final BitSet FOLLOW_85_in_cfamColumns1459 = new BitSet(new long[]{0x0000604000010000L});
    public static final BitSet FOLLOW_cident_in_cfamColumns1463 = new BitSet(new long[]{0x0000000000000000L,0x0000000001400000L});
    public static final BitSet FOLLOW_88_in_cfamColumns1468 = new BitSet(new long[]{0x0000604000010000L});
    public static final BitSet FOLLOW_cident_in_cfamColumns1472 = new BitSet(new long[]{0x0000000000000000L,0x0000000001400000L});
    public static final BitSet FOLLOW_86_in_cfamColumns1479 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_property_in_cfamProperty1499 = new BitSet(new long[]{0x0000000000000000L,0x0000000002000000L});
    public static final BitSet FOLLOW_89_in_cfamProperty1501 = new BitSet(new long[]{0x0001804000010000L});
    public static final BitSet FOLLOW_propertyValue_in_cfamProperty1505 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_COMPACT_in_cfamProperty1515 = new BitSet(new long[]{0x0000001000000000L});
    public static final BitSet FOLLOW_K_STORAGE_in_cfamProperty1517 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_CREATE_in_createIndexStatement1542 = new BitSet(new long[]{0x0000002000000000L});
    public static final BitSet FOLLOW_K_INDEX_in_createIndexStatement1544 = new BitSet(new long[]{0x000000C000000000L});
    public static final BitSet FOLLOW_IDENT_in_createIndexStatement1549 = new BitSet(new long[]{0x0000008000000000L});
    public static final BitSet FOLLOW_K_ON_in_createIndexStatement1553 = new BitSet(new long[]{0x0000404000000000L});
    public static final BitSet FOLLOW_columnFamilyName_in_createIndexStatement1557 = new BitSet(new long[]{0x0000000000000000L,0x0000000000200000L});
    public static final BitSet FOLLOW_85_in_createIndexStatement1559 = new BitSet(new long[]{0x0000604000010000L});
    public static final BitSet FOLLOW_cident_in_createIndexStatement1563 = new BitSet(new long[]{0x0000000000000000L,0x0000000000400000L});
    public static final BitSet FOLLOW_86_in_createIndexStatement1565 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_ALTER_in_alterTableStatement1605 = new BitSet(new long[]{0x0000000100000000L});
    public static final BitSet FOLLOW_K_COLUMNFAMILY_in_alterTableStatement1607 = new BitSet(new long[]{0x0000404000000000L});
    public static final BitSet FOLLOW_columnFamilyName_in_alterTableStatement1611 = new BitSet(new long[]{0x00000D0080000000L});
    public static final BitSet FOLLOW_K_ALTER_in_alterTableStatement1625 = new BitSet(new long[]{0x0000604000010000L});
    public static final BitSet FOLLOW_cident_in_alterTableStatement1629 = new BitSet(new long[]{0x0000020000000000L});
    public static final BitSet FOLLOW_K_TYPE_in_alterTableStatement1631 = new BitSet(new long[]{0x0000804000200000L});
    public static final BitSet FOLLOW_comparatorType_in_alterTableStatement1635 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_ADD_in_alterTableStatement1651 = new BitSet(new long[]{0x0000604000010000L});
    public static final BitSet FOLLOW_cident_in_alterTableStatement1657 = new BitSet(new long[]{0x0000804000200000L});
    public static final BitSet FOLLOW_comparatorType_in_alterTableStatement1661 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DROP_in_alterTableStatement1684 = new BitSet(new long[]{0x0000604000010000L});
    public static final BitSet FOLLOW_cident_in_alterTableStatement1689 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_WITH_in_alterTableStatement1729 = new BitSet(new long[]{0x0004004000000000L});
    public static final BitSet FOLLOW_properties_in_alterTableStatement1734 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DROP_in_dropKeyspaceStatement1794 = new BitSet(new long[]{0x0000000040000000L});
    public static final BitSet FOLLOW_K_KEYSPACE_in_dropKeyspaceStatement1796 = new BitSet(new long[]{0x0000404000000000L});
    public static final BitSet FOLLOW_keyspaceName_in_dropKeyspaceStatement1800 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DROP_in_dropColumnFamilyStatement1825 = new BitSet(new long[]{0x0000000100000000L});
    public static final BitSet FOLLOW_K_COLUMNFAMILY_in_dropColumnFamilyStatement1827 = new BitSet(new long[]{0x0000404000000000L});
    public static final BitSet FOLLOW_columnFamilyName_in_dropColumnFamilyStatement1831 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DROP_in_dropIndexStatement1862 = new BitSet(new long[]{0x0000002000000000L});
    public static final BitSet FOLLOW_K_INDEX_in_dropIndexStatement1864 = new BitSet(new long[]{0x0000004000000000L});
    public static final BitSet FOLLOW_IDENT_in_dropIndexStatement1868 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TRUNCATE_in_truncateStatement1899 = new BitSet(new long[]{0x0000404000000000L});
    public static final BitSet FOLLOW_columnFamilyName_in_truncateStatement1903 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_cident1933 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QUOTED_NAME_in_cident1957 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cfOrKsName_in_keyspaceName2005 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cfOrKsName_in_columnFamilyName2039 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
    public static final BitSet FOLLOW_90_in_columnFamilyName2042 = new BitSet(new long[]{0x0000404000000000L});
    public static final BitSet FOLLOW_cfOrKsName_in_columnFamilyName2046 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENT_in_cfOrKsName2067 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QUOTED_NAME_in_cfOrKsName2086 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_cidentList2121 = new BitSet(new long[]{0x0000000000000002L,0x0000000001000000L});
    public static final BitSet FOLLOW_88_in_cidentList2126 = new BitSet(new long[]{0x0000604000010000L});
    public static final BitSet FOLLOW_cident_in_cidentList2130 = new BitSet(new long[]{0x0000000000000002L,0x0000000001000000L});
    public static final BitSet FOLLOW_set_in_term2158 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QMARK_in_term2189 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INTEGER_in_intTerm2259 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QMARK_in_intTerm2271 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_termPairWithOperation2295 = new BitSet(new long[]{0x0000000000000000L,0x0000000002000000L});
    public static final BitSet FOLLOW_89_in_termPairWithOperation2297 = new BitSet(new long[]{0x0003E04000010000L});
    public static final BitSet FOLLOW_term_in_termPairWithOperation2311 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_termPairWithOperation2327 = new BitSet(new long[]{0x0002000000010000L,0x0000000018000000L});
    public static final BitSet FOLLOW_91_in_termPairWithOperation2331 = new BitSet(new long[]{0x0002000000010000L,0x0000000018000000L});
    public static final BitSet FOLLOW_intTerm_in_termPairWithOperation2339 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_92_in_termPairWithOperation2366 = new BitSet(new long[]{0x0002000000010000L,0x0000000018000000L});
    public static final BitSet FOLLOW_intTerm_in_termPairWithOperation2371 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_property2449 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_propertyValue2480 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_property_in_properties2527 = new BitSet(new long[]{0x0000000000000000L,0x0000000002000000L});
    public static final BitSet FOLLOW_89_in_properties2529 = new BitSet(new long[]{0x0001804000010000L});
    public static final BitSet FOLLOW_propertyValue_in_properties2533 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_K_AND_in_properties2538 = new BitSet(new long[]{0x0004004000000000L});
    public static final BitSet FOLLOW_property_in_properties2542 = new BitSet(new long[]{0x0000000000000000L,0x0000000002000000L});
    public static final BitSet FOLLOW_89_in_properties2544 = new BitSet(new long[]{0x0001804000010000L});
    public static final BitSet FOLLOW_propertyValue_in_properties2548 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_cident_in_relation2576 = new BitSet(new long[]{0x0000000000000000L,0x00000001E2000000L});
    public static final BitSet FOLLOW_set_in_relation2580 = new BitSet(new long[]{0x0003A04000010000L});
    public static final BitSet FOLLOW_term_in_relation2602 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_relation2614 = new BitSet(new long[]{0x0008000000000000L});
    public static final BitSet FOLLOW_K_IN_in_relation2616 = new BitSet(new long[]{0x0000000000000000L,0x0000000000200000L});
    public static final BitSet FOLLOW_85_in_relation2626 = new BitSet(new long[]{0x0003A04000010000L});
    public static final BitSet FOLLOW_term_in_relation2630 = new BitSet(new long[]{0x0000000000000000L,0x0000000001400000L});
    public static final BitSet FOLLOW_88_in_relation2635 = new BitSet(new long[]{0x0003A04000010000L});
    public static final BitSet FOLLOW_term_in_relation2639 = new BitSet(new long[]{0x0000000000000000L,0x0000000001400000L});
    public static final BitSet FOLLOW_86_in_relation2646 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_comparatorType2669 = new BitSet(new long[]{0x0000000000000002L});

}