/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Ordering;
import java.io.IOError;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.cassandra.utils.CloseableIterator;

public abstract class MergeIterator<In, Out>
extends AbstractIterator<Out>
implements CloseableIterator<Out> {
    public final Comparator<In> comp;
    protected final List<? extends CloseableIterator<In>> iterators;
    protected final PriorityQueue<Candidate<In>> queue;

    protected MergeIterator(List<? extends CloseableIterator<In>> iters, Comparator<In> comp) {
        this.iterators = iters;
        this.comp = comp;
        this.queue = new PriorityQueue(Math.max(1, iters.size()));
        for (CloseableIterator<In> iter : iters) {
            Candidate<In> candidate = new Candidate<In>(iter, comp);
            if (!candidate.advance()) continue;
            this.queue.add(candidate);
        }
    }

    public static <E> MergeIterator<E, E> get(List<? extends CloseableIterator<E>> iters) {
        return MergeIterator.get(iters, Ordering.natural());
    }

    public static <E> MergeIterator<E, E> get(List<? extends CloseableIterator<E>> iters, Comparator<E> comp) {
        return new OneToOne<E>(iters, comp);
    }

    public static <In, Out> MergeIterator<In, Out> get(List<? extends CloseableIterator<In>> iters, Comparator<In> comp, Reducer<In, Out> reducer) {
        return new ManyToOne<In, Out>(iters, comp, reducer);
    }

    public Iterable<? extends CloseableIterator<In>> iterators() {
        return this.iterators;
    }

    protected abstract Out consume();

    protected abstract void advance();

    protected final Out computeNext() {
        this.advance();
        return this.consume();
    }

    @Override
    public void close() {
        for (CloseableIterator<In> iterator : this.iterators) {
            try {
                iterator.close();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    public static abstract class Reducer<In, Out> {
        public abstract void reduce(In var1);

        protected abstract Out getReduced();

        protected void onKeyChange() {
        }
    }

    protected static final class Candidate<In>
    implements Comparable<Candidate<In>> {
        private final CloseableIterator<In> iter;
        private final Comparator<In> comp;
        private In item;

        public Candidate(CloseableIterator<In> iter, Comparator<In> comp) {
            this.iter = iter;
            this.comp = comp;
        }

        public In item() {
            return this.item;
        }

        protected boolean advance() {
            if (!this.iter.hasNext()) {
                return false;
            }
            this.item = this.iter.next();
            return true;
        }

        @Override
        public int compareTo(Candidate<In> that) {
            return this.comp.compare(this.item, that.item);
        }
    }

    private static final class ManyToOne<In, Out>
    extends MergeIterator<In, Out> {
        protected final Reducer<In, Out> reducer;
        protected final ArrayDeque<Candidate<In>> candidates;

        public ManyToOne(List<? extends CloseableIterator<In>> iters, Comparator<In> comp, Reducer<In, Out> reducer) {
            super(iters, comp);
            this.reducer = reducer;
            this.candidates = new ArrayDeque(this.queue.size());
        }

        @Override
        protected final Out consume() {
            this.reducer.onKeyChange();
            Candidate candidate = (Candidate)this.queue.peek();
            if (candidate == null) {
                return (Out)this.endOfData();
            }
            do {
                candidate = (Candidate)this.queue.poll();
                this.candidates.push(candidate);
                this.reducer.reduce(candidate.item);
            } while (this.queue.peek() != null && ((Candidate)this.queue.peek()).compareTo(candidate) == 0);
            return this.reducer.getReduced();
        }

        @Override
        protected final void advance() {
            Candidate<In> candidate;
            while ((candidate = this.candidates.pollFirst()) != null) {
                if (!candidate.advance()) continue;
                this.queue.add(candidate);
            }
        }
    }

    private static final class OneToOne<E>
    extends MergeIterator<E, E> {
        protected Candidate<E> candidate;

        public OneToOne(List<? extends CloseableIterator<E>> iters, Comparator<E> comp) {
            super(iters, comp);
        }

        @Override
        protected final E consume() {
            this.candidate = (Candidate)this.queue.poll();
            if (this.candidate == null) {
                return (E)this.endOfData();
            }
            return (E)((Candidate)this.candidate).item;
        }

        @Override
        protected final void advance() {
            if (this.candidate != null && this.candidate.advance()) {
                this.queue.add(this.candidate);
            }
        }
    }
}

