/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.streaming.PendingFile;
import org.apache.cassandra.streaming.StreamReply;
import org.apache.cassandra.utils.Pair;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.cliffc.high_scale_lib.NonBlockingHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamInSession {
    private static final Logger logger = LoggerFactory.getLogger(StreamInSession.class);
    private static ConcurrentMap<Pair<InetAddress, Long>, StreamInSession> sessions = new NonBlockingHashMap();
    private final Set<PendingFile> files = new NonBlockingHashSet();
    private final Pair<InetAddress, Long> context;
    private final Runnable callback;
    private String table;
    private final List<SSTableReader> readers = new ArrayList<SSTableReader>();
    private PendingFile current;

    private StreamInSession(Pair<InetAddress, Long> context, Runnable callback) {
        this.context = context;
        this.callback = callback;
    }

    public static StreamInSession create(InetAddress host, Runnable callback) {
        Pair<InetAddress, Long> context = new Pair<InetAddress, Long>(host, System.nanoTime());
        StreamInSession session = new StreamInSession(context, callback);
        sessions.put(context, session);
        return session;
    }

    public static StreamInSession get(InetAddress host, long sessionId) {
        StreamInSession possibleNew;
        Pair<InetAddress, Long> context = new Pair<InetAddress, Long>(host, sessionId);
        StreamInSession session = (StreamInSession)sessions.get(context);
        if (session == null && (session = sessions.putIfAbsent(context, possibleNew = new StreamInSession(context, null))) == null) {
            session = possibleNew;
        }
        return session;
    }

    public void setCurrentFile(PendingFile file) {
        this.current = file;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void addFiles(Collection<PendingFile> files) {
        for (PendingFile file : files) {
            if (logger.isDebugEnabled()) {
                logger.debug("Adding file {} to Stream Request queue", (Object)file.getFilename());
            }
            this.files.add(file);
        }
    }

    public void finished(PendingFile remoteFile, SSTableReader reader) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Finished {}. Sending ack to {}", (Object)remoteFile, (Object)this);
        }
        assert (reader != null);
        this.readers.add(reader);
        this.files.remove(remoteFile);
        if (remoteFile.equals(this.current)) {
            this.current = null;
        }
        StreamReply reply = new StreamReply(remoteFile.getFilename(), this.getSessionId(), StreamReply.Status.FILE_FINISHED);
        MessagingService.instance().sendOneWay(reply.getMessage(Gossiper.instance.getVersion(this.getHost())), this.getHost());
    }

    public void retry(PendingFile remoteFile) throws IOException {
        StreamReply reply = new StreamReply(remoteFile.getFilename(), this.getSessionId(), StreamReply.Status.FILE_RETRY);
        logger.info("Streaming of file {} from {} failed: requesting a retry.", (Object)remoteFile, (Object)this);
        MessagingService.instance().sendOneWay(reply.getMessage(Gossiper.instance.getVersion(this.getHost())), this.getHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeIfFinished() throws IOException {
        if (this.files.isEmpty()) {
            HashMap cfstores = new HashMap();
            LinkedList<SSTableReader> referenced = new LinkedList<SSTableReader>();
            try {
                for (SSTableReader sSTableReader : this.readers) {
                    assert (sSTableReader.getTableName().equals(this.table));
                    if (!sSTableReader.acquireReference()) {
                        throw new RuntimeException("We shouldn't fail acquiring a reference on a sstable that has just been transfered");
                    }
                    referenced.add(sSTableReader);
                    ColumnFamilyStore cfs = Table.open(sSTableReader.getTableName()).getColumnFamilyStore(sSTableReader.getColumnFamilyName());
                    cfs.addSSTable(sSTableReader);
                    if (!cfstores.containsKey(cfs)) {
                        cfstores.put(cfs, new ArrayList());
                    }
                    ((List)cfstores.get(cfs)).add(sSTableReader);
                }
                for (Map.Entry entry : cfstores.entrySet()) {
                    if (entry.getKey() == null) continue;
                    ((ColumnFamilyStore)entry.getKey()).indexManager.maybeBuildSecondaryIndexes((Collection)entry.getValue(), ((ColumnFamilyStore)entry.getKey()).indexManager.getIndexedColumns());
                }
            }
            finally {
                SSTableReader.releaseReferences(referenced);
            }
            StreamReply reply = new StreamReply("", this.getSessionId(), StreamReply.Status.SESSION_FINISHED);
            logger.info("Finished streaming session {} from {}", (Object)this.getSessionId(), (Object)this.getHost());
            MessagingService.instance().sendOneWay(reply.getMessage(Gossiper.instance.getVersion(this.getHost())), this.getHost());
            if (this.callback != null) {
                this.callback.run();
            }
            sessions.remove(this.context);
        }
    }

    public long getSessionId() {
        return (Long)this.context.right;
    }

    public InetAddress getHost() {
        return (InetAddress)this.context.left;
    }

    public static Set<InetAddress> getSources() {
        HashSet<InetAddress> set = new HashSet<InetAddress>();
        for (StreamInSession session : sessions.values()) {
            set.add(session.getHost());
        }
        return set;
    }

    public static Set<PendingFile> getIncomingFiles(InetAddress host) {
        HashSet<PendingFile> set = new HashSet<PendingFile>();
        for (Map.Entry entry : sessions.entrySet()) {
            if (!((InetAddress)((Pair)entry.getKey()).left).equals(host)) continue;
            StreamInSession session = (StreamInSession)entry.getValue();
            if (session.current != null) {
                set.add(session.current);
            }
            set.addAll(session.files);
        }
        return set;
    }
}

