/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenMetadata {
    private static Logger logger = LoggerFactory.getLogger(TokenMetadata.class);
    private BiMap<Token, InetAddress> tokenToEndpointMap;
    private BiMap<Token, InetAddress> bootstrapTokens = HashBiMap.create();
    private Set<InetAddress> leavingEndpoints = new HashSet<InetAddress>();
    private ConcurrentMap<String, Multimap<Range, InetAddress>> pendingRanges = new ConcurrentHashMap<String, Multimap<Range, InetAddress>>();
    private Set<Pair<Token, InetAddress>> movingEndpoints = new HashSet<Pair<Token, InetAddress>>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private ArrayList<Token> sortedTokens;
    private final CopyOnWriteArrayList<AbstractReplicationStrategy> subscribers = new CopyOnWriteArrayList();

    public TokenMetadata() {
        this(null);
    }

    public TokenMetadata(BiMap<Token, InetAddress> tokenToEndpointMap) {
        if (tokenToEndpointMap == null) {
            tokenToEndpointMap = HashBiMap.create();
        }
        this.tokenToEndpointMap = tokenToEndpointMap;
        this.sortedTokens = this.sortTokens();
    }

    private ArrayList<Token> sortTokens() {
        ArrayList<Token> tokens = new ArrayList<Token>(this.tokenToEndpointMap.keySet());
        Collections.sort(tokens);
        return tokens;
    }

    public int pendingRangeChanges(InetAddress source) {
        int n = 0;
        Range sourceRange = this.getPrimaryRangeFor(this.getToken(source));
        for (Token token : this.bootstrapTokens.keySet()) {
            if (!sourceRange.contains(token)) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNormalToken(Token token, InetAddress endpoint) {
        assert (token != null);
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            this.bootstrapTokens.inverse().remove((Object)endpoint);
            this.tokenToEndpointMap.inverse().remove((Object)endpoint);
            InetAddress prev = (InetAddress)this.tokenToEndpointMap.put((Object)token, (Object)endpoint);
            if (!endpoint.equals(prev)) {
                if (prev != null) {
                    logger.warn("Token " + token + " changing ownership from " + prev + " to " + endpoint);
                }
                this.sortedTokens = this.sortTokens();
            }
            this.leavingEndpoints.remove(endpoint);
            this.removeFromMoving(endpoint);
            this.invalidateCaches();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBootstrapToken(Token token, InetAddress endpoint) {
        assert (token != null);
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            InetAddress oldEndpoint = (InetAddress)this.bootstrapTokens.get((Object)token);
            if (oldEndpoint != null && !oldEndpoint.equals(endpoint)) {
                throw new RuntimeException("Bootstrap Token collision between " + oldEndpoint + " and " + endpoint + " (token " + token);
            }
            oldEndpoint = (InetAddress)this.tokenToEndpointMap.get((Object)token);
            if (oldEndpoint != null && !oldEndpoint.equals(endpoint)) {
                throw new RuntimeException("Bootstrap Token collision between " + oldEndpoint + " and " + endpoint + " (token " + token);
            }
            this.bootstrapTokens.inverse().remove((Object)endpoint);
            this.bootstrapTokens.put((Object)token, (Object)endpoint);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBootstrapToken(Token token) {
        assert (token != null);
        this.lock.writeLock().lock();
        try {
            this.bootstrapTokens.remove((Object)token);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLeavingEndpoint(InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            this.leavingEndpoints.add(endpoint);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMovingEndpoint(Token token, InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            this.movingEndpoints.add(new Pair<Token, InetAddress>(token, endpoint));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEndpoint(InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            this.bootstrapTokens.inverse().remove((Object)endpoint);
            this.tokenToEndpointMap.inverse().remove((Object)endpoint);
            this.leavingEndpoints.remove(endpoint);
            this.sortedTokens = this.sortTokens();
            this.invalidateCaches();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromMoving(InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            for (Pair<Token, InetAddress> pair : this.movingEndpoints) {
                if (!((InetAddress)pair.right).equals(endpoint)) continue;
                this.movingEndpoints.remove(pair);
                break;
            }
            this.invalidateCaches();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token getToken(InetAddress endpoint) {
        assert (endpoint != null);
        assert (this.isMember(endpoint));
        this.lock.readLock().lock();
        try {
            Token token = (Token)this.tokenToEndpointMap.inverse().get((Object)endpoint);
            return token;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMember(InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.readLock().lock();
        try {
            boolean bl = this.tokenToEndpointMap.inverse().containsKey((Object)endpoint);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLeaving(InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.readLock().lock();
        try {
            boolean bl = this.leavingEndpoints.contains(endpoint);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMoving(InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.readLock().lock();
        try {
            for (Pair<Token, InetAddress> pair : this.movingEndpoints) {
                if (!((InetAddress)pair.right).equals(endpoint)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenMetadata cloneOnlyTokenMap() {
        this.lock.readLock().lock();
        try {
            TokenMetadata tokenMetadata = new TokenMetadata((BiMap<Token, InetAddress>)HashBiMap.create(this.tokenToEndpointMap));
            return tokenMetadata;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenMetadata cloneAfterAllLeft() {
        this.lock.readLock().lock();
        try {
            TokenMetadata allLeftMetadata = this.cloneOnlyTokenMap();
            for (InetAddress endpoint : this.leavingEndpoints) {
                allLeftMetadata.removeEndpoint(endpoint);
            }
            TokenMetadata tokenMetadata = allLeftMetadata;
            return tokenMetadata;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenMetadata cloneAfterAllSettled() {
        this.lock.readLock().lock();
        try {
            TokenMetadata metadata = this.cloneOnlyTokenMap();
            for (InetAddress inetAddress : this.leavingEndpoints) {
                metadata.removeEndpoint(inetAddress);
            }
            for (Pair pair : this.movingEndpoints) {
                metadata.updateNormalToken((Token)pair.left, (InetAddress)pair.right);
            }
            TokenMetadata tokenMetadata = metadata;
            return tokenMetadata;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<Map.Entry<Token, InetAddress>> entrySet() {
        return this.tokenToEndpointMap.entrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getEndpoint(Token token) {
        this.lock.readLock().lock();
        try {
            InetAddress inetAddress = (InetAddress)this.tokenToEndpointMap.get((Object)token);
            return inetAddress;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Range getPrimaryRangeFor(Token right) {
        return new Range(this.getPredecessor(right), right);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Token> sortedTokens() {
        this.lock.readLock().lock();
        try {
            ArrayList<Token> arrayList = this.sortedTokens;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Multimap<Range, InetAddress> getPendingRangesMM(String table) {
        Multimap<Range, InetAddress> priorMap;
        Multimap<Range, InetAddress> map = (Multimap<Range, InetAddress>)this.pendingRanges.get(table);
        if (map == null && (priorMap = this.pendingRanges.putIfAbsent(table, map = HashMultimap.create())) != null) {
            map = priorMap;
        }
        return map;
    }

    public Map<Range, Collection<InetAddress>> getPendingRanges(String table) {
        return this.getPendingRangesMM(table).asMap();
    }

    public List<Range> getPendingRanges(String table, InetAddress endpoint) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (Map.Entry entry : this.getPendingRangesMM(table).entries()) {
            if (!((InetAddress)entry.getValue()).equals(endpoint)) continue;
            ranges.add((Range)entry.getKey());
        }
        return ranges;
    }

    public void setPendingRanges(String table, Multimap<Range, InetAddress> rangeMap) {
        this.pendingRanges.put(table, rangeMap);
    }

    public Token getPredecessor(Token token) {
        ArrayList<Token> tokens = this.sortedTokens();
        int index = Collections.binarySearch(tokens, token);
        assert (index >= 0) : token + " not found in " + StringUtils.join((Collection)this.tokenToEndpointMap.keySet(), (String)", ");
        return (Token)(index == 0 ? tokens.get(tokens.size() - 1) : tokens.get(index - 1));
    }

    public Token getSuccessor(Token token) {
        ArrayList<Token> tokens = this.sortedTokens();
        int index = Collections.binarySearch(tokens, token);
        assert (index >= 0) : token + " not found in " + StringUtils.join((Collection)this.tokenToEndpointMap.keySet(), (String)", ");
        return (Token)(index == tokens.size() - 1 ? tokens.get(0) : tokens.get(index + 1));
    }

    public Map<Token, InetAddress> getBootstrapTokens() {
        return this.bootstrapTokens;
    }

    public Set<InetAddress> getLeavingEndpoints() {
        return this.leavingEndpoints;
    }

    public Set<Pair<Token, InetAddress>> getMovingEndpoints() {
        return this.movingEndpoints;
    }

    public static int firstTokenIndex(ArrayList ring, Token start, boolean insertMin) {
        assert (ring.size() > 0);
        int i = Collections.binarySearch(ring, start);
        if (i < 0 && (i = (i + 1) * -1) >= ring.size()) {
            i = insertMin ? -1 : 0;
        }
        return i;
    }

    public static Token firstToken(ArrayList<Token> ring, Token start) {
        return ring.get(TokenMetadata.firstTokenIndex(ring, start, false));
    }

    public static Iterator<Token> ringIterator(final ArrayList<Token> ring, Token start, boolean includeMin) {
        if (ring.isEmpty()) {
            return includeMin ? Iterators.singletonIterator(StorageService.getPartitioner().getMinimumToken()) : Iterators.emptyIterator();
        }
        final boolean insertMin = includeMin && !ring.get(0).equals(StorageService.getPartitioner().getMinimumToken());
        final int startIndex = TokenMetadata.firstTokenIndex(ring, start, insertMin);
        return new AbstractIterator<Token>(){
            int j;
            {
                this.j = startIndex;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Token computeNext() {
                Token token;
                block10: {
                    block8: {
                        Object t;
                        block9: {
                            if (this.j < -1) {
                                return (Token)this.endOfData();
                            }
                            try {
                                if (this.j != -1) break block8;
                                t = StorageService.getPartitioner().getMinimumToken();
                                ++this.j;
                                if (this.j != ring.size()) break block9;
                                int n = this.j = insertMin ? -1 : 0;
                            }
                            catch (Throwable throwable) {
                                ++this.j;
                                if (this.j == ring.size()) {
                                    int n = this.j = insertMin ? -1 : 0;
                                }
                                if (this.j == startIndex) {
                                    this.j = -2;
                                }
                                throw throwable;
                            }
                        }
                        if (this.j == startIndex) {
                            this.j = -2;
                        }
                        return t;
                    }
                    token = (Token)ring.get(this.j);
                    ++this.j;
                    if (this.j != ring.size()) break block10;
                    int n = this.j = insertMin ? -1 : 0;
                }
                if (this.j == startIndex) {
                    this.j = -2;
                }
                return token;
            }
        };
    }

    public void clearUnsafe() {
        this.bootstrapTokens.clear();
        this.tokenToEndpointMap.clear();
        this.leavingEndpoints.clear();
        this.pendingRanges.clear();
        this.invalidateCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.lock.readLock().lock();
        try {
            Set eps = this.tokenToEndpointMap.inverse().keySet();
            if (!eps.isEmpty()) {
                sb.append("Normal Tokens:");
                sb.append(System.getProperty("line.separator"));
                for (InetAddress ep : eps) {
                    sb.append(ep);
                    sb.append(":");
                    sb.append(this.tokenToEndpointMap.inverse().get((Object)ep));
                    sb.append(System.getProperty("line.separator"));
                }
            }
            if (!this.bootstrapTokens.isEmpty()) {
                sb.append("Bootstrapping Tokens:");
                sb.append(System.getProperty("line.separator"));
                for (Map.Entry entry : this.bootstrapTokens.entrySet()) {
                    sb.append(entry.getValue() + ":" + entry.getKey());
                    sb.append(System.getProperty("line.separator"));
                }
            }
            if (!this.leavingEndpoints.isEmpty()) {
                sb.append("Leaving Endpoints:");
                sb.append(System.getProperty("line.separator"));
                for (InetAddress ep : this.leavingEndpoints) {
                    sb.append(ep);
                    sb.append(System.getProperty("line.separator"));
                }
            }
            if (!this.pendingRanges.isEmpty()) {
                sb.append("Pending Ranges:");
                sb.append(System.getProperty("line.separator"));
                sb.append(this.printPendingRanges());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return sb.toString();
    }

    public String printPendingRanges() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.pendingRanges.entrySet()) {
            for (Map.Entry rmap : ((Multimap)entry.getValue()).entries()) {
                sb.append(rmap.getValue() + ":" + rmap.getKey());
                sb.append(System.getProperty("line.separator"));
            }
        }
        return sb.toString();
    }

    public void invalidateCaches() {
        for (AbstractReplicationStrategy subscriber : this.subscribers) {
            subscriber.invalidateCachedTokenEndpointValues();
        }
    }

    public void register(AbstractReplicationStrategy subscriber) {
        this.subscribers.add(subscriber);
    }

    public void unregister(AbstractReplicationStrategy subscriber) {
        this.subscribers.remove(subscriber);
    }

    public Collection<InetAddress> getWriteEndpoints(Token token, String table, Collection<InetAddress> naturalEndpoints) {
        Map<Range, Collection<InetAddress>> ranges = this.getPendingRanges(table);
        if (ranges.isEmpty()) {
            return naturalEndpoints;
        }
        HashSet<InetAddress> endpoints = new HashSet<InetAddress>(naturalEndpoints);
        for (Map.Entry<Range, Collection<InetAddress>> entry : ranges.entrySet()) {
            if (!entry.getKey().contains(token)) continue;
            endpoints.addAll(entry.getValue());
        }
        return endpoints;
    }

    public Map<Token, InetAddress> getTokenToEndpointMap() {
        HashMap<Token, InetAddress> map = new HashMap<Token, InetAddress>(this.tokenToEndpointMap.size() + this.bootstrapTokens.size());
        map.putAll((Map<Token, InetAddress>)this.tokenToEndpointMap);
        map.putAll((Map<Token, InetAddress>)this.bootstrapTokens);
        return map;
    }
}

