/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.LeveledCompactionTask;
import org.apache.cassandra.db.compaction.LeveledManifest;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.notifications.INotification;
import org.apache.cassandra.notifications.INotificationConsumer;
import org.apache.cassandra.notifications.SSTableAddedNotification;
import org.apache.cassandra.notifications.SSTableListChangedNotification;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeveledCompactionStrategy
extends AbstractCompactionStrategy
implements INotificationConsumer {
    private static final Logger logger = LoggerFactory.getLogger(LeveledCompactionStrategy.class);
    private LeveledManifest manifest;
    private final String SSTABLE_SIZE_OPTION = "sstable_size_in_mb";
    private final int maxSSTableSize;
    private final AtomicReference<LeveledCompactionTask> task = new AtomicReference();

    public LeveledCompactionStrategy(ColumnFamilyStore cfs, Map<String, String> options) {
        super(cfs, options);
        int configuredMaxSSTableSize = 5;
        if (options != null) {
            String value;
            String string = value = options.containsKey("sstable_size_in_mb") ? options.get("sstable_size_in_mb") : null;
            if (null != value) {
                try {
                    configuredMaxSSTableSize = Integer.parseInt(value);
                }
                catch (NumberFormatException ex) {
                    logger.warn(String.format("%s is not a parsable int (base10) for %s using default value", value, "sstable_size_in_mb"));
                }
            }
        }
        this.maxSSTableSize = configuredMaxSSTableSize;
        cfs.getDataTracker().subscribe(this);
        logger.info(this + " subscribed to the data tracker.");
        this.manifest = LeveledManifest.create(cfs, this.maxSSTableSize);
        cfs.setMaximumCompactionThreshold(Integer.MAX_VALUE);
        cfs.setMinimumCompactionThreshold(1);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.cfs.getDataTracker().unsubscribe(this);
    }

    public int getLevelSize(int i) {
        return this.manifest.getLevelSize(i);
    }

    @Override
    public List<AbstractCompactionTask> getBackgroundTasks(int gcBefore) {
        LeveledCompactionTask currentTask = this.task.get();
        if (currentTask != null && !currentTask.isDone()) {
            return Collections.emptyList();
        }
        Collection<SSTableReader> sstables = this.manifest.getCompactionCandidates();
        logger.debug("CompactionManager candidates are {}", (Object)StringUtils.join(sstables, (String)","));
        if (sstables.isEmpty()) {
            return Collections.emptyList();
        }
        LeveledCompactionTask newTask = new LeveledCompactionTask(this.cfs, sstables, gcBefore, this.maxSSTableSize);
        return this.task.compareAndSet(currentTask, newTask) ? Collections.singletonList(newTask) : Collections.emptyList();
    }

    @Override
    public List<AbstractCompactionTask> getMaximalTasks(int gcBefore) {
        return this.getBackgroundTasks(gcBefore);
    }

    @Override
    public AbstractCompactionTask getUserDefinedTask(Collection<SSTableReader> sstables, int gcBefore) {
        throw new UnsupportedOperationException("LevelDB compaction strategy does not allow user-specified compactions");
    }

    @Override
    public int getEstimatedRemainingTasks() {
        return 0;
    }

    @Override
    public void handleNotification(INotification notification, Object sender) {
        if (notification instanceof SSTableAddedNotification) {
            SSTableAddedNotification flushedNotification = (SSTableAddedNotification)notification;
            this.manifest.add(flushedNotification.added);
            this.manifest.logDistribution();
        } else if (notification instanceof SSTableListChangedNotification) {
            SSTableListChangedNotification listChangedNotification = (SSTableListChangedNotification)notification;
            this.manifest.promote(listChangedNotification.removed, listChangedNotification.added);
            this.manifest.logDistribution();
        }
    }
}

