/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.AbstractCompactionIterable;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionIterable;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.compaction.ParallelCompactionIterable;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionTask
extends AbstractCompactionTask {
    private static final Logger logger = LoggerFactory.getLogger(CompactionTask.class);
    protected String compactionFileLocation = null;
    protected final int gcBefore;
    protected boolean isUserDefined;
    protected static long totalBytesCompacted = 0L;

    public CompactionTask(ColumnFamilyStore cfs, Collection<SSTableReader> sstables, int gcBefore) {
        super(cfs, sstables);
        this.gcBefore = gcBefore;
        this.isUserDefined = false;
    }

    public static synchronized long addToTotalBytesCompacted(long bytesCompacted) {
        return totalBytesCompacted += bytesCompacted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(CompactionManager.CompactionExecutorStatsCollector collector) throws IOException {
        assert (this.sstables != null);
        HashSet<SSTableReader> toCompact = new HashSet<SSTableReader>(this.sstables);
        if (!this.isUserDefined) {
            if (!this.allowSingletonCompaction() && toCompact.size() < 2) {
                logger.info("Nothing to compact in " + this.cfs.getColumnFamilyName() + "." + "Use forceUserDefinedCompaction if you wish to force compaction of single sstables " + "(e.g. for tombstone collection)");
                return 0;
            }
            if (this.compactionFileLocation == null) {
                this.compactionFileLocation = this.cfs.table.getDataFileLocation(this.cfs.getExpectedCompactedFileSize(toCompact));
            }
            if (this.compactionFileLocation == null) {
                while (this.compactionFileLocation == null && toCompact.size() > 1) {
                    logger.warn("insufficient space to compact all requested files " + StringUtils.join(toCompact, (String)", "));
                    toCompact.remove(this.cfs.getMaxSizeFile(toCompact));
                    this.compactionFileLocation = this.cfs.table.getDataFileLocation(this.cfs.getExpectedCompactedFileSize(toCompact));
                }
            }
            if (this.compactionFileLocation == null) {
                logger.warn("insufficient space to compact even the two smallest files, aborting");
                return 0;
            }
        }
        if (DatabaseDescriptor.isSnapshotBeforeCompaction()) {
            this.cfs.table.snapshot(System.currentTimeMillis() + "-" + "compact-" + this.cfs.columnFamily);
        }
        for (SSTableReader sstable : toCompact) {
            assert (sstable.descriptor.cfname.equals(this.cfs.columnFamily));
        }
        CompactionController controller = new CompactionController(this.cfs, toCompact, this.gcBefore, this.isUserDefined);
        logger.info("Compacting {}", toCompact);
        long startTime = System.currentTimeMillis();
        long totalkeysWritten = 0L;
        int expectedBloomFilterSize = Math.max(DatabaseDescriptor.getIndexInterval(), (int)SSTableReader.getApproximateKeyCount(toCompact));
        if (logger.isDebugEnabled()) {
            logger.debug("Expected bloom filter size : " + expectedBloomFilterSize);
        }
        AbstractCompactionIterable ci = DatabaseDescriptor.isMultithreadedCompaction() ? new ParallelCompactionIterable(OperationType.COMPACTION, toCompact, controller) : new CompactionIterable(OperationType.COMPACTION, toCompact, controller);
        Iterator iter = ci.iterator();
        UnmodifiableIterator nni = Iterators.filter((Iterator)iter, (Predicate)Predicates.notNull());
        HashMap cachedKeys = new HashMap();
        HashMap cachedKeyMap = new HashMap();
        ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>();
        ArrayList<SSTableWriter> writers = new ArrayList<SSTableWriter>();
        if (collector != null) {
            collector.beginCompaction(ci);
        }
        try {
            if (!nni.hasNext()) {
                this.cfs.markCompacted(toCompact);
                int n = 0;
                return n;
            }
            SSTableWriter writer = this.cfs.createCompactionWriter(expectedBloomFilterSize, this.compactionFileLocation, toCompact);
            writers.add(writer);
            while (nni.hasNext()) {
                AbstractCompactedRow abstractCompactedRow = (AbstractCompactedRow)nni.next();
                if (abstractCompactedRow.isEmpty()) continue;
                long position = writer.append(abstractCompactedRow);
                ++totalkeysWritten;
                if (DatabaseDescriptor.getPreheatKeyCache()) {
                    for (SSTableReader sstable : toCompact) {
                        if (sstable.getCachedPosition(abstractCompactedRow.key) == null) continue;
                        cachedKeys.put(abstractCompactedRow.key, position);
                        break;
                    }
                }
                if (nni.hasNext() && !this.newSSTableSegmentThresholdReached(writer, position)) continue;
                SSTableReader toIndex = writer.closeAndOpenReader(CompactionTask.getMaxDataAge(toCompact));
                cachedKeyMap.put(toIndex, cachedKeys);
                sstables.add(toIndex);
                writer = this.cfs.createCompactionWriter(expectedBloomFilterSize, this.compactionFileLocation, toCompact);
                writers.add(writer);
                cachedKeys = new HashMap();
            }
        }
        finally {
            iter.close();
            if (collector != null) {
                collector.finishCompaction(ci);
            }
            for (SSTableWriter writer : writers) {
                writer.cleanupIfNecessary();
            }
        }
        this.cfs.replaceCompactedSSTables(toCompact, sstables);
        for (Map.Entry entry : cachedKeyMap.entrySet()) {
            SSTableReader key = (SSTableReader)entry.getKey();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                key.cacheKey((DecoratedKey)entry2.getKey(), (Long)entry2.getValue());
            }
        }
        CompactionManager.instance.submitBackground(this.cfs);
        long dTime = System.currentTimeMillis() - startTime;
        long startsize = SSTable.getTotalBytes(toCompact);
        long endsize = SSTable.getTotalBytes(sstables);
        double ratio = (double)endsize / (double)startsize;
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (SSTableReader reader : sstables) {
            builder.append(reader.getFilename()).append(",");
        }
        builder.append("]");
        double mbps = dTime > 0L ? (double)endsize / 1048576.0 / ((double)dTime / 1000.0) : 0.0;
        logger.info(String.format("Compacted to %s.  %,d to %,d (~%d%% of original) bytes for %,d keys at %fMBPS.  Time: %,dms.", builder.toString(), startsize, endsize, (int)(ratio * 100.0), totalkeysWritten, mbps, dTime));
        logger.info(String.format("CF Total Bytes Compacted: %,d", CompactionTask.addToTotalBytesCompacted(endsize)));
        return toCompact.size();
    }

    protected boolean newSSTableSegmentThresholdReached(SSTableWriter writer, long position) {
        return false;
    }

    protected boolean allowSingletonCompaction() {
        return false;
    }

    public static long getMaxDataAge(Collection<SSTableReader> sstables) {
        long max = 0L;
        for (SSTableReader sstable : sstables) {
            if (sstable.maxDataAge <= max) continue;
            max = sstable.maxDataAge;
        }
        return max;
    }

    public CompactionTask compactionFileLocation(String compactionFileLocation) {
        this.compactionFileLocation = compactionFileLocation;
        return this;
    }

    public CompactionTask isUserDefined(boolean isUserDefined) {
        this.isUserDefined = isUserDefined;
        return this;
    }
}

