/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.cache.AutoSavingCache;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionIterable;
import org.apache.cassandra.db.compaction.CompactionManagerMBean;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.index.SecondaryIndexBuilder;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableScanner;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.service.AntiEntropyService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.NodeId;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionManager
implements CompactionManagerMBean {
    public static final String MBEAN_OBJECT_NAME = "org.apache.cassandra.db:type=CompactionManager";
    private static final Logger logger = LoggerFactory.getLogger(CompactionManager.class);
    public static final CompactionManager instance = new CompactionManager();
    private final ReentrantReadWriteLock compactionLock = new ReentrantReadWriteLock();
    private CompactionExecutor executor = new CompactionExecutor();
    private CompactionExecutor validationExecutor = new ValidationExecutor();

    public Lock getCompactionLock() {
        return this.compactionLock.writeLock();
    }

    public Future<Integer> submitBackground(final ColumnFamilyStore cfs) {
        Callable<Integer> callable = new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws IOException {
                CompactionManager.this.compactionLock.readLock().lock();
                try {
                    if (cfs.isInvalid()) {
                        Integer n = 0;
                        return n;
                    }
                    AbstractCompactionStrategy strategy = cfs.getCompactionStrategy();
                    for (AbstractCompactionTask task : strategy.getBackgroundTasks(CompactionManager.getDefaultGcBefore(cfs))) {
                        if (!task.markSSTablesForCompaction()) continue;
                        try {
                            task.execute(CompactionManager.this.executor);
                        }
                        finally {
                            task.unmarkSSTables();
                        }
                    }
                }
                finally {
                    CompactionManager.this.compactionLock.readLock().unlock();
                }
                return 0;
            }
        };
        return this.executor.submit(callable);
    }

    public void performCleanup(final ColumnFamilyStore cfStore, final NodeId.OneShotRenewer renewer) throws InterruptedException, ExecutionException {
        Callable<Object> runnable = new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws IOException {
                CompactionManager.this.compactionLock.writeLock().lock();
                try {
                    if (cfStore.isInvalid()) {
                        2 var1_1 = this;
                        return var1_1;
                    }
                    Set<SSTableReader> tocleanup = cfStore.getDataTracker().markCompacting(cfStore.getSSTables(), 1, Integer.MAX_VALUE);
                    if (tocleanup == null || tocleanup.isEmpty()) {
                        2 var2_3 = this;
                        return var2_3;
                    }
                    try {
                        CompactionManager.this.compactionLock.readLock().lock();
                        CompactionManager.this.compactionLock.writeLock().unlock();
                        try {
                            CompactionManager.this.doCleanupCompaction(cfStore, tocleanup, renewer);
                        }
                        finally {
                            CompactionManager.this.compactionLock.readLock().unlock();
                        }
                    }
                    finally {
                        cfStore.getDataTracker().unmarkCompacting(tocleanup);
                    }
                    2 var2_4 = this;
                    return var2_4;
                }
                finally {
                    if (CompactionManager.this.compactionLock.writeLock().isHeldByCurrentThread()) {
                        CompactionManager.this.compactionLock.writeLock().unlock();
                    }
                }
            }
        };
        this.executor.submit(runnable).get();
    }

    public void performScrub(final ColumnFamilyStore cfStore) throws InterruptedException, ExecutionException {
        Callable<Object> runnable = new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws IOException {
                CompactionManager.this.compactionLock.writeLock().lock();
                try {
                    if (cfStore.isInvalid()) {
                        3 var1_1 = this;
                        return var1_1;
                    }
                    Set<SSTableReader> toscrub = cfStore.getDataTracker().markCompacting(cfStore.getSSTables(), 1, Integer.MAX_VALUE);
                    if (toscrub == null || toscrub.isEmpty()) {
                        3 var2_3 = this;
                        return var2_3;
                    }
                    try {
                        CompactionManager.this.compactionLock.readLock().lock();
                        CompactionManager.this.compactionLock.writeLock().unlock();
                        try {
                            CompactionManager.this.doScrub(cfStore, toscrub);
                        }
                        finally {
                            CompactionManager.this.compactionLock.readLock().unlock();
                        }
                    }
                    finally {
                        cfStore.getDataTracker().unmarkCompacting(toscrub);
                    }
                    3 var2_4 = this;
                    return var2_4;
                }
                finally {
                    if (CompactionManager.this.compactionLock.writeLock().isHeldByCurrentThread()) {
                        CompactionManager.this.compactionLock.writeLock().unlock();
                    }
                }
            }
        };
        this.executor.submit(runnable).get();
    }

    public void performMaximal(ColumnFamilyStore cfStore) throws InterruptedException, ExecutionException {
        this.submitMaximal(cfStore, CompactionManager.getDefaultGcBefore(cfStore)).get();
    }

    public Future<Object> submitMaximal(final ColumnFamilyStore cfStore, final int gcBefore) {
        Callable<Object> callable = new Callable<Object>(){

            /*
             * Exception decompiling
             */
            @Override
            public Object call() throws IOException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        return this.executor.submit(callable);
    }

    @Override
    public void forceUserDefinedCompaction(String ksname, String dataFiles) {
        if (!Schema.instance.getTables().contains(ksname)) {
            throw new IllegalArgumentException("Unknown keyspace " + ksname);
        }
        File directory = new File(ksname);
        String[] filenames = dataFiles.split(",");
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>(filenames.length);
        String cfname = null;
        for (String filename : filenames) {
            Pair<Descriptor, String> p = Descriptor.fromFilename(directory, filename.trim());
            if (!((String)p.right).equals(Component.DATA.name())) {
                throw new IllegalArgumentException(filename + " does not appear to be a data file");
            }
            if (cfname == null) {
                cfname = ((Descriptor)p.left).cfname;
            } else if (!cfname.equals(((Descriptor)p.left).cfname)) {
                throw new IllegalArgumentException("All provided sstables should be for the same column family");
            }
            descriptors.add((Descriptor)p.left);
        }
        ColumnFamilyStore cfs = Table.open(ksname).getColumnFamilyStore(cfname);
        this.submitUserDefined(cfs, descriptors, CompactionManager.getDefaultGcBefore(cfs));
    }

    public Future<Object> submitUserDefined(final ColumnFamilyStore cfs, final Collection<Descriptor> dataFiles, final int gcBefore) {
        Callable<Object> callable = new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws IOException {
                CompactionManager.this.compactionLock.readLock().lock();
                try {
                    block15: {
                        if (cfs.isInvalid()) {
                            5 var1_1 = this;
                            return var1_1;
                        }
                        ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>();
                        for (Descriptor desc : dataFiles) {
                            SSTableReader sstable = CompactionManager.this.lookupSSTable(cfs, desc);
                            if (sstable == null) {
                                logger.info("Will not compact {}: it is not an active sstable", (Object)desc);
                                continue;
                            }
                            sstables.add(sstable);
                        }
                        try {
                            if (sstables.isEmpty()) {
                                logger.error("No file to compact for user defined compaction");
                                break block15;
                            }
                            Set<SSTableReader> toCompact = cfs.getDataTracker().markCompacting(sstables, 1, Integer.MAX_VALUE);
                            if (toCompact != null) {
                                try {
                                    AbstractCompactionStrategy strategy = cfs.getCompactionStrategy();
                                    AbstractCompactionTask task = strategy.getUserDefinedTask(toCompact, gcBefore);
                                    task.execute(CompactionManager.this.executor);
                                    break block15;
                                }
                                finally {
                                    cfs.getDataTracker().unmarkCompacting(toCompact);
                                }
                            }
                            logger.error("SSTables for user defined compaction are already being compacted.");
                        }
                        finally {
                            SSTableReader.releaseReferences(sstables);
                        }
                    }
                    5 var3_4 = this;
                    return var3_4;
                }
                finally {
                    CompactionManager.this.compactionLock.readLock().unlock();
                }
            }
        };
        return this.executor.submit(callable);
    }

    private SSTableReader lookupSSTable(ColumnFamilyStore cfs, Descriptor descriptor) {
        SSTableReader found = null;
        for (SSTableReader sstable : cfs.markCurrentSSTablesReferenced()) {
            if (sstable.descriptor.toString().endsWith(descriptor.toString())) {
                found = sstable;
                continue;
            }
            sstable.releaseReference();
        }
        return found;
    }

    public Future<Object> submitValidation(final ColumnFamilyStore cfStore, final AntiEntropyService.Validator validator) {
        Callable<Object> callable = new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws IOException {
                CompactionManager.this.compactionLock.readLock().lock();
                try {
                    if (!cfStore.isInvalid()) {
                        CompactionManager.this.doValidationCompaction(cfStore, validator);
                    }
                    6 var1_1 = this;
                    return var1_1;
                }
                finally {
                    CompactionManager.this.compactionLock.readLock().unlock();
                }
            }
        };
        return this.validationExecutor.submit(callable);
    }

    public void disableAutoCompaction() {
        for (String ksname : Schema.instance.getNonSystemTables()) {
            for (ColumnFamilyStore cfs : Table.open(ksname).getColumnFamilyStores()) {
                cfs.disableAutoCompaction();
            }
        }
    }

    private void doScrub(ColumnFamilyStore cfs, Collection<SSTableReader> sstables) throws IOException {
        assert (!cfs.isIndex());
        for (SSTableReader sstable : sstables) {
            this.scrubOne(cfs, sstable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void scrubOne(ColumnFamilyStore cfs, SSTableReader sstable) throws IOException {
        logger.info("Scrubbing " + sstable);
        CompactionController controller = new CompactionController(cfs, Collections.singletonList(sstable), CompactionManager.getDefaultGcBefore(cfs), true);
        boolean isCommutative = cfs.metadata.getDefaultValidator().isCommutative();
        String compactionFileLocation = cfs.table.getDataFileLocation(sstable.length());
        if (compactionFileLocation == null) {
            throw new IOException("disk full");
        }
        int expectedBloomFilterSize = Math.max(DatabaseDescriptor.getIndexInterval(), (int)SSTableReader.getApproximateKeyCount(Arrays.asList(sstable)));
        RandomAccessReader dataFile = sstable.openDataReader(true);
        String indexFilename = sstable.descriptor.filenameFor(Component.PRIMARY_INDEX);
        RandomAccessReader indexFile = RandomAccessReader.open(new File(indexFilename), true);
        try {
            ByteBuffer nextIndexKey = ByteBufferUtil.readWithShortLength(indexFile);
            long firstRowPositionFromIndex = indexFile.readLong();
            assert (firstRowPositionFromIndex == 0L) : firstRowPositionFromIndex;
            SSTableWriter writer = this.maybeCreateWriter(cfs, compactionFileLocation, expectedBloomFilterSize, null, Collections.singletonList(sstable));
            SSTableReader newSstable = null;
            this.executor.beginCompaction(new ScrubInfo(dataFile, sstable));
            int goodRows = 0;
            int badRows = 0;
            int emptyRows = 0;
            try {
                while (!dataFile.isEOF()) {
                    long nextRowPositionFromIndex;
                    long rowStart = dataFile.getFilePointer();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Reading row at " + rowStart);
                    }
                    DecoratedKey key = null;
                    long dataSize = -1L;
                    try {
                        key = SSTableReader.decodeKey(sstable.partitioner, sstable.descriptor, ByteBufferUtil.readWithShortLength(dataFile));
                        long l = dataSize = sstable.descriptor.hasIntRowSize ? (long)dataFile.readInt() : dataFile.readLong();
                        if (logger.isDebugEnabled()) {
                            logger.debug(String.format("row %s is %s bytes", ByteBufferUtil.bytesToHex(key.key), dataSize));
                        }
                    }
                    catch (Throwable th) {
                        this.throwIfFatal(th);
                    }
                    ByteBuffer currentIndexKey = nextIndexKey;
                    try {
                        nextIndexKey = indexFile.isEOF() ? null : ByteBufferUtil.readWithShortLength(indexFile);
                        nextRowPositionFromIndex = indexFile.isEOF() ? dataFile.length() : indexFile.readLong();
                    }
                    catch (Throwable th) {
                        logger.warn("Error reading index file", th);
                        nextIndexKey = null;
                        nextRowPositionFromIndex = dataFile.length();
                    }
                    long dataStart = dataFile.getFilePointer();
                    long dataStartFromIndex = currentIndexKey == null ? -1L : rowStart + 2L + (long)currentIndexKey.remaining() + (long)(sstable.descriptor.hasIntRowSize ? 4 : 8);
                    long dataSizeFromIndex = nextRowPositionFromIndex - dataStartFromIndex;
                    assert (currentIndexKey != null || indexFile.isEOF());
                    if (logger.isDebugEnabled() && currentIndexKey != null) {
                        logger.debug(String.format("Index doublecheck: row %s is %s bytes", ByteBufferUtil.bytesToHex(currentIndexKey), dataSizeFromIndex));
                    }
                    writer.mark();
                    try {
                        if (key == null) {
                            throw new IOError(new IOException("Unable to read row key from data file"));
                        }
                        if (dataSize > dataFile.length()) {
                            throw new IOError(new IOException("Impossible row size " + dataSize));
                        }
                        SSTableIdentityIterator row = new SSTableIdentityIterator(sstable, dataFile, key, dataStart, dataSize, true);
                        AbstractCompactedRow compactedRow = controller.getCompactedRow(row);
                        if (compactedRow.isEmpty()) {
                            ++emptyRows;
                        } else {
                            writer.append(compactedRow);
                            ++goodRows;
                        }
                        if (key.key.equals(currentIndexKey) && dataStart == dataStartFromIndex) continue;
                        logger.warn("Index file contained a different key or row size; using key from data file");
                    }
                    catch (Throwable th) {
                        this.throwIfFatal(th);
                        logger.warn("Non-fatal error reading row (stacktrace follows)", th);
                        writer.resetAndTruncate();
                        if (!(currentIndexKey == null || key != null && key.key.equals(currentIndexKey) && dataStart == dataStartFromIndex && dataSize == dataSizeFromIndex)) {
                            logger.info(String.format("Retrying from row index; data is %s bytes starting at %s", dataSizeFromIndex, dataStartFromIndex));
                            key = SSTableReader.decodeKey(sstable.partitioner, sstable.descriptor, currentIndexKey);
                            try {
                                SSTableIdentityIterator row = new SSTableIdentityIterator(sstable, dataFile, key, dataStartFromIndex, dataSizeFromIndex, true);
                                AbstractCompactedRow compactedRow = controller.getCompactedRow(row);
                                if (compactedRow.isEmpty()) {
                                    ++emptyRows;
                                    continue;
                                }
                                writer.append(compactedRow);
                                ++goodRows;
                                continue;
                            }
                            catch (Throwable th2) {
                                this.throwIfFatal(th2);
                                if (isCommutative) {
                                    throw new IOError(th2);
                                }
                                logger.warn("Retry failed too.  Skipping to next row (retry's stacktrace follows)", th2);
                                writer.resetAndTruncate();
                                dataFile.seek(nextRowPositionFromIndex);
                                ++badRows;
                                continue;
                            }
                        }
                        if (isCommutative) {
                            throw new IOError(th);
                        }
                        logger.warn("Row at " + dataStart + " is unreadable; skipping to next");
                        if (currentIndexKey != null) {
                            dataFile.seek(nextRowPositionFromIndex);
                        }
                        ++badRows;
                    }
                }
                if (writer.getFilePointer() > 0L) {
                    newSstable = writer.closeAndOpenReader(sstable.maxDataAge);
                }
            }
            finally {
                writer.cleanupIfNecessary();
            }
            if (newSstable != null) {
                cfs.replaceCompactedSSTables(Arrays.asList(sstable), Arrays.asList(newSstable));
                logger.info("Scrub of " + sstable + " complete: " + goodRows + " rows in new sstable and " + emptyRows + " empty (tombstoned) rows dropped");
                if (badRows <= 0) return;
                logger.warn("Unable to recover " + badRows + " rows that were skipped.  You can attempt manual recovery from the pre-scrub snapshot.  You can also run nodetool repair to transfer the data from a healthy replica, if any");
                return;
            }
            cfs.markCompacted(Arrays.asList(sstable));
            if (badRows > 0) {
                logger.warn("No valid rows found while scrubbing " + sstable + "; it is marked for deletion now. If you want to attempt manual recovery, you can find a copy in the pre-scrub snapshot");
                return;
            }
            logger.info("Scrub of " + sstable + " complete; looks like all " + emptyRows + " rows were tombstoned");
            return;
        }
        finally {
            FileUtils.closeQuietly(dataFile);
            FileUtils.closeQuietly(indexFile);
        }
    }

    private void throwIfFatal(Throwable th) {
        if (th instanceof Error && !(th instanceof AssertionError) && !(th instanceof IOError)) {
            throw (Error)th;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanupCompaction(ColumnFamilyStore cfs, Collection<SSTableReader> sstables, NodeId.OneShotRenewer renewer) throws IOException {
        assert (!cfs.isIndex());
        Table table = cfs.table;
        Collection<Range> ranges = StorageService.instance.getLocalRanges(table.name);
        boolean isCommutative = cfs.metadata.getDefaultValidator().isCommutative();
        if (ranges.isEmpty()) {
            logger.info("Cleanup cannot run before a node has joined the ring");
            return;
        }
        for (SSTableReader sstable : sstables) {
            CompactionController controller = new CompactionController(cfs, Collections.singletonList(sstable), CompactionManager.getDefaultGcBefore(cfs), false);
            long startTime = System.currentTimeMillis();
            long totalkeysWritten = 0L;
            int expectedBloomFilterSize = Math.max(DatabaseDescriptor.getIndexInterval(), (int)SSTableReader.getApproximateKeyCount(Arrays.asList(sstable)));
            if (logger.isDebugEnabled()) {
                logger.debug("Expected bloom filter size : " + expectedBloomFilterSize);
            }
            SSTableWriter writer = null;
            SSTableReader newSstable = null;
            logger.info("Cleaning up " + sstable);
            long expectedRangeFileSize = cfs.getExpectedCompactedFileSize(Arrays.asList(sstable)) / 2L;
            String compactionFileLocation = table.getDataFileLocation(expectedRangeFileSize);
            if (compactionFileLocation == null) {
                throw new IOException("disk full");
            }
            SSTableScanner scanner = sstable.getDirectScanner();
            SortedSet<ByteBuffer> indexedColumns = cfs.indexManager.getIndexedColumns();
            ArrayList<IColumn> indexedColumnsInRow = null;
            CleanupInfo ci = new CleanupInfo(sstable, scanner);
            this.executor.beginCompaction(ci);
            try {
                while (scanner.hasNext()) {
                    SSTableIdentityIterator row = (SSTableIdentityIterator)scanner.next();
                    if (Range.isTokenInRanges(row.getKey().token, ranges)) {
                        AbstractCompactedRow compactedRow = controller.getCompactedRow(row);
                        if (compactedRow.isEmpty()) continue;
                        writer = this.maybeCreateWriter(cfs, compactionFileLocation, expectedBloomFilterSize, writer, Collections.singletonList(sstable));
                        writer.append(compactedRow);
                        ++totalkeysWritten;
                        continue;
                    }
                    cfs.invalidateCachedRow(row.getKey());
                    if (indexedColumns.isEmpty() && !isCommutative) continue;
                    if (indexedColumnsInRow != null) {
                        indexedColumnsInRow.clear();
                    }
                    while (row.hasNext()) {
                        IColumn column = row.next();
                        if (column instanceof CounterColumn) {
                            renewer.maybeRenew((CounterColumn)column);
                        }
                        if (!indexedColumns.contains(column.name())) continue;
                        if (indexedColumnsInRow == null) {
                            indexedColumnsInRow = new ArrayList<IColumn>();
                        }
                        indexedColumnsInRow.add(column);
                    }
                    if (indexedColumnsInRow == null || indexedColumnsInRow.isEmpty()) continue;
                    cfs.indexManager.deleteFromIndexes(row.getKey(), (List<IColumn>)indexedColumnsInRow);
                }
                if (writer != null) {
                    newSstable = writer.closeAndOpenReader(sstable.maxDataAge);
                }
            }
            finally {
                scanner.close();
                this.executor.finishCompaction(ci);
                if (writer != null) {
                    writer.cleanupIfNecessary();
                }
                this.executor.finishCompaction(ci);
            }
            ArrayList<SSTableReader> results = new ArrayList<SSTableReader>();
            if (newSstable != null) {
                results.add(newSstable);
                String format = "Cleaned up to %s.  %,d to %,d (~%d%% of original) bytes for %,d keys.  Time: %,dms.";
                long dTime = System.currentTimeMillis() - startTime;
                long startsize = sstable.length();
                long endsize = newSstable.length();
                double ratio = (double)endsize / (double)startsize;
                logger.info(String.format(format, writer.getFilename(), startsize, endsize, (int)(ratio * 100.0), totalkeysWritten, dTime));
            }
            cfs.indexManager.flushIndexes();
            cfs.replaceCompactedSSTables(Arrays.asList(sstable), results);
        }
    }

    private SSTableWriter maybeCreateWriter(ColumnFamilyStore cfs, String compactionFileLocation, int expectedBloomFilterSize, SSTableWriter writer, Collection<SSTableReader> sstables) throws IOException {
        if (writer == null) {
            FileUtils.createDirectory(compactionFileLocation);
            writer = cfs.createCompactionWriter(expectedBloomFilterSize, compactionFileLocation, sstables);
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doValidationCompaction(ColumnFamilyStore cfs, AntiEntropyService.Validator validator) throws IOException {
        try {
            StorageService.instance.forceTableFlush(cfs.table.name, cfs.getColumnFamilyName());
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        Collection<SSTableReader> sstables = cfs.markCurrentSSTablesReferenced();
        ValidationCompactionIterable ci = new ValidationCompactionIterable(cfs, sstables, validator.request.range);
        Iterator iter = ci.iterator();
        this.validationExecutor.beginCompaction(ci);
        try {
            UnmodifiableIterator nni = Iterators.filter((Iterator)iter, (Predicate)Predicates.notNull());
            validator.prepare(cfs);
            while (nni.hasNext()) {
                AbstractCompactedRow row = (AbstractCompactedRow)nni.next();
                validator.add(row);
            }
            validator.complete();
        }
        finally {
            SSTableReader.releaseReferences(sstables);
            iter.close();
            this.validationExecutor.finishCompaction(ci);
        }
    }

    public Future<?> submitIndexBuild(final SecondaryIndexBuilder builder) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CompactionManager.this.compactionLock.readLock().lock();
                try {
                    CompactionManager.this.executor.beginCompaction(builder);
                    try {
                        builder.build();
                    }
                    finally {
                        CompactionManager.this.executor.finishCompaction(builder);
                    }
                }
                finally {
                    CompactionManager.this.compactionLock.readLock().unlock();
                }
            }
        };
        if (this.compactionLock.isWriteLockedByCurrentThread()) {
            return new SimpleFuture(runnable);
        }
        return this.executor.submit(runnable);
    }

    public Future<?> submitCacheWrite(final AutoSavingCache.Writer writer) {
        WrappedRunnable runnable = new WrappedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runMayThrow() throws IOException {
                if (!AutoSavingCache.flushInProgress.compareAndSet(false, true)) {
                    logger.debug("Cache flushing was already in progress: skipping {}", (Object)writer.getCompactionInfo());
                    return;
                }
                try {
                    CompactionManager.this.executor.beginCompaction(writer);
                    try {
                        writer.saveCache();
                    }
                    finally {
                        CompactionManager.this.executor.finishCompaction(writer);
                    }
                }
                finally {
                    AutoSavingCache.flushInProgress.set(false);
                }
            }
        };
        return this.executor.submit(runnable);
    }

    public Future<?> submitTruncate(final ColumnFamilyStore main, final long truncatedAt) {
        WrappedRunnable runnable = new WrappedRunnable(){

            @Override
            public void runMayThrow() throws InterruptedException, IOException {
                for (ColumnFamilyStore cfs : main.concatWithIndexes()) {
                    ArrayList<SSTableReader> truncatedSSTables = new ArrayList<SSTableReader>();
                    for (SSTableReader sstable : cfs.getSSTables()) {
                        if (sstable.newSince(truncatedAt)) continue;
                        truncatedSSTables.add(sstable);
                    }
                    cfs.markCompacted(truncatedSSTables);
                }
                main.invalidateRowCache();
            }
        };
        return this.executor.submit(runnable);
    }

    static int getDefaultGcBefore(ColumnFamilyStore cfs) {
        return cfs.isIndex() ? Integer.MAX_VALUE : (int)(System.currentTimeMillis() / 1000L) - cfs.metadata.getGcGraceSeconds();
    }

    public int getActiveCompactions() {
        return this.executor.getActiveCount() + this.validationExecutor.getActiveCount();
    }

    @Override
    public List<CompactionInfo> getCompactions() {
        ArrayList<CompactionInfo> out = new ArrayList<CompactionInfo>();
        for (CompactionInfo.Holder ci : CompactionExecutor.getCompactions()) {
            out.add(ci.getCompactionInfo());
        }
        return out;
    }

    @Override
    public List<String> getCompactionSummary() {
        ArrayList<String> out = new ArrayList<String>();
        for (CompactionInfo.Holder ci : CompactionExecutor.getCompactions()) {
            out.add(ci.getCompactionInfo().toString());
        }
        return out;
    }

    @Override
    public int getPendingTasks() {
        int n = 0;
        for (String tableName : Schema.instance.getTables()) {
            for (ColumnFamilyStore cfs : Table.open(tableName).getColumnFamilyStores()) {
                n += cfs.getCompactionStrategy().getEstimatedRemainingTasks();
            }
        }
        return (int)(this.executor.getTaskCount() + this.validationExecutor.getTaskCount() - this.executor.getCompletedTaskCount() - this.validationExecutor.getCompletedTaskCount()) + n;
    }

    @Override
    public long getCompletedTasks() {
        return this.executor.getCompletedTaskCount() + this.validationExecutor.getCompletedTaskCount();
    }

    static {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(instance, new ObjectName(MBEAN_OBJECT_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class ScrubInfo
    implements CompactionInfo.Holder {
        private final RandomAccessReader dataFile;
        private final SSTableReader sstable;

        public ScrubInfo(RandomAccessReader dataFile, SSTableReader sstable) {
            this.dataFile = dataFile;
            this.sstable = sstable;
        }

        @Override
        public CompactionInfo getCompactionInfo() {
            try {
                return new CompactionInfo(this.hashCode(), this.sstable.descriptor.ksname, this.sstable.descriptor.cfname, OperationType.SCRUB, this.dataFile.getFilePointer(), this.dataFile.length());
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }
    }

    private static class CleanupInfo
    implements CompactionInfo.Holder {
        private final SSTableReader sstable;
        private final SSTableScanner scanner;

        public CleanupInfo(SSTableReader sstable, SSTableScanner scanner) {
            this.sstable = sstable;
            this.scanner = scanner;
        }

        @Override
        public CompactionInfo getCompactionInfo() {
            try {
                return new CompactionInfo(this.hashCode(), this.sstable.descriptor.ksname, this.sstable.descriptor.cfname, OperationType.CLEANUP, this.scanner.getFilePointer(), this.scanner.getFileLength());
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }
    }

    private static class SimpleFuture
    implements Future {
        private Runnable runnable;

        private SimpleFuture(Runnable r) {
            this.runnable = r;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new IllegalStateException("May not call SimpleFuture.cancel()");
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.runnable == null;
        }

        public Object get() throws InterruptedException, ExecutionException {
            this.runnable.run();
            this.runnable = null;
            return this.runnable;
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new IllegalStateException("May not call SimpleFuture.get(long, TimeUnit)");
        }
    }

    public static interface CompactionExecutorStatsCollector {
        public void beginCompaction(CompactionInfo.Holder var1);

        public void finishCompaction(CompactionInfo.Holder var1);
    }

    private static class ValidationExecutor
    extends CompactionExecutor {
        public ValidationExecutor() {
            super(1, Integer.MAX_VALUE, "ValidationExecutor", new SynchronousQueue<Runnable>());
        }
    }

    private static class CompactionExecutor
    extends DebuggableThreadPoolExecutor
    implements CompactionExecutorStatsCollector {
        private static final Set<CompactionInfo.Holder> compactions = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));

        protected CompactionExecutor(int minThreads, int maxThreads, String name, BlockingQueue<Runnable> queue) {
            super(minThreads, maxThreads, 60L, TimeUnit.SECONDS, queue, new NamedThreadFactory(name));
        }

        private CompactionExecutor(int threadCount, String name) {
            this(threadCount, threadCount, name, new LinkedBlockingQueue<Runnable>());
        }

        public CompactionExecutor() {
            this(Math.max(1, DatabaseDescriptor.getConcurrentCompactors()), "CompactionExecutor");
        }

        @Override
        public void beginCompaction(CompactionInfo.Holder ci) {
            compactions.add(ci);
        }

        @Override
        public void finishCompaction(CompactionInfo.Holder ci) {
            compactions.remove(ci);
        }

        public static List<CompactionInfo.Holder> getCompactions() {
            return new ArrayList<CompactionInfo.Holder>(compactions);
        }
    }

    private static class ValidationCompactionIterable
    extends CompactionIterable {
        public ValidationCompactionIterable(ColumnFamilyStore cfs, Collection<SSTableReader> sstables, Range range) throws IOException {
            super(OperationType.VALIDATION, ValidationCompactionIterable.getScanners(sstables, range), new CompactionController(cfs, sstables, CompactionManager.getDefaultGcBefore(cfs), true));
        }

        protected static List<SSTableScanner> getScanners(Iterable<SSTableReader> sstables, Range range) throws IOException {
            ArrayList<SSTableScanner> scanners = new ArrayList<SSTableScanner>();
            for (SSTableReader sstable : sstables) {
                scanners.add(sstable.getDirectScanner(range));
            }
            return scanners;
        }
    }
}

