/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.cql.jdbc.AbstractJdbcType;
import org.apache.cassandra.cql.jdbc.JdbcAscii;
import org.apache.cassandra.cql.jdbc.JdbcBoolean;
import org.apache.cassandra.cql.jdbc.JdbcBytes;
import org.apache.cassandra.cql.jdbc.JdbcCounterColumn;
import org.apache.cassandra.cql.jdbc.JdbcDate;
import org.apache.cassandra.cql.jdbc.JdbcDecimal;
import org.apache.cassandra.cql.jdbc.JdbcDouble;
import org.apache.cassandra.cql.jdbc.JdbcFloat;
import org.apache.cassandra.cql.jdbc.JdbcInt32;
import org.apache.cassandra.cql.jdbc.JdbcInteger;
import org.apache.cassandra.cql.jdbc.JdbcLexicalUUID;
import org.apache.cassandra.cql.jdbc.JdbcLong;
import org.apache.cassandra.cql.jdbc.JdbcTimeUUID;
import org.apache.cassandra.cql.jdbc.JdbcUTF8;
import org.apache.cassandra.cql.jdbc.JdbcUUID;

public class TypesMap {
    private static final Map<String, AbstractJdbcType<?>> map = new HashMap();

    public static AbstractJdbcType<?> getTypeForComparator(String comparator) {
        if (comparator != null && !comparator.contains(".")) {
            return map.get("org.apache.cassandra.db.marshal." + comparator);
        }
        return map.get(comparator);
    }

    static {
        map.put("org.apache.cassandra.db.marshal.AsciiType", JdbcAscii.instance);
        map.put("org.apache.cassandra.db.marshal.BooleanType", JdbcBoolean.instance);
        map.put("org.apache.cassandra.db.marshal.BytesType", JdbcBytes.instance);
        map.put("org.apache.cassandra.db.marshal.ColumnCounterType", JdbcCounterColumn.instance);
        map.put("org.apache.cassandra.db.marshal.DateType", JdbcDate.instance);
        map.put("org.apache.cassandra.db.marshal.DecimalType", JdbcDecimal.instance);
        map.put("org.apache.cassandra.db.marshal.DoubleType", JdbcDouble.instance);
        map.put("org.apache.cassandra.db.marshal.FloatType", JdbcFloat.instance);
        map.put("org.apache.cassandra.db.marshal.Int32Type", JdbcInt32.instance);
        map.put("org.apache.cassandra.db.marshal.IntegerType", JdbcInteger.instance);
        map.put("org.apache.cassandra.db.marshal.LexicalUUIDType", JdbcLexicalUUID.instance);
        map.put("org.apache.cassandra.db.marshal.LongType", JdbcLong.instance);
        map.put("org.apache.cassandra.db.marshal.TimeUUIDType", JdbcTimeUUID.instance);
        map.put("org.apache.cassandra.db.marshal.UTF8Type", JdbcUTF8.instance);
        map.put("org.apache.cassandra.db.marshal.UUIDType", JdbcUUID.instance);
    }
}

