/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.db.marshal.AbstractCompositeType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class CompositeType
extends AbstractCompositeType {
    public final List<AbstractType<?>> types;
    private static final Map<List<AbstractType<?>>, CompositeType> instances = new HashMap();

    public static CompositeType getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        return CompositeType.getInstance(parser.getTypeParameters());
    }

    public static synchronized CompositeType getInstance(List<AbstractType<?>> types) {
        assert (types != null && !types.isEmpty());
        CompositeType ct = instances.get(types);
        if (ct == null) {
            ct = new CompositeType(types);
            instances.put(types, ct);
        }
        return ct;
    }

    private CompositeType(List<AbstractType<?>> types) {
        this.types = ImmutableList.copyOf(types);
    }

    @Override
    protected AbstractType<?> getComparator(int i, ByteBuffer bb) {
        return this.types.get(i);
    }

    @Override
    protected AbstractType<?> getComparator(int i, ByteBuffer bb1, ByteBuffer bb2) {
        return this.types.get(i);
    }

    @Override
    protected AbstractType<?> getAndAppendComparator(int i, ByteBuffer bb, StringBuilder sb) {
        return this.types.get(i);
    }

    @Override
    protected AbstractCompositeType.ParsedComparator parseComparator(int i, String part) {
        return new StaticParsedComparator(this.types.get(i), part);
    }

    @Override
    protected AbstractType<?> validateComparator(int i, ByteBuffer bb) throws MarshalException {
        if (i >= this.types.size()) {
            throw new MarshalException("Too many bytes for comparator");
        }
        return this.types.get(i);
    }

    @Override
    public ByteBuffer decompose(Object ... objects) {
        assert (objects.length == this.types.size());
        ByteBuffer[] serialized = new ByteBuffer[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            ByteBuffer buffer;
            serialized[i] = buffer = this.types.get(i).decompose(objects[i]);
        }
        return this.build(serialized);
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        if (this == previous) {
            return true;
        }
        if (!(previous instanceof CompositeType)) {
            return false;
        }
        CompositeType cp = (CompositeType)previous;
        if (this.types.size() < cp.types.size()) {
            return false;
        }
        for (int i = 0; i < cp.types.size(); ++i) {
            AbstractType<?> tprev = cp.types.get(i);
            AbstractType<?> tnew = this.types.get(i);
            if (tnew.isCompatibleWith(tprev)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + TypeParser.stringifyTypeParameters(this.types);
    }

    public Builder builder() {
        return new Builder(this);
    }

    public ByteBuffer build(ByteBuffer ... buffers) {
        int totalLength = 0;
        for (ByteBuffer bb : buffers) {
            totalLength += 2 + bb.remaining() + 1;
        }
        ByteBuffer out = ByteBuffer.allocate(totalLength);
        for (ByteBuffer bb : buffers) {
            CompositeType.putShortLength(out, bb.remaining());
            out.put(bb);
            out.put((byte)0);
        }
        out.flip();
        return out;
    }

    public static class Builder
    implements ColumnNameBuilder {
        private final CompositeType composite;
        private final List<ByteBuffer> components;
        private final byte[] endOfComponents;
        private int serializedSize;

        public Builder(CompositeType composite) {
            this(composite, new ArrayList<ByteBuffer>(composite.types.size()), new byte[composite.types.size()]);
        }

        public Builder(CompositeType composite, List<ByteBuffer> components, byte[] endOfComponents) {
            assert (endOfComponents.length == composite.types.size());
            this.composite = composite;
            this.components = components;
            this.endOfComponents = endOfComponents;
        }

        private Builder(Builder b) {
            this(b.composite, new ArrayList<ByteBuffer>(b.components), Arrays.copyOf(b.endOfComponents, b.endOfComponents.length));
            this.serializedSize = b.serializedSize;
        }

        @Override
        public Builder add(ByteBuffer buffer, Relation.Type op) {
            if (this.components.size() >= this.composite.types.size()) {
                throw new IllegalStateException("Composite column is already fully constructed");
            }
            int current = this.components.size();
            this.components.add(buffer);
            switch (op) {
                case LT: {
                    this.endOfComponents[current] = -1;
                    break;
                }
                case GT: 
                case LTE: {
                    this.endOfComponents[current] = 1;
                    break;
                }
                default: {
                    this.endOfComponents[current] = 0;
                }
            }
            return this;
        }

        @Override
        public Builder add(ByteBuffer bb) {
            return this.add(bb, Relation.Type.EQ);
        }

        @Override
        public int componentCount() {
            return this.components.size();
        }

        @Override
        public int remainingCount() {
            return this.composite.types.size() - this.components.size();
        }

        @Override
        public ByteBuffer build() {
            DataOutputBuffer out = new DataOutputBuffer(this.serializedSize);
            for (int i = 0; i < this.components.size(); ++i) {
                try {
                    ByteBufferUtil.writeWithShortLength(this.components.get(i), out);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                out.write(this.endOfComponents[i]);
            }
            return ByteBuffer.wrap(out.getData(), 0, out.getLength());
        }

        @Override
        public ByteBuffer buildAsEndOfRange() {
            if (this.components.isEmpty()) {
                return ByteBufferUtil.EMPTY_BYTE_BUFFER;
            }
            ByteBuffer bb = this.build();
            bb.put(bb.remaining() - 1, (byte)1);
            return bb;
        }

        @Override
        public Builder copy() {
            return new Builder(this);
        }
    }

    private static class StaticParsedComparator
    implements AbstractCompositeType.ParsedComparator {
        final AbstractType<?> type;
        final String part;

        StaticParsedComparator(AbstractType<?> type, String part) {
            this.type = type;
            this.part = part;
        }

        @Override
        public AbstractType<?> getAbstractType() {
            return this.type;
        }

        @Override
        public String getRemainingPart() {
            return this.part;
        }

        @Override
        public int getComparatorSerializedSize() {
            return 0;
        }

        @Override
        public void serializeComparator(ByteBuffer bb) {
        }
    }
}

