/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql.jdbc.AbstractJdbcType;
import org.apache.cassandra.cql.jdbc.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class JdbcDouble
extends AbstractJdbcType<Double> {
    public static final JdbcDouble instance = new JdbcDouble();

    JdbcDouble() {
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public int getScale(Double obj) {
        return 300;
    }

    @Override
    public int getPrecision(Double obj) {
        return 15;
    }

    @Override
    public boolean isCurrency() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public String toString(Double obj) {
        return obj.toString();
    }

    @Override
    public boolean needsQuotes() {
        return false;
    }

    @Override
    public String getString(ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return "";
        }
        if (bytes.remaining() != 8) {
            throw new MarshalException("A double is exactly 8 bytes : " + bytes.remaining());
        }
        return Double.valueOf(ByteBufferUtil.toDouble(bytes)).toString();
    }

    @Override
    public Class<Double> getType() {
        return Double.class;
    }

    @Override
    public int getJdbcType() {
        return 8;
    }

    @Override
    public Double compose(ByteBuffer bytes) {
        return ByteBufferUtil.toDouble(bytes);
    }

    @Override
    public ByteBuffer decompose(Double value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBufferUtil.bytes(value);
    }
}

