/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.kafka;

import org.apache.calcite.adapter.kafka.KafkaRowConverter;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class KafkaRowConverterImpl
implements KafkaRowConverter<byte[], byte[]> {
    @Override
    public RelDataType rowDataType(String topicName) {
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataTypeFactory.FieldInfoBuilder fieldInfo = typeFactory.builder();
        fieldInfo.add("MSG_PARTITION", typeFactory.createSqlType(SqlTypeName.INTEGER)).nullable(false);
        fieldInfo.add("MSG_TIMESTAMP", typeFactory.createSqlType(SqlTypeName.BIGINT)).nullable(false);
        fieldInfo.add("MSG_OFFSET", typeFactory.createSqlType(SqlTypeName.BIGINT)).nullable(false);
        fieldInfo.add("MSG_KEY_BYTES", typeFactory.createSqlType(SqlTypeName.VARBINARY)).nullable(true);
        fieldInfo.add("MSG_VALUE_BYTES", typeFactory.createSqlType(SqlTypeName.VARBINARY)).nullable(false);
        return fieldInfo.build();
    }

    @Override
    public Object[] toRow(ConsumerRecord<byte[], byte[]> message) {
        Object[] fields = new Object[]{message.partition(), message.timestamp(), message.offset(), message.key(), message.value()};
        return fields;
    }
}

