/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.file;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.file.FileSchema;
import org.apache.calcite.model.ModelHandler;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;

public class FileSchemaFactory
implements SchemaFactory {
    public static final FileSchemaFactory INSTANCE = new FileSchemaFactory();
    static final String ROWTIME_COLUMN_NAME = "ROWTIME";

    private FileSchemaFactory() {
    }

    public Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
        List tables = (List)operand.get("tables");
        File baseDirectory = (File)operand.get(ModelHandler.ExtraOperand.BASE_DIRECTORY.camelName);
        String directory = (String)operand.get("directory");
        File directoryFile = null;
        if (directory != null) {
            directoryFile = new File(directory);
        }
        if (baseDirectory != null) {
            if (directoryFile == null) {
                directoryFile = baseDirectory;
            } else if (!directoryFile.isAbsolute()) {
                directoryFile = new File(baseDirectory, directory);
            }
        }
        return new FileSchema(parentSchema, name, directoryFile, tables);
    }
}

