/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.file;

import com.google.common.collect.ImmutableMap;
import com.joestelmach.natty.DateGroup;
import com.joestelmach.natty.Parser;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.adapter.file.FileFieldType;
import org.apache.calcite.adapter.file.FileReader;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

class FileRowConverter {
    private final FileReader fileReader;
    private final @Nullable List<Map<String, Object>> fieldConfigs;
    private boolean initialized = false;
    private final List<FieldDef> fields = new ArrayList<FieldDef>();
    private final NumberFormat numberFormat = NumberFormat.getInstance(Locale.ROOT);
    private final NumberFormat integerFormat = NumberFormat.getIntegerInstance(Locale.ROOT);

    FileRowConverter(FileReader fileReader, List<Map<String, Object>> fieldConfigs) {
        this.fileReader = fileReader;
        this.fieldConfigs = fieldConfigs;
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        try {
            Elements headerElements = this.fileReader.getHeadings();
            LinkedHashMap<String, Integer> headerMap = new LinkedHashMap<String, Integer>();
            int i = 0;
            for (Element th : headerElements) {
                String heading = th.text();
                if (headerMap.containsKey(heading)) {
                    throw new Exception("duplicate heading: '" + (String)heading + "'");
                }
                headerMap.put(heading, i++);
            }
            HashSet<String> colNames = new HashSet<String>();
            HashSet<String> sources = new HashSet<String>();
            if (this.fieldConfigs != null) {
                try {
                    for (Map map : this.fieldConfigs) {
                        String sSkip;
                        String thName;
                        String name = thName = (String)map.get("th");
                        FileFieldType type = null;
                        boolean skip = false;
                        if (!headerMap.containsKey(thName)) {
                            throw new Exception("bad source column name: '" + thName + "'");
                        }
                        String newName = (String)map.get("name");
                        if (newName != null) {
                            name = newName;
                        }
                        if (colNames.contains(name)) {
                            throw new Exception("duplicate column name: '" + name + "'");
                        }
                        String typeString = (String)map.get("type");
                        if (typeString != null) {
                            type = FileFieldType.of(typeString);
                        }
                        if ((sSkip = (String)map.get("skip")) != null) {
                            skip = Boolean.parseBoolean(sSkip);
                        }
                        Integer sourceIx = (Integer)headerMap.get(thName);
                        colNames.add(name);
                        sources.add(thName);
                        if (skip) continue;
                        this.addFieldDef(name, type, map, sourceIx);
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            for (Map.Entry entry : headerMap.entrySet()) {
                String name = (String)entry.getKey();
                if (sources.contains(name) || colNames.contains(name)) continue;
                this.addFieldDef(name, null, (Map<String, Object>)ImmutableMap.of(), (Integer)entry.getValue());
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.initialized = true;
    }

    private void addFieldDef(String name, @Nullable FileFieldType type, Map<String, Object> config, int sourceCol) {
        this.fields.add(new FieldDef(name, type, config, sourceCol));
    }

    Object toRow(Elements rowElements, int[] projection) {
        this.initialize();
        Object[] objects = new Object[projection.length];
        for (int i = 0; i < projection.length; ++i) {
            int field = projection[i];
            objects[i] = this.fields.get(field).convert(rowElements);
        }
        return objects;
    }

    int width() {
        this.initialize();
        return this.fields.size();
    }

    RelDataType getRowType(JavaTypeFactory typeFactory) {
        this.initialize();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        for (FieldDef f : this.fields) {
            names.add(f.getName());
            @Nullable FileFieldType fieldType = f.getType();
            RelDataType type = fieldType == null ? typeFactory.createJavaType(String.class) : fieldType.toType(typeFactory);
            types.add(type);
        }
        if (names.isEmpty()) {
            names.add("line");
            types.add(typeFactory.createJavaType(String.class));
        }
        return typeFactory.createStructType(Pair.zip(names, types));
    }

    private class FieldDef {
        final String name;
        final @Nullable FileFieldType type;
        final Map<String, Object> config;
        final CellReader cellReader;
        final int cellSeq;

        FieldDef(@Nullable String name, FileFieldType type, Map<String, Object> config, int cellSeq) {
            this.name = Objects.requireNonNull(name, "name");
            this.type = type;
            this.config = Objects.requireNonNull(config, "config");
            this.cellReader = new CellReader(config);
            this.cellSeq = cellSeq;
        }

        @Nullable Object convert(Elements row) {
            return this.toObject(this.type, this.cellReader.read((Element)row.get(this.cellSeq)));
        }

        public String getName() {
            return this.name;
        }

        @Nullable FileFieldType getType() {
            return this.type;
        }

        private java.util.Date parseDate(String string) {
            Parser parser = new Parser(DateTimeUtils.UTC_ZONE);
            List groups = parser.parse(string);
            DateGroup group = (DateGroup)groups.get(0);
            return (java.util.Date)group.getDates().get(0);
        }

        private @Nullable Object toObject(@Nullable FileFieldType fieldType, @Nullable String string) {
            if (string == null || string.isEmpty()) {
                return null;
            }
            if (fieldType == null) {
                return string;
            }
            switch (fieldType) {
                case BOOLEAN: {
                    return Boolean.parseBoolean(string);
                }
                case BYTE: {
                    return Byte.parseByte(string);
                }
                case SHORT: {
                    try {
                        return FileRowConverter.this.integerFormat.parse(string).shortValue();
                    }
                    catch (ParseException e) {
                        return null;
                    }
                }
                case INT: {
                    try {
                        return FileRowConverter.this.integerFormat.parse(string).intValue();
                    }
                    catch (ParseException e) {
                        return null;
                    }
                }
                case LONG: {
                    try {
                        return FileRowConverter.this.numberFormat.parse(string).longValue();
                    }
                    catch (ParseException e) {
                        return null;
                    }
                }
                case FLOAT: {
                    try {
                        return Float.valueOf(FileRowConverter.this.numberFormat.parse(string).floatValue());
                    }
                    catch (ParseException e) {
                        return null;
                    }
                }
                case DOUBLE: {
                    try {
                        return FileRowConverter.this.numberFormat.parse(string).doubleValue();
                    }
                    catch (ParseException e) {
                        return null;
                    }
                }
                case DATE: {
                    return new Date(this.parseDate(string).getTime());
                }
                case TIME: {
                    return new Time(this.parseDate(string).getTime());
                }
                case TIMESTAMP: {
                    return new Timestamp(this.parseDate(string).getTime());
                }
            }
            return string;
        }
    }

    private static class CellReader {
        private final String selector;
        private final @Nullable Integer selectedElement;
        private final @Nullable Pattern replacePattern;
        private final String replaceWith;
        private final @Nullable Pattern matchPattern;
        private final int matchSeq;

        CellReader(Map<String, Object> config) {
            @Nullable String unusedType = (String)config.get("type");
            this.selector = (String)Util.first((Object)((String)config.get("selector")), (Object)"*");
            this.selectedElement = (Integer)config.get("selectedElement");
            @Nullable String replace = (String)config.get("replace");
            this.replacePattern = replace == null ? null : Pattern.compile(replace);
            this.replaceWith = (String)Util.first((Object)((String)config.get("replaceWith")), (Object)"");
            @Nullable String match = (String)config.get("match");
            this.matchPattern = match == null ? null : Pattern.compile(match);
            this.matchSeq = Util.first((Integer)((Integer)config.get("matchSeq")), (int)0);
        }

        @Nullable String read(Element cell) {
            ArrayList<String> cellText = new ArrayList<String>();
            if (this.selectedElement != null) {
                cellText.add(((Element)cell.select(this.selector).get(this.selectedElement.intValue())).ownText());
            } else {
                for (Element child : cell.select(this.selector)) {
                    cellText.add(child.ownText());
                }
            }
            String cellString = String.join((CharSequence)" ", cellText).trim();
            if (this.replacePattern != null) {
                Matcher m = this.replacePattern.matcher(cellString);
                cellString = m.replaceAll(this.replaceWith);
            }
            if (this.matchPattern == null) {
                return cellString;
            }
            ArrayList<String> allMatches = new ArrayList<String>();
            Matcher m = this.matchPattern.matcher(cellString);
            while (m.find()) {
                allMatches.add(m.group());
            }
            if (!allMatches.isEmpty()) {
                return (String)allMatches.get(this.matchSeq);
            }
            return null;
        }
    }
}

