/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.file;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.file.FileTable;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;

class FileTableScan
extends TableScan
implements EnumerableRel {
    private final FileTable webTable;
    private final int[] fields;

    protected FileTableScan(RelOptCluster cluster, RelOptTable table, FileTable webTable, int[] fields) {
        super(cluster, cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE), (List)ImmutableList.of(), table);
        this.webTable = webTable;
        this.fields = fields;
        assert (webTable != null);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return new FileTableScan(this.getCluster(), this.table, this.webTable, this.fields);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("fields", (Object)Primitive.asList((int[])this.fields));
    }

    public RelDataType deriveRowType() {
        List fieldList = this.table.getRowType().getFieldList();
        RelDataTypeFactory.FieldInfoBuilder builder = this.getCluster().getTypeFactory().builder();
        for (int field : this.fields) {
            builder.add((RelDataTypeField)fieldList.get(field));
        }
        return builder.build();
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.getRowType(), (JavaRowFormat)pref.preferArray());
        return implementor.result(physType, Blocks.toBlock((Node)Expressions.call((Expression)this.table.getExpression(FileTable.class), (String)"project", (Expression[])new Expression[]{Expressions.constant((Object)this.fields)})));
    }
}

