/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.csv;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;

class JsonEnumerator
implements Enumerator<Object[]> {
    private final Enumerator<Object> enumerator;

    public JsonEnumerator(File file) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            List list = (List)mapper.readValue(file, List.class);
            this.enumerator = Linq4j.enumerator((Collection)list);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Object[] current() {
        return new Object[]{this.enumerator.current()};
    }

    public boolean moveNext() {
        return this.enumerator.moveNext();
    }

    public void reset() {
        this.enumerator.reset();
    }

    public void close() {
        try {
            this.enumerator.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Error closing JSON reader", e);
        }
    }
}

