/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.csv;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.csv.CsvEnumerator;
import org.apache.calcite.adapter.csv.CsvFieldType;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.impl.AbstractTable;

public abstract class CsvTable
extends AbstractTable {
    protected final File file;
    protected final RelProtoDataType protoRowType;
    protected List<CsvFieldType> fieldTypes;

    CsvTable(File file, RelProtoDataType protoRowType) {
        this.file = file;
        this.protoRowType = protoRowType;
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.protoRowType != null) {
            return (RelDataType)this.protoRowType.apply((Object)typeFactory);
        }
        if (this.fieldTypes == null) {
            this.fieldTypes = new ArrayList<CsvFieldType>();
            return CsvEnumerator.deduceRowType((JavaTypeFactory)typeFactory, this.file, this.fieldTypes);
        }
        return CsvEnumerator.deduceRowType((JavaTypeFactory)typeFactory, this.file, null);
    }

    public static enum Flavor {
        SCANNABLE,
        FILTERABLE,
        TRANSLATABLE;

    }
}

