/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.csv;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.csv.CsvEnumerator;
import org.apache.calcite.adapter.csv.CsvScannableTable;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.StreamableTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.util.Source;

public class CsvStreamScannableTable
extends CsvScannableTable
implements StreamableTable {
    CsvStreamScannableTable(Source source, RelProtoDataType protoRowType) {
        super(source, protoRowType);
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.protoRowType != null) {
            return (RelDataType)this.protoRowType.apply((Object)typeFactory);
        }
        if (this.fieldTypes == null) {
            this.fieldTypes = new ArrayList();
            return CsvEnumerator.deduceRowType((JavaTypeFactory)typeFactory, this.source, this.fieldTypes, true);
        }
        return CsvEnumerator.deduceRowType((JavaTypeFactory)typeFactory, this.source, null, true);
    }

    @Override
    public String toString() {
        return "CsvStreamScannableTable";
    }

    @Override
    public Enumerable<Object[]> scan(DataContext root) {
        final int[] fields = CsvEnumerator.identityList(this.fieldTypes.size());
        final AtomicBoolean cancelFlag = (AtomicBoolean)DataContext.Variable.CANCEL_FLAG.get(root);
        return new AbstractEnumerable<Object[]>(){

            public Enumerator<Object[]> enumerator() {
                return new CsvEnumerator<Object[]>(CsvStreamScannableTable.this.source, cancelFlag, true, null, new CsvEnumerator.ArrayRowConverter(CsvStreamScannableTable.this.fieldTypes, fields, true));
            }
        };
    }

    public Table stream() {
        return this;
    }
}

