/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.csv;

import java.util.List;
import org.apache.calcite.adapter.csv.CsvProjectTableScanRule;
import org.apache.calcite.adapter.csv.CsvTranslatableTable;
import org.apache.calcite.adapter.csv.JsonTable;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvTableScan
extends TableScan
implements EnumerableRel {
    final CsvTranslatableTable csvTable;
    final int[] fields;

    protected CsvTableScan(RelOptCluster cluster, RelOptTable table, CsvTranslatableTable csvTable, int[] fields) {
        super(cluster, cluster.traitSetOf(new RelTrait[]{EnumerableConvention.INSTANCE}), table);
        this.csvTable = csvTable;
        this.fields = fields;
        assert (csvTable != null);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return new CsvTableScan(this.getCluster(), this.table, this.csvTable, this.fields);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("fields", (Object)Primitive.asList((int[])this.fields));
    }

    public RelDataType deriveRowType() {
        List fieldList = this.table.getRowType().getFieldList();
        RelDataTypeFactory.FieldInfoBuilder builder = this.getCluster().getTypeFactory().builder();
        for (int field : this.fields) {
            builder.add((RelDataTypeField)fieldList.get(field));
        }
        return builder.build();
    }

    public void register(RelOptPlanner planner) {
        planner.addRule((RelOptRule)CsvProjectTableScanRule.INSTANCE);
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.getRowType(), (JavaRowFormat)pref.preferArray());
        if (this.table instanceof JsonTable) {
            return implementor.result(physType, Blocks.toBlock((Node)Expressions.call((Expression)this.table.getExpression(JsonTable.class), (String)"enumerable", (Expression[])new Expression[0])));
        }
        return implementor.result(physType, Blocks.toBlock((Node)Expressions.call((Expression)this.table.getExpression(CsvTranslatableTable.class), (String)"project", (Expression[])new Expression[]{Expressions.constant((Object)this.fields)})));
    }
}

