/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchConstants;
import org.apache.calcite.adapter.elasticsearch.QueryBuilders;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Sarg;

class PredicateAnalyzer {
    private PredicateAnalyzer() {
    }

    static QueryBuilders.QueryBuilder analyze(RexNode expression) throws ExpressionNotAnalyzableException {
        Objects.requireNonNull(expression, "expression");
        try {
            QueryExpression e = (QueryExpression)expression.accept((RexVisitor)new Visitor());
            if (e != null && e.isPartial()) {
                throw new UnsupportedOperationException("Can't handle partial QueryExpression: " + e);
            }
            return e != null ? e.builder() : null;
        }
        catch (Throwable e) {
            Throwables.propagateIfPossible((Throwable)e, UnsupportedOperationException.class);
            throw new ExpressionNotAnalyzableException("Can't convert " + expression, e);
        }
    }

    private static QueryBuilders.RangeQueryBuilder addFormatIfNecessary(LiteralExpression literal, QueryBuilders.RangeQueryBuilder rangeQueryBuilder) {
        if (literal.value() instanceof GregorianCalendar) {
            rangeQueryBuilder.format("date_time");
        }
        return rangeQueryBuilder;
    }

    private static void checkForIncompatibleDateTimeOperands(RexCall call) {
        RelDataType op1 = ((RexNode)call.getOperands().get(0)).getType();
        RelDataType op2 = ((RexNode)call.getOperands().get(1)).getType();
        if (SqlTypeFamily.DATETIME.contains(op1) && !SqlTypeFamily.DATETIME.contains(op2) || SqlTypeFamily.DATETIME.contains(op2) && !SqlTypeFamily.DATETIME.contains(op1) || SqlTypeFamily.DATE.contains(op1) && !SqlTypeFamily.DATE.contains(op2) || SqlTypeFamily.DATE.contains(op2) && !SqlTypeFamily.DATE.contains(op1) || SqlTypeFamily.TIMESTAMP.contains(op1) && !SqlTypeFamily.TIMESTAMP.contains(op2) || SqlTypeFamily.TIMESTAMP.contains(op2) && !SqlTypeFamily.TIMESTAMP.contains(op1) || SqlTypeFamily.TIME.contains(op1) && !SqlTypeFamily.TIME.contains(op2) || SqlTypeFamily.TIME.contains(op2) && !SqlTypeFamily.TIME.contains(op1)) {
            throw new PredicateAnalyzerException("Cannot handle " + call.getKind() + " expression for _id field, " + call);
        }
    }

    static final class LiteralExpression
    implements TerminalExpression {
        final RexLiteral literal;

        LiteralExpression(RexLiteral literal) {
            this.literal = literal;
        }

        Object value() {
            if (this.isSarg()) {
                return this.sargValue();
            }
            if (this.isIntegral()) {
                return this.longValue();
            }
            if (this.isFloatingPoint()) {
                return this.doubleValue();
            }
            if (this.isBoolean()) {
                return this.booleanValue();
            }
            if (this.isString()) {
                return RexLiteral.stringValue((RexNode)this.literal);
            }
            return this.rawValue();
        }

        boolean isIntegral() {
            return SqlTypeName.INT_TYPES.contains(this.literal.getType().getSqlTypeName());
        }

        boolean isFloatingPoint() {
            return SqlTypeName.APPROX_TYPES.contains(this.literal.getType().getSqlTypeName());
        }

        boolean isBoolean() {
            return SqlTypeName.BOOLEAN_TYPES.contains(this.literal.getType().getSqlTypeName());
        }

        public boolean isString() {
            return SqlTypeName.CHAR_TYPES.contains(this.literal.getType().getSqlTypeName());
        }

        public boolean isSarg() {
            return SqlTypeName.SARG.getName().equalsIgnoreCase(this.literal.getTypeName().getName());
        }

        long longValue() {
            return ((Number)((Object)this.literal.getValue())).longValue();
        }

        double doubleValue() {
            return ((Number)((Object)this.literal.getValue())).doubleValue();
        }

        boolean booleanValue() {
            return RexLiteral.booleanValue((RexNode)this.literal);
        }

        String stringValue() {
            return RexLiteral.stringValue((RexNode)this.literal);
        }

        List<Object> sargValue() {
            Sarg sarg = (Sarg)Objects.requireNonNull(this.literal.getValueAs(Sarg.class), "Sarg");
            RelDataType type = this.literal.getType();
            ArrayList<Object> values = new ArrayList<Object>();
            SqlTypeName sqlTypeName = type.getSqlTypeName();
            if (sarg.isPoints()) {
                Set ranges = sarg.rangeSet.asRanges();
                ranges.forEach(range -> values.add(this.sargPointValue(range.lowerEndpoint(), sqlTypeName)));
            } else if (sarg.isComplementedPoints()) {
                Set ranges = sarg.negate().rangeSet.asRanges();
                ranges.forEach(range -> values.add(this.sargPointValue(range.lowerEndpoint(), sqlTypeName)));
            }
            return values;
        }

        Object sargPointValue(Object point, SqlTypeName sqlTypeName) {
            switch (sqlTypeName) {
                case CHAR: 
                case VARCHAR: {
                    return ((NlsString)point).getValue();
                }
            }
            return point;
        }

        Object rawValue() {
            return this.literal.getValue();
        }
    }

    static final class NamedFieldExpression
    implements TerminalExpression {
        private final String name;

        private NamedFieldExpression() {
            this.name = null;
        }

        private NamedFieldExpression(RexInputRef schemaField) {
            this.name = schemaField == null ? null : schemaField.getName();
        }

        private NamedFieldExpression(RexLiteral literal) {
            this.name = literal == null ? null : RexLiteral.stringValue((RexNode)literal);
        }

        String getRootName() {
            return this.name;
        }

        boolean isMetaField() {
            return ElasticsearchConstants.META_COLUMNS.contains(this.getRootName());
        }

        String getReference() {
            return this.getRootName();
        }
    }

    static final class CastExpression
    implements TerminalExpression {
        private final RelDataType type;
        private final TerminalExpression argument;

        private CastExpression(RelDataType type, TerminalExpression argument) {
            this.type = type;
            this.argument = argument;
        }

        public boolean isCastFromLiteral() {
            return this.argument instanceof LiteralExpression;
        }

        static TerminalExpression unpack(TerminalExpression exp) {
            if (!(exp instanceof CastExpression)) {
                return exp;
            }
            return ((CastExpression)exp).argument;
        }

        static boolean isCastExpression(Expression exp) {
            return exp instanceof CastExpression;
        }
    }

    static interface TerminalExpression
    extends Expression {
    }

    static class SimpleQueryExpression
    extends QueryExpression {
        private final NamedFieldExpression rel;
        private QueryBuilders.QueryBuilder builder;

        private String getFieldReference() {
            return this.rel.getReference();
        }

        private SimpleQueryExpression(NamedFieldExpression rel) {
            this.rel = rel;
        }

        @Override
        public QueryBuilders.QueryBuilder builder() {
            if (this.builder == null) {
                throw new IllegalStateException("Builder was not initialized");
            }
            return this.builder;
        }

        @Override
        public QueryExpression not() {
            this.builder = QueryBuilders.boolQuery().mustNot(this.builder());
            return this;
        }

        @Override
        public QueryExpression exists() {
            this.builder = QueryBuilders.existsQuery(this.getFieldReference());
            return this;
        }

        @Override
        public QueryExpression notExists() {
            this.builder = QueryBuilders.boolQuery().mustNot(QueryBuilders.existsQuery(this.getFieldReference()));
            return this;
        }

        @Override
        public QueryExpression like(LiteralExpression literal) {
            this.builder = QueryBuilders.regexpQuery(this.getFieldReference(), literal.stringValue());
            return this;
        }

        @Override
        public QueryExpression contains(LiteralExpression literal) {
            this.builder = QueryBuilders.matchQuery(this.getFieldReference(), literal.value());
            return this;
        }

        @Override
        public QueryExpression notLike(LiteralExpression literal) {
            this.builder = QueryBuilders.boolQuery().must(QueryBuilders.existsQuery(this.getFieldReference())).mustNot(QueryBuilders.regexpQuery(this.getFieldReference(), literal.stringValue()));
            return this;
        }

        @Override
        public QueryExpression equals(LiteralExpression literal) {
            Object value = literal.value();
            this.builder = value instanceof GregorianCalendar ? QueryBuilders.boolQuery().must(PredicateAnalyzer.addFormatIfNecessary(literal, QueryBuilders.rangeQuery(this.getFieldReference()).gte(value))).must(PredicateAnalyzer.addFormatIfNecessary(literal, QueryBuilders.rangeQuery(this.getFieldReference()).lte(value))) : QueryBuilders.termQuery(this.getFieldReference(), value);
            return this;
        }

        @Override
        public QueryExpression notEquals(LiteralExpression literal) {
            Object value = literal.value();
            this.builder = value instanceof GregorianCalendar ? QueryBuilders.boolQuery().should(PredicateAnalyzer.addFormatIfNecessary(literal, QueryBuilders.rangeQuery(this.getFieldReference()).gt(value))).should(PredicateAnalyzer.addFormatIfNecessary(literal, QueryBuilders.rangeQuery(this.getFieldReference()).lt(value))) : QueryBuilders.boolQuery().must(QueryBuilders.existsQuery(this.getFieldReference())).mustNot(QueryBuilders.termQuery(this.getFieldReference(), value));
            return this;
        }

        @Override
        public QueryExpression gt(LiteralExpression literal) {
            Object value = literal.value();
            this.builder = PredicateAnalyzer.addFormatIfNecessary(literal, QueryBuilders.rangeQuery(this.getFieldReference()).gt(value));
            return this;
        }

        @Override
        public QueryExpression gte(LiteralExpression literal) {
            Object value = literal.value();
            this.builder = PredicateAnalyzer.addFormatIfNecessary(literal, QueryBuilders.rangeQuery(this.getFieldReference()).gte(value));
            return this;
        }

        @Override
        public QueryExpression lt(LiteralExpression literal) {
            Object value = literal.value();
            this.builder = PredicateAnalyzer.addFormatIfNecessary(literal, QueryBuilders.rangeQuery(this.getFieldReference()).lt(value));
            return this;
        }

        @Override
        public QueryExpression lte(LiteralExpression literal) {
            Object value = literal.value();
            this.builder = PredicateAnalyzer.addFormatIfNecessary(literal, QueryBuilders.rangeQuery(this.getFieldReference()).lte(value));
            return this;
        }

        @Override
        public QueryExpression queryString(String query) {
            throw new UnsupportedOperationException("QueryExpression not yet supported: " + query);
        }

        @Override
        public QueryExpression isTrue() {
            this.builder = QueryBuilders.termQuery(this.getFieldReference(), true);
            return this;
        }

        @Override
        public QueryExpression in(LiteralExpression literal) {
            Iterable iterable = (Iterable)literal.value();
            this.builder = QueryBuilders.termsQuery(this.getFieldReference(), iterable);
            return this;
        }

        @Override
        public QueryExpression notIn(LiteralExpression literal) {
            Iterable iterable = (Iterable)literal.value();
            this.builder = QueryBuilders.boolQuery().mustNot(QueryBuilders.termsQuery(this.getFieldReference(), iterable));
            return this;
        }
    }

    static class CompoundQueryExpression
    extends QueryExpression {
        private final boolean partial;
        private final QueryBuilders.BoolQueryBuilder builder;

        public static CompoundQueryExpression or(QueryExpression ... expressions) {
            CompoundQueryExpression bqe = new CompoundQueryExpression(false);
            for (QueryExpression expression : expressions) {
                bqe.builder.should(expression.builder());
            }
            return bqe;
        }

        public static CompoundQueryExpression and(boolean partial, QueryExpression ... expressions) {
            CompoundQueryExpression bqe = new CompoundQueryExpression(partial);
            for (QueryExpression expression : expressions) {
                if (expression == null) continue;
                bqe.builder.must(expression.builder());
            }
            return bqe;
        }

        private CompoundQueryExpression(boolean partial) {
            this(partial, QueryBuilders.boolQuery());
        }

        private CompoundQueryExpression(boolean partial, QueryBuilders.BoolQueryBuilder builder) {
            this.partial = partial;
            this.builder = Objects.requireNonNull(builder, "builder");
        }

        @Override
        public boolean isPartial() {
            return this.partial;
        }

        @Override
        public QueryBuilders.QueryBuilder builder() {
            return this.builder;
        }

        @Override
        public QueryExpression not() {
            return new CompoundQueryExpression(this.partial, QueryBuilders.boolQuery().mustNot(this.builder()));
        }

        @Override
        public QueryExpression exists() {
            throw new PredicateAnalyzerException("SqlOperatorImpl ['exists'] cannot be applied to a compound expression");
        }

        @Override
        public QueryExpression contains(LiteralExpression literal) {
            throw new PredicateAnalyzerException("SqlOperatorImpl ['contains'] cannot be applied to a compound expression");
        }

        @Override
        public QueryExpression notExists() {
            throw new PredicateAnalyzerException("SqlOperatorImpl ['notExists'] cannot be applied to a compound expression");
        }

        @Override
        public QueryExpression like(LiteralExpression literal) {
            throw new PredicateAnalyzerException("SqlOperatorImpl ['like'] cannot be applied to a compound expression");
        }

        @Override
        public QueryExpression notLike(LiteralExpression literal) {
            throw new PredicateAnalyzerException("SqlOperatorImpl ['notLike'] cannot be applied to a compound expression");
        }

        @Override
        public QueryExpression equals(LiteralExpression literal) {
            throw new PredicateAnalyzerException("SqlOperatorImpl ['='] cannot be applied to a compound expression");
        }

        @Override
        public QueryExpression notEquals(LiteralExpression literal) {
            throw new PredicateAnalyzerException("SqlOperatorImpl ['not'] cannot be applied to a compound expression");
        }

        @Override
        public QueryExpression gt(LiteralExpression literal) {
            throw new PredicateAnalyzerException("SqlOperatorImpl ['>'] cannot be applied to a compound expression");
        }

        @Override
        public QueryExpression gte(LiteralExpression literal) {
            throw new PredicateAnalyzerException("SqlOperatorImpl ['>='] cannot be applied to a compound expression");
        }

        @Override
        public QueryExpression lt(LiteralExpression literal) {
            throw new PredicateAnalyzerException("SqlOperatorImpl ['<'] cannot be applied to a compound expression");
        }

        @Override
        public QueryExpression lte(LiteralExpression literal) {
            throw new PredicateAnalyzerException("SqlOperatorImpl ['<='] cannot be applied to a compound expression");
        }

        @Override
        public QueryExpression queryString(String query) {
            throw new PredicateAnalyzerException("QueryString cannot be applied to a compound expression");
        }

        @Override
        public QueryExpression isTrue() {
            throw new PredicateAnalyzerException("isTrue cannot be applied to a compound expression");
        }

        @Override
        public QueryExpression in(LiteralExpression literal) {
            throw new PredicateAnalyzerException("in cannot be applied to a compound expression");
        }

        @Override
        public QueryExpression notIn(LiteralExpression literal) {
            throw new PredicateAnalyzerException("notIn cannot be applied to a compound expression");
        }
    }

    static abstract class QueryExpression
    implements Expression {
        QueryExpression() {
        }

        public abstract QueryBuilders.QueryBuilder builder();

        public boolean isPartial() {
            return false;
        }

        public abstract QueryExpression contains(LiteralExpression var1);

        public abstract QueryExpression not();

        public abstract QueryExpression exists();

        public abstract QueryExpression notExists();

        public abstract QueryExpression like(LiteralExpression var1);

        public abstract QueryExpression notLike(LiteralExpression var1);

        public abstract QueryExpression equals(LiteralExpression var1);

        public abstract QueryExpression in(LiteralExpression var1);

        public abstract QueryExpression notIn(LiteralExpression var1);

        public abstract QueryExpression notEquals(LiteralExpression var1);

        public abstract QueryExpression gt(LiteralExpression var1);

        public abstract QueryExpression gte(LiteralExpression var1);

        public abstract QueryExpression lt(LiteralExpression var1);

        public abstract QueryExpression lte(LiteralExpression var1);

        public abstract QueryExpression queryString(String var1);

        public abstract QueryExpression isTrue();

        public static QueryExpression create(TerminalExpression expression) {
            if (expression instanceof CastExpression) {
                expression = CastExpression.unpack(expression);
            }
            if (expression instanceof NamedFieldExpression) {
                return new SimpleQueryExpression((NamedFieldExpression)expression);
            }
            String message = String.format(Locale.ROOT, "Unsupported expression: [%s]", expression);
            throw new PredicateAnalyzerException(message);
        }
    }

    static interface Expression {
    }

    private static class Visitor
    extends RexVisitorImpl<Expression> {
        private Visitor() {
            super(true);
        }

        public Expression visitInputRef(RexInputRef inputRef) {
            return new NamedFieldExpression(inputRef);
        }

        public Expression visitLiteral(RexLiteral literal) {
            return new LiteralExpression(literal);
        }

        private static boolean supportedRexCall(RexCall call) {
            SqlSyntax syntax = call.getOperator().getSyntax();
            switch (syntax) {
                case BINARY: {
                    switch (call.getKind()) {
                        case CONTAINS: 
                        case AND: 
                        case OR: 
                        case LIKE: 
                        case EQUALS: 
                        case NOT_EQUALS: 
                        case GREATER_THAN: 
                        case GREATER_THAN_OR_EQUAL: 
                        case LESS_THAN: 
                        case LESS_THAN_OR_EQUAL: {
                            return true;
                        }
                    }
                    return false;
                }
                case SPECIAL: {
                    switch (call.getKind()) {
                        case LIKE: 
                        case CAST: 
                        case ITEM: 
                        case OTHER_FUNCTION: {
                            return true;
                        }
                    }
                    return false;
                }
                case FUNCTION: {
                    return true;
                }
                case POSTFIX: {
                    switch (call.getKind()) {
                        case IS_NOT_NULL: 
                        case IS_NULL: {
                            return true;
                        }
                    }
                    return false;
                }
                case PREFIX: {
                    switch (call.getKind()) {
                        case NOT: {
                            return true;
                        }
                    }
                    return false;
                }
                case INTERNAL: {
                    switch (call.getKind()) {
                        case SEARCH: {
                            return Visitor.canBeTranslatedToTermsQuery(call);
                        }
                    }
                    return false;
                }
            }
            return false;
        }

        static boolean canBeTranslatedToTermsQuery(RexCall search) {
            return Visitor.isSearchWithPoints(search) || Visitor.isSearchWithComplementedPoints(search);
        }

        static boolean isSearchWithPoints(RexCall search) {
            RexLiteral literal = (RexLiteral)search.getOperands().get(1);
            Sarg sarg = (Sarg)Objects.requireNonNull(literal.getValueAs(Sarg.class), "Sarg");
            return sarg.isPoints();
        }

        static boolean isSearchWithComplementedPoints(RexCall search) {
            RexLiteral literal = (RexLiteral)search.getOperands().get(1);
            Sarg sarg = (Sarg)Objects.requireNonNull(literal.getValueAs(Sarg.class), "Sarg");
            return sarg.isComplementedPoints();
        }

        public Expression visitCall(RexCall call) {
            SqlSyntax syntax = call.getOperator().getSyntax();
            if (!Visitor.supportedRexCall(call)) {
                String message = String.format(Locale.ROOT, "Unsupported call: [%s]", call);
                throw new PredicateAnalyzerException(message);
            }
            switch (syntax) {
                case BINARY: {
                    return this.binary(call);
                }
                case POSTFIX: {
                    return this.postfix(call);
                }
                case PREFIX: {
                    return this.prefix(call);
                }
                case INTERNAL: {
                    return this.binary(call);
                }
                case SPECIAL: {
                    switch (call.getKind()) {
                        case CAST: {
                            return this.toCastExpression(call);
                        }
                        case LIKE: {
                            return this.binary(call);
                        }
                        case CONTAINS: {
                            return this.binary(call);
                        }
                    }
                    if (call.getOperator().getName().equalsIgnoreCase("ITEM")) {
                        return Visitor.toNamedField((RexLiteral)call.getOperands().get(1));
                    }
                    String message = String.format(Locale.ROOT, "Unsupported call: [%s]", call);
                    throw new PredicateAnalyzerException(message);
                }
                case FUNCTION: {
                    if (!call.getOperator().getName().equalsIgnoreCase("CONTAINS")) break;
                    List operands = this.visitList(call.getOperands());
                    String query = Visitor.convertQueryString(operands.subList(0, operands.size() - 1), (Expression)operands.get(operands.size() - 1));
                    return QueryExpression.create(new NamedFieldExpression()).queryString(query);
                }
            }
            String message = String.format(Locale.ROOT, "Unsupported syntax [%s] for call: [%s]", syntax, call);
            throw new PredicateAnalyzerException(message);
        }

        private static String convertQueryString(List<Expression> fields, Expression query) {
            int index = 0;
            Preconditions.checkArgument((boolean)(query instanceof LiteralExpression), (Object)"Query string must be a string literal");
            String queryString = ((LiteralExpression)query).stringValue();
            LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>();
            for (Expression expr : fields) {
                if (!(expr instanceof NamedFieldExpression)) continue;
                NamedFieldExpression field = (NamedFieldExpression)expr;
                String fieldIndexString = String.format(Locale.ROOT, "$%d", index++);
                fieldMap.put(fieldIndexString, field.getReference());
            }
            try {
                return queryString;
            }
            catch (Exception e) {
                throw new PredicateAnalyzerException(e);
            }
        }

        private QueryExpression prefix(RexCall call) {
            Preconditions.checkArgument((call.getKind() == SqlKind.NOT ? 1 : 0) != 0, (String)"Expected %s got %s", (Object)SqlKind.NOT, (Object)call.getKind());
            if (call.getOperands().size() != 1) {
                String message = String.format(Locale.ROOT, "Unsupported NOT operator: [%s]", call);
                throw new PredicateAnalyzerException(message);
            }
            QueryExpression expr = (QueryExpression)((RexNode)call.getOperands().get(0)).accept((RexVisitor)this);
            return expr.not();
        }

        private QueryExpression postfix(RexCall call) {
            Preconditions.checkArgument((call.getKind() == SqlKind.IS_NULL || call.getKind() == SqlKind.IS_NOT_NULL ? 1 : 0) != 0);
            if (call.getOperands().size() != 1) {
                String message = String.format(Locale.ROOT, "Unsupported operator: [%s]", call);
                throw new PredicateAnalyzerException(message);
            }
            Expression a = (Expression)((RexNode)call.getOperands().get(0)).accept((RexVisitor)this);
            Visitor.isColumn(a, (RexNode)call, "_id", true);
            Visitor.isColumn(a, (RexNode)call, "_index", true);
            QueryExpression operand = QueryExpression.create((TerminalExpression)a);
            return call.getKind() == SqlKind.IS_NOT_NULL ? operand.exists() : operand.notExists();
        }

        private QueryExpression binary(RexCall call) {
            if (call.getKind() == SqlKind.AND || call.getKind() == SqlKind.OR) {
                return this.andOr(call);
            }
            PredicateAnalyzer.checkForIncompatibleDateTimeOperands(call);
            Preconditions.checkState((call.getOperands().size() == 2 ? 1 : 0) != 0);
            Expression a = (Expression)((RexNode)call.getOperands().get(0)).accept((RexVisitor)this);
            Expression b = (Expression)((RexNode)call.getOperands().get(1)).accept((RexVisitor)this);
            SwapResult pair = Visitor.swap(a, b);
            boolean swapped = pair.isSwapped();
            if (Visitor.isColumn(pair.getKey(), (RexNode)call, "_id", false) || Visitor.isColumn(pair.getKey(), (RexNode)call, "_index", false) || Visitor.isColumn(pair.getKey(), (RexNode)call, "_uid", false)) {
                switch (call.getKind()) {
                    case EQUALS: 
                    case NOT_EQUALS: {
                        break;
                    }
                    default: {
                        throw new PredicateAnalyzerException("Cannot handle " + call.getKind() + " expression for _id field, " + call);
                    }
                }
            }
            switch (call.getKind()) {
                case CONTAINS: {
                    return QueryExpression.create(pair.getKey()).contains(pair.getValue());
                }
                case LIKE: {
                    throw new UnsupportedOperationException("LIKE not yet supported");
                }
                case EQUALS: {
                    return QueryExpression.create(pair.getKey()).equals(pair.getValue());
                }
                case NOT_EQUALS: {
                    return QueryExpression.create(pair.getKey()).notEquals(pair.getValue());
                }
                case GREATER_THAN: {
                    if (swapped) {
                        return QueryExpression.create(pair.getKey()).lt(pair.getValue());
                    }
                    return QueryExpression.create(pair.getKey()).gt(pair.getValue());
                }
                case GREATER_THAN_OR_EQUAL: {
                    if (swapped) {
                        return QueryExpression.create(pair.getKey()).lte(pair.getValue());
                    }
                    return QueryExpression.create(pair.getKey()).gte(pair.getValue());
                }
                case LESS_THAN: {
                    if (swapped) {
                        return QueryExpression.create(pair.getKey()).gt(pair.getValue());
                    }
                    return QueryExpression.create(pair.getKey()).lt(pair.getValue());
                }
                case LESS_THAN_OR_EQUAL: {
                    if (swapped) {
                        return QueryExpression.create(pair.getKey()).gte(pair.getValue());
                    }
                    return QueryExpression.create(pair.getKey()).lte(pair.getValue());
                }
                case SEARCH: {
                    if (Visitor.isSearchWithComplementedPoints(call)) {
                        return QueryExpression.create(pair.getKey()).notIn(pair.getValue());
                    }
                    return QueryExpression.create(pair.getKey()).in(pair.getValue());
                }
            }
            String message = String.format(Locale.ROOT, "Unable to handle call: [%s]", call);
            throw new PredicateAnalyzerException(message);
        }

        private QueryExpression andOr(RexCall call) {
            QueryExpression[] expressions = new QueryExpression[call.getOperands().size()];
            PredicateAnalyzerException firstError = null;
            boolean partial = false;
            for (int i = 0; i < call.getOperands().size(); ++i) {
                try {
                    Expression expr = (Expression)((RexNode)call.getOperands().get(i)).accept((RexVisitor)this);
                    if (!(expr instanceof NamedFieldExpression)) {
                        expressions[i] = (QueryExpression)((RexNode)call.getOperands().get(i)).accept((RexVisitor)this);
                    }
                    partial |= expressions[i].isPartial();
                    continue;
                }
                catch (PredicateAnalyzerException e) {
                    if (firstError == null) {
                        firstError = e;
                    }
                    partial = true;
                }
            }
            switch (call.getKind()) {
                case OR: {
                    if (partial) {
                        if (firstError != null) {
                            throw firstError;
                        }
                        String message = String.format(Locale.ROOT, "Unable to handle call: [%s]", call);
                        throw new PredicateAnalyzerException(message);
                    }
                    return CompoundQueryExpression.or(expressions);
                }
                case AND: {
                    return CompoundQueryExpression.and(partial, expressions);
                }
            }
            String message = String.format(Locale.ROOT, "Unable to handle call: [%s]", call);
            throw new PredicateAnalyzerException(message);
        }

        private static SwapResult swap(Expression left, Expression right) {
            TerminalExpression terminal;
            LiteralExpression literal = Visitor.expressAsLiteral(left);
            boolean swapped = false;
            if (literal != null) {
                swapped = true;
                terminal = (TerminalExpression)right;
            } else {
                literal = Visitor.expressAsLiteral(right);
                terminal = (TerminalExpression)left;
            }
            if (literal == null || terminal == null) {
                String message = String.format(Locale.ROOT, "Unexpected combination of expressions [left: %s] [right: %s]", left, right);
                throw new PredicateAnalyzerException(message);
            }
            if (CastExpression.isCastExpression(terminal)) {
                terminal = CastExpression.unpack(terminal);
            }
            return new SwapResult(swapped, terminal, literal);
        }

        private CastExpression toCastExpression(RexCall call) {
            TerminalExpression argument = (TerminalExpression)((RexNode)call.getOperands().get(0)).accept((RexVisitor)this);
            return new CastExpression(call.getType(), argument);
        }

        private static NamedFieldExpression toNamedField(RexLiteral literal) {
            return new NamedFieldExpression(literal);
        }

        private static LiteralExpression expressAsLiteral(Expression exp) {
            if (exp instanceof LiteralExpression) {
                return (LiteralExpression)exp;
            }
            return null;
        }

        private static boolean isColumn(Expression exp, RexNode node, String columnName, boolean throwException) {
            if (!(exp instanceof NamedFieldExpression)) {
                return false;
            }
            NamedFieldExpression termExp = (NamedFieldExpression)exp;
            if (columnName.equals(termExp.getRootName())) {
                if (throwException) {
                    throw new PredicateAnalyzerException("Cannot handle _id field in " + node);
                }
                return true;
            }
            return false;
        }

        private static class SwapResult {
            final boolean swapped;
            final TerminalExpression terminal;
            final LiteralExpression literal;

            SwapResult(boolean swapped, TerminalExpression terminal, LiteralExpression literal) {
                this.swapped = swapped;
                this.terminal = terminal;
                this.literal = literal;
            }

            TerminalExpression getKey() {
                return this.terminal;
            }

            LiteralExpression getValue() {
                return this.literal;
            }

            boolean isSwapped() {
                return this.swapped;
            }
        }
    }

    static class ExpressionNotAnalyzableException
    extends Exception {
        ExpressionNotAnalyzableException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static final class PredicateAnalyzerException
    extends RuntimeException {
        PredicateAnalyzerException(String message) {
            super(message);
        }

        PredicateAnalyzerException(Throwable cause) {
            super(cause);
        }
    }
}

