/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.csv;

import java.util.List;
import org.apache.calcite.adapter.csv.JsonEnumerator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.util.Source;

public class JsonTable
extends AbstractTable {
    private final Source source;
    private RelDataType rowType;
    protected List<Object> dataList;

    public JsonTable(Source source) {
        this.source = source;
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.rowType == null) {
            this.rowType = JsonEnumerator.deduceRowType(typeFactory, this.source).getRelDataType();
        }
        return this.rowType;
    }

    public List<Object> getDataList(RelDataTypeFactory typeFactory) {
        if (this.dataList == null) {
            JsonEnumerator.JsonDataConverter jsonDataConverter = JsonEnumerator.deduceRowType(typeFactory, this.source);
            this.dataList = jsonDataConverter.getDataList();
        }
        return this.dataList;
    }

    public Statistic getStatistic() {
        return Statistics.UNKNOWN;
    }
}

